/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.util.SafeImageExtraction;
import java.util.function.Supplier;

public class Mask
implements ITexSource {
    public static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    @Override
    public Supplier<NativeImage> getSupplier(String inputStr) throws JsonSyntaxException {
        LocationSource locationSource = (LocationSource)gson.fromJson(inputStr, LocationSource.class);
        Supplier<NativeImage> input = DynamicTextureJson.readSupplierFromSource(locationSource.input);
        Supplier<NativeImage> mask = DynamicTextureJson.readSupplierFromSource(locationSource.mask);
        return () -> {
            if (input == null || mask == null) {
                DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...");
                return null;
            }
            try (NativeImage inImg = (NativeImage)input.get();){
                NativeImage nativeImage;
                block27: {
                    NativeImage maskImg;
                    block25: {
                        NativeImage nativeImage2;
                        block26: {
                            block23: {
                                NativeImage nativeImage3;
                                block24: {
                                    maskImg = (NativeImage)mask.get();
                                    if (maskImg != null) break block23;
                                    DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.mask.toString());
                                    nativeImage3 = null;
                                    if (maskImg == null) break block24;
                                    maskImg.close();
                                }
                                return nativeImage3;
                            }
                            if (inImg != null) break block25;
                            DynamicAssetGenerator.LOGGER.error("Texture given was nonexistent...\n{}", (Object)locationSource.input.toString());
                            nativeImage2 = null;
                            if (maskImg == null) break block26;
                            maskImg.close();
                        }
                        return nativeImage2;
                    }
                    try {
                        int iys;
                        int ixs;
                        int mys;
                        int mxs;
                        int maxY;
                        int maxX = Math.max(inImg.m_84982_(), maskImg.m_84982_());
                        int n = maxY = inImg.m_84982_() > maskImg.m_84982_() ? inImg.m_85084_() : maskImg.m_85084_();
                        if ((double)maskImg.m_84982_() / ((double)maskImg.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            mxs = maxX / maskImg.m_84982_();
                            mys = maxY / maskImg.m_84982_();
                        } else {
                            mxs = maxX / maskImg.m_85084_();
                            mys = maxY / maskImg.m_85084_();
                        }
                        if ((double)inImg.m_84982_() / ((double)inImg.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                            ixs = inImg.m_84982_() / maxX;
                            iys = inImg.m_84982_() / maxY;
                        } else {
                            ixs = inImg.m_85084_() / maxX;
                            iys = inImg.m_85084_() / maxY;
                        }
                        NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, maxX, maxY, false);
                        for (int x = 0; x < maxX; ++x) {
                            for (int y = 0; y < maxY; ++y) {
                                ColorHolder mC = ColorHolder.fromColorInt(SafeImageExtraction.get(maskImg, x / mxs, y / mys));
                                ColorHolder iC = ColorHolder.fromColorInt(SafeImageExtraction.get(inImg, x / ixs, y / iys));
                                ColorHolder o = iC.withA(mC.getA() * iC.getA());
                                out.m_84988_(x, y, ColorHolder.toColorInt(o));
                            }
                        }
                        nativeImage = out;
                        if (maskImg == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (maskImg != null) {
                            try {
                                maskImg.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    maskImg.close();
                }
                return nativeImage;
            }
        };
    }

    public static class LocationSource {
        @Expose
        String source_type;
        @Expose
        public JsonObject input;
        @Expose
        public JsonObject mask;
    }
}

