/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.api;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.Pair;
import io.github.lukebemish.dynamic_asset_generator.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.palette.Palette;
import io.github.lukebemish.dynamic_asset_generator.client.util.Clusterer;
import io.github.lukebemish.dynamic_asset_generator.client.util.ImageUtils;
import io.github.lukebemish.dynamic_asset_generator.client.util.SupplierWithException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class PaletteExtractor {
    private static final List<PaletteExtractor> toRefresh = new ArrayList<PaletteExtractor>();
    private boolean fill_holes = false;
    private final boolean[] hasLogged = new boolean[2];
    private final double closeCutoff;
    private final SupplierWithException<NativeImage, IOException> background;
    private final SupplierWithException<NativeImage, IOException> withOverlay;
    public final int extend;
    public final boolean trimTrailingPaletteLookup;
    private final boolean forceOverlayNeighbors;
    private final ThreadLocal<NativeImage> overlayImg = new ThreadLocal();
    private final ThreadLocal<NativeImage> palettedImg = new ThreadLocal();
    private static final float N_CUTOFF_SCALE = 1.5f;

    public static void refresh() {
        for (PaletteExtractor i : toRefresh) {
            i.palettedImg.set(null);
            i.overlayImg.set(null);
        }
    }

    public PaletteExtractor(SupplierWithException<NativeImage, IOException> background, SupplierWithException<NativeImage, IOException> withOverlay, int extend, boolean trimTrailingPaletteLookup, boolean forceOverlayNeighbors, double closeCutoff) {
        this.background = background;
        this.withOverlay = withOverlay;
        this.extend = extend;
        this.trimTrailingPaletteLookup = trimTrailingPaletteLookup;
        this.forceOverlayNeighbors = forceOverlayNeighbors;
        this.closeCutoff = closeCutoff;
        toRefresh.add(this);
    }

    public PaletteExtractor(ResourceLocation background, ResourceLocation withOverlay, int extend, boolean trimTrailingPaletteLookup, boolean forceOverlayNeighbors, double closeCutoff) {
        this(new ImageUtils.ImageGetter(background), new ImageUtils.ImageGetter(withOverlay), extend, trimTrailingPaletteLookup, forceOverlayNeighbors, closeCutoff);
    }

    public PaletteExtractor(ResourceLocation background, ResourceLocation withOverlay, int extend) {
        this(background, withOverlay, extend, false, false, 0.3);
    }

    public PaletteExtractor(ResourceLocation background, ResourceLocation withOverlay, int extend, boolean trimTrailingPaletteLookup, boolean forceOverlayNeighbors) {
        this(background, withOverlay, extend, trimTrailingPaletteLookup, forceOverlayNeighbors, 0.3);
    }

    public NativeImage getOverlayImg() throws IOException {
        if (this.overlayImg.get() == null) {
            this.recalcImages();
        }
        try {
            this.overlayImg.get().m_84985_(0, 0);
        }
        catch (IllegalStateException e) {
            this.overlayImg.get().close();
            if (this.palettedImg.get() != null) {
                this.palettedImg.get().close();
            }
            this.recalcImages();
        }
        return this.overlayImg.get();
    }

    public NativeImage getPalettedImg() throws IOException {
        if (this.palettedImg.get() == null) {
            this.recalcImages();
        }
        try {
            this.palettedImg.get().m_84985_(0, 0);
        }
        catch (IllegalStateException e) {
            this.palettedImg.get().close();
            if (this.overlayImg.get() != null) {
                this.overlayImg.get().close();
            }
            this.recalcImages();
        }
        return this.palettedImg.get();
    }

    private Holder recalcImagesAlternate() throws IOException {
        try (NativeImage b_img = this.background.get();){
            Holder holder;
            block40: {
                Palette fColors;
                Palette nbColors;
                int backgroundPaletteSize;
                Palette backgroundPalette;
                NativeImage p_img;
                NativeImage o_img;
                int ws;
                int bs;
                int dim;
                NativeImage w_img;
                block38: {
                    Holder ig3;
                    block39: {
                        SupplierWithException<NativeImage, IOException> b_c;
                        w_img = this.withOverlay.get();
                        int b_dim = Math.min(b_img.m_85084_(), b_img.m_84982_());
                        int w_dim = Math.min(w_img.m_85084_(), w_img.m_84982_());
                        dim = Math.max(b_dim, w_dim);
                        bs = dim / b_dim;
                        ws = dim / w_dim;
                        o_img = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
                        p_img = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
                        backgroundPalette = Palette.extractPalette(b_img, this.extend);
                        Palette withOverlayPalette = Palette.extractPalette(w_img, 0);
                        backgroundPaletteSize = backgroundPalette.getSize();
                        nbColors = new Palette();
                        withOverlayPalette.getStream().forEach(c -> {
                            if (!backgroundPalette.isInPalette((ColorHolder)c)) {
                                nbColors.tryAdd((ColorHolder)c);
                            }
                        });
                        Clusterer clusterer = Clusterer.createFromPalettes(0.0, Clusterer.Cluster::minDist, backgroundPalette, nbColors);
                        fColors = new Palette();
                        int bgCat = clusterer.getCategory(backgroundPalette.getColor(0));
                        if (nbColors.getSize() != 0) {
                            nbColors.getStream().forEach(c -> {
                                if (clusterer.getCategory((ColorHolder)c) != bgCat) {
                                    fColors.tryAdd((ColorHolder)c);
                                }
                            });
                        }
                        if (fColors.getSize() != 0 && nbColors.getSize() != 0) break block38;
                        for (int x = 0; x < dim; ++x) {
                            for (int y = 0; y < dim; ++y) {
                                o_img.m_84988_(x, y, 0);
                                b_c = ColorHolder.fromColorInt(b_img.m_84985_(x / bs, y / bs));
                                ColorHolder w_c = ColorHolder.fromColorInt(w_img.m_84985_(x / ws, y / ws));
                                int w_i = backgroundPalette.closestTo(w_c);
                                int b_i = backgroundPalette.closestTo((ColorHolder)((Object)b_c));
                                if (w_i != b_i) {
                                    p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)w_i)));
                                    continue;
                                }
                                p_img.m_84988_(x, y, 0);
                            }
                        }
                        Object key = "";
                        b_c = this.background;
                        if (b_c instanceof ImageUtils.ImageGetter) {
                            ImageUtils.ImageGetter ig2 = (ImageUtils.ImageGetter)b_c;
                            key = (String)key + " " + ig2.rl.toString();
                        }
                        if ((b_c = this.withOverlay) instanceof ImageUtils.ImageGetter) {
                            ImageUtils.ImageGetter ig3 = (ImageUtils.ImageGetter)b_c;
                            if (((String)key).length() != 0) {
                                key = (String)key + ",";
                            }
                            key = (String)key + " " + ig3.rl.toString();
                        }
                        if (!this.hasLogged[0]) {
                            DynamicAssetGenerator.LOGGER.warn("Supplied images{} for extraction contained no differing colors; only extracting palette shifts", key);
                        }
                        this.hasLogged[0] = true;
                        ig3 = new Holder(o_img, p_img, false);
                        if (w_img == null) break block39;
                        w_img.close();
                    }
                    return ig3;
                }
                try {
                    int y;
                    int x;
                    for (x = 0; x < dim; ++x) {
                        for (y = 0; y < dim; ++y) {
                            ColorHolder b_c = ColorHolder.fromColorInt(b_img.m_84985_(x / bs, y / bs));
                            ColorHolder w_c = ColorHolder.fromColorInt(w_img.m_84985_(x / ws, y / ws));
                            if (fColors.isInPalette(w_c)) {
                                o_img.m_84988_(x, y, ColorHolder.toColorInt(w_c.withA(1.0f)));
                                continue;
                            }
                            if (backgroundPalette.isInPalette(w_c)) {
                                int b_i;
                                int w_i = backgroundPalette.closestTo(w_c);
                                if (w_i == (b_i = backgroundPalette.closestTo(b_c))) continue;
                                p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)w_i)));
                                continue;
                            }
                            int f_index = 0;
                            int b_index = 0;
                            double lowest = 200.0;
                            float alpha = 0.0f;
                            boolean skipO = false;
                            float a = 0.1f;
                            while (a <= 0.25f) {
                                for (int b = 0; b < backgroundPaletteSize; ++b) {
                                    ColorHolder fColor;
                                    ColorHolder bColor;
                                    for (int f = 0; f < fColors.getSize(); ++f) {
                                        bColor = backgroundPalette.getColor(b);
                                        fColor = fColors.getColor(f);
                                        double dist = w_c.distanceToLab(ColorHolder.alphaBlend(fColor.withA(a), bColor));
                                        if (!(dist < lowest)) continue;
                                        lowest = dist;
                                        alpha = a;
                                        f_index = f;
                                        b_index = b;
                                        skipO = false;
                                    }
                                    for (int b1 = 0; b1 < backgroundPalette.getSize(); ++b1) {
                                        bColor = backgroundPalette.getColor(b);
                                        fColor = backgroundPalette.getColor(b1);
                                        ColorHolder blend = ColorHolder.alphaBlend(fColor.withA(a), bColor);
                                        double dist = w_c.distanceToLab(blend);
                                        if (!(dist < lowest)) continue;
                                        lowest = dist;
                                        alpha = a;
                                        b_index = backgroundPalette.closestTo(blend);
                                        skipO = true;
                                    }
                                }
                                a = (float)((double)a + 0.05);
                            }
                            for (int f = 0; f < fColors.getSize(); ++f) {
                                ColorHolder fColor = fColors.getColor(f);
                                double dist = w_c.distanceToLab(fColor);
                                if (!(dist < lowest)) continue;
                                lowest = dist;
                                alpha = 1.0f;
                                f_index = f;
                                skipO = false;
                            }
                            p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)b_index)));
                            if (!skipO) {
                                o_img.m_84988_(x, y, fColors.getColor(f_index).withA(alpha).toInt());
                            }
                            if (!(alpha >= 1.0f)) continue;
                            p_img.m_84988_(x, y, new ColorHolder(0.0f).withA(0.0f).toInt());
                        }
                    }
                    if (this.trimTrailingPaletteLookup || this.forceOverlayNeighbors) {
                        for (x = 0; x < dim; ++x) {
                            for (y = 0; y < dim; ++y) {
                                boolean hasNeighbor = false;
                                boolean hasFullNeighbor = false;
                                int[] xs = new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
                                int[] ys = new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
                                for (int j = 0; j < xs.length; ++j) {
                                    int xt = x + xs[j];
                                    int yt = y + ys[j];
                                    if (0 > xt || xt >= dim || 0 > yt || yt >= dim) continue;
                                    if (ColorHolder.fromColorInt(o_img.m_84985_(xt, yt)).getA() != 0.0f) {
                                        hasNeighbor = true;
                                    }
                                    if (ColorHolder.fromColorInt(o_img.m_84985_(xt, yt)).getA() != 1.0f) continue;
                                    hasFullNeighbor = true;
                                }
                                if (this.trimTrailingPaletteLookup && !hasNeighbor) {
                                    p_img.m_84988_(x, y, 0);
                                }
                                if (!this.forceOverlayNeighbors || !hasFullNeighbor || ColorHolder.fromColorInt(o_img.m_84985_(x, y)).getA() != 0.0f) continue;
                                ColorHolder w_c = ColorHolder.fromColorInt(w_img.m_84985_(x / ws, y / ws));
                                p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)backgroundPalette.closestTo(w_c))));
                            }
                        }
                    }
                    holder = new Holder(o_img, p_img, nbColors.dist(nbColors) < nbColors.dist(backgroundPalette));
                    if (w_img == null) break block40;
                }
                catch (Throwable throwable) {
                    if (w_img != null) {
                        try {
                            w_img.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                w_img.close();
            }
            return holder;
        }
    }

    private void recalcImages() throws IOException {
        try (NativeImage b_img = this.background.get();
             NativeImage w_img = this.withOverlay.get();){
            SupplierWithException<NativeImage, IOException> w_c;
            int b_dim = Math.min(b_img.m_85084_(), b_img.m_84982_());
            int w_dim = Math.min(w_img.m_85084_(), w_img.m_84982_());
            int dim = Math.max(b_dim, w_dim);
            int bs = dim / b_dim;
            int ws = dim / w_dim;
            NativeImage o_img = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
            NativeImage p_img = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
            Palette backgroundPalette = Palette.extractPalette(b_img, this.extend);
            Palette withOverlayPalette = Palette.extractPalette(w_img, this.extend);
            int backgroundPaletteSize = backgroundPalette.getSize();
            double maxDiff = 0.0;
            for (ColorHolder c1 : withOverlayPalette.getStream().toList()) {
                for (ColorHolder c2 : withOverlayPalette.getStream().toList()) {
                    double diff = c1.distanceToHybrid(c2);
                    if (!(diff > maxDiff)) continue;
                    maxDiff = diff;
                }
            }
            Palette frontColors = new Palette(0.007843138f);
            ArrayList<PostCalcEvent> postQueue = new ArrayList<PostCalcEvent>();
            for (int x = 0; x < dim; ++x) {
                for (int y = 0; y < dim; ++y) {
                    ColorHolder b_c = ColorHolder.fromColorInt(b_img.m_84985_(x / bs, y / bs));
                    w_c = ColorHolder.fromColorInt(w_img.m_84985_(x / ws, y / ws));
                    if (backgroundPalette.isInPalette((ColorHolder)((Object)w_c))) {
                        int b_i;
                        int w_i = backgroundPalette.closestTo((ColorHolder)((Object)w_c));
                        if (w_i == (b_i = backgroundPalette.closestTo(b_c))) continue;
                        p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)w_i)));
                        continue;
                    }
                    int distIndex = backgroundPalette.closestTo((ColorHolder)((Object)w_c));
                    ColorHolder closestP = backgroundPalette.getColor(distIndex);
                    if (closestP.distanceToHybrid((ColorHolder)((Object)w_c)) <= this.closeCutoff * maxDiff * 1.5) {
                        p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)distIndex)));
                        postQueue.add(new PostCalcEvent(x, y, (ColorHolder)((Object)w_c), closestP.distanceToHybrid((ColorHolder)((Object)w_c))));
                        continue;
                    }
                    o_img.m_84988_(x, y, ColorHolder.toColorInt((ColorHolder)((Object)w_c)));
                    frontColors.tryAdd((ColorHolder)((Object)w_c));
                }
            }
            Holder alt = this.recalcImagesAlternate();
            if (frontColors.getSize() == 0) {
                Object key = "";
                w_c = this.background;
                if (w_c instanceof ImageUtils.ImageGetter) {
                    ImageUtils.ImageGetter ig = (ImageUtils.ImageGetter)w_c;
                    key = (String)key + " " + ig.rl.toString();
                }
                if ((w_c = this.withOverlay) instanceof ImageUtils.ImageGetter) {
                    ImageUtils.ImageGetter ig = (ImageUtils.ImageGetter)w_c;
                    if (((String)key).length() != 0) {
                        key = (String)key + ",";
                    }
                    key = (String)key + " " + ig.rl.toString();
                }
                if (!this.hasLogged[1]) {
                    DynamicAssetGenerator.LOGGER.warn("Supplied images{} for extraction contained few differing colors; attempting clustering color extraction.", key);
                }
                this.hasLogged[1] = true;
                this.overlayImg.set(alt.o());
                this.palettedImg.set(alt.p());
                o_img.close();
                p_img.close();
                return;
            }
            for (PostCalcEvent e : postQueue) {
                int x = e.x();
                int y = e.y();
                ColorHolder wColor = e.wColor();
                int f_index = 0;
                int b_index = 0;
                double lowest = 200.0;
                float alpha = 0.0f;
                boolean skipO = false;
                float a = 0.1f;
                while (a <= 0.25f) {
                    for (int b = 0; b < backgroundPaletteSize; ++b) {
                        ColorHolder fColor;
                        ColorHolder bColor;
                        for (int f = 0; f < frontColors.getSize(); ++f) {
                            bColor = backgroundPalette.getColor(b);
                            fColor = frontColors.getColor(f);
                            double dist = wColor.distanceToLab(ColorHolder.alphaBlend(fColor.withA(a), bColor));
                            if (!(dist < lowest)) continue;
                            lowest = dist;
                            alpha = a;
                            f_index = f;
                            b_index = b;
                            skipO = false;
                        }
                        for (int b1 = 0; b1 < backgroundPalette.getSize(); ++b1) {
                            bColor = backgroundPalette.getColor(b);
                            fColor = backgroundPalette.getColor(b1);
                            ColorHolder blend = ColorHolder.alphaBlend(fColor.withA(a), bColor);
                            double dist = wColor.distanceToLab(blend);
                            if (!(dist < lowest)) continue;
                            lowest = dist;
                            alpha = a;
                            b_index = backgroundPalette.closestTo(blend);
                            skipO = true;
                        }
                    }
                    a = (float)((double)a + 0.05);
                }
                for (int f = 0; f < frontColors.getSize(); ++f) {
                    ColorHolder fColor = frontColors.getColor(f);
                    double dist = wColor.distanceToLab(fColor);
                    if (!(dist < lowest)) continue;
                    lowest = dist;
                    alpha = 1.0f;
                    f_index = f;
                    skipO = false;
                }
                p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)b_index)));
                if (!skipO) {
                    o_img.m_84988_(x, y, ColorHolder.toColorInt(frontColors.getColor(f_index).withA(alpha)));
                }
                int frontIndex = frontColors.closestTo(wColor);
                int closeIndex = backgroundPalette.closestTo(wColor);
                if (wColor.distanceToHybrid(backgroundPalette.getColor(closeIndex)) > wColor.distanceToHybrid(frontColors.getColor(frontIndex))) {
                    o_img.m_84988_(x, y, ColorHolder.toColorInt(wColor.withA(1.0f)));
                    alpha = 1.0f;
                }
                if (!(alpha >= 1.0f)) continue;
                p_img.m_84988_(x, y, new ColorHolder(0.0f).withA(0.0f).toInt());
            }
            if (this.trimTrailingPaletteLookup || this.forceOverlayNeighbors) {
                for (int x = 0; x < dim; ++x) {
                    for (int y = 0; y < dim; ++y) {
                        boolean hasNeighbor = false;
                        boolean hasFullNeighbor = false;
                        int[] xs = new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
                        int[] ys = new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
                        for (int j = 0; j < xs.length; ++j) {
                            int xt = x + xs[j];
                            int yt = y + ys[j];
                            if (0 > xt || xt >= dim || 0 > yt || yt >= dim) continue;
                            if (ColorHolder.fromColorInt(o_img.m_84985_(xt, yt)).getA() != 0.0f) {
                                hasNeighbor = true;
                            }
                            if (ColorHolder.fromColorInt(o_img.m_84985_(xt, yt)).getA() != 1.0f) continue;
                            hasFullNeighbor = true;
                        }
                        if (this.trimTrailingPaletteLookup && !hasNeighbor) {
                            p_img.m_84988_(x, y, 0);
                        }
                        if (!this.forceOverlayNeighbors || !hasFullNeighbor || ColorHolder.fromColorInt(o_img.m_84985_(x, y)).getA() != 0.0f) continue;
                        ColorHolder w_c2 = ColorHolder.fromColorInt(w_img.m_84985_(x / ws, y / ws));
                        p_img.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)backgroundPalette.closestTo(w_c2))));
                    }
                }
                if (this.fill_holes) {
                    int x;
                    int s = p_img.m_84982_();
                    List<Pair<Integer, Integer>> toSearch = List.of(new Pair<Integer, Integer>(0, 1), new Pair<Integer, Integer>(0, -1), new Pair<Integer, Integer>(1, 0), new Pair<Integer, Integer>(-1, 0));
                    HashMap<Pair<Integer, Integer>, Float> alphaMap = new HashMap<Pair<Integer, Integer>, Float>();
                    for (x = 0; x < s; ++x) {
                        for (int y = 0; y < s; ++y) {
                            ColorHolder overlay = ColorHolder.fromColorInt(o_img.m_84985_(x, y));
                            alphaMap.put(new Pair<Integer, Integer>(x, y), Float.valueOf(overlay.getA()));
                            if (overlay.getA() != 1.0f || o_img.m_84985_(x, y) == w_img.m_84985_(x, y)) continue;
                            o_img.m_84988_(x, y, ColorHolder.fromColorInt(w_img.m_84985_(x, y)).withA(1.0f).toInt());
                        }
                    }
                    while (true) {
                        block28: for (x = 1; x < s - 1; ++x) {
                            for (int y = 1; y < s - 1; ++y) {
                                ColorHolder overlay = ColorHolder.fromColorInt(o_img.m_84985_(x, y));
                                int count = 0;
                                int partialCount = 0;
                                for (Pair<Integer, Integer> is : toSearch) {
                                    ColorHolder c = ColorHolder.fromColorInt(o_img.m_84985_(x + is.first(), y + is.last()));
                                    if (c.getA() == 1.0f) {
                                        ++count;
                                    }
                                    if (!(c.getA() > 0.0f)) continue;
                                    Pair<Integer, Integer> pair = new Pair<Integer, Integer>(x + is.first(), y + is.last());
                                    if (!(((Float)alphaMap.get(pair)).floatValue() < 1.0f)) continue;
                                    ++partialCount;
                                }
                                ColorHolder origC = ColorHolder.fromColorInt(w_img.m_84985_(x, y));
                                if (overlay.getA() == 1.0f || count < 3 && partialCount < 4 || backgroundPalette.isInPalette(origC, backgroundPalette.getCutoff())) continue;
                                int orig = w_img.m_84985_(x, y);
                                int i = 0;
                                while (true) {
                                    if (i >= s) continue block28;
                                    for (int j = 0; j < s; ++j) {
                                        int c = w_img.m_84985_(i, j);
                                        if (orig != c) continue;
                                        o_img.m_84988_(i, j, origC.withA(1.0f).toInt());
                                    }
                                    ++i;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            this.overlayImg.set(o_img);
            this.palettedImg.set(p_img);
        }
    }

    public PaletteExtractor fillHoles(boolean fill_holes) {
        this.fill_holes = fill_holes;
        return this;
    }

    private record Holder(NativeImage o, NativeImage p, boolean shouldUse) {
    }

    private record PostCalcEvent(int x, int y, ColorHolder wColor, double dist) {
    }
}

