/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.api;

import com.google.common.collect.ImmutableList;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.mixin.IPackRepositoryMixin;
import io.github.lukebemish.dynamic_asset_generator.platform.Services;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;

public class ClientPrePackRepository {
    private static List<? extends PackResources> resources = new ArrayList<PackResources>();
    public static final String SOURCE_JSON_DIR = "dynamic_assets_sources";

    public static void resetResources() {
        resources = null;
    }

    private static List<? extends PackResources> getResources() {
        if (resources == null || resources.size() == 0) {
            resources = Services.DEGROUPER.unpackPacks((List)((IPackRepositoryMixin)Minecraft.m_91087_().m_91099_()).getSelected().stream().filter(p -> !p.m_10446_().contains("dynamic_asset_generator:client") && !p.m_10446_().contains("dynamic_asset_generator:data")).map(Pack::m_10445_).filter(p -> !p.m_8017_().contains("dynamic_asset_generator:client") && !p.m_8017_().contains("dynamic_asset_generator:data")).collect(ImmutableList.toImmutableList()));
        }
        return resources;
    }

    public static InputStream getResource(ResourceLocation rl) throws IOException {
        InputStream resource = null;
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            if (packResources.m_8017_().equals("dynamic_asset_generator:client") || !packResources.m_7211_(PackType.CLIENT_RESOURCES, rl)) continue;
            if (resource != null) {
                resource.close();
            }
            resource = packResources.m_8031_(PackType.CLIENT_RESOURCES, rl);
        }
        if (resource != null) {
            return resource;
        }
        throw new IOException("Could not find resource in pre-load: " + rl.toString());
    }

    public static HashMap<ResourceLocation, String> getSourceJsons() {
        HashMap<ResourceLocation, String> rls = new HashMap<ResourceLocation, String>();
        HashSet<ResourceLocation> available = new HashSet<ResourceLocation>();
        for (PackResources packResources : ClientPrePackRepository.getResources()) {
            if (packResources.m_8017_().equals("dynamic_asset_generator:client") || packResources.m_8017_().equals("dynamic_asset_generator:data")) continue;
            for (String namespace : packResources.m_5698_(PackType.CLIENT_RESOURCES)) {
                for (ResourceLocation rl : packResources.m_7466_(PackType.CLIENT_RESOURCES, namespace, SOURCE_JSON_DIR, 6, x -> x.endsWith(".json"))) {
                    if (!packResources.m_7211_(PackType.CLIENT_RESOURCES, rl)) continue;
                    available.add(rl);
                }
            }
        }
        for (ResourceLocation resourceLocation : available) {
            try {
                InputStream resource = ClientPrePackRepository.getResource(resourceLocation);
                try {
                    String text = new String(resource.readAllBytes(), StandardCharsets.UTF_8);
                    rls.put(resourceLocation, text);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Issues loading texture source jsons...");
            }
        }
        return rls;
    }
}

