/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.ModConfig;
import io.github.lukebemish.dynamic_asset_generator.WrappedSupplier;
import io.github.lukebemish.dynamic_asset_generator.api.ResettingSupplier;
import io.github.lukebemish.dynamic_asset_generator.client.api.ClientPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.client.api.json.DynamicTextureJson;
import io.github.lukebemish.dynamic_asset_generator.client.util.IPalettePlan;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class DynAssetGenClientPlanner {
    private static final Map<ResourceLocation, Supplier<InputStream>> miscResources = new HashMap<ResourceLocation, Supplier<InputStream>>();
    private static final List<Supplier<Map<ResourceLocation, Supplier<InputStream>>>> unresolved = new ArrayList<Supplier<Map<ResourceLocation, Supplier<InputStream>>>>();

    public static void planPaletteCombinedImage(ResourceLocation rl, IPalettePlan image) {
        DynAssetGenClientPlanner.planPaletteCombinedImage(rl, () -> image);
    }

    public static void planPaletteCombinedImage(ResourceLocation rl, Supplier<IPalettePlan> plan_sup) {
        miscResources.put(rl, IPalettePlan.supply(rl, plan_sup));
    }

    public static void planNativeImage(ResourceLocation rl, Supplier<NativeImage> supplier) {
        Supplier<InputStream> s = () -> {
            try (NativeImage image = (NativeImage)supplier.get();){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: {}...\n", (Object)rl, (Object)e);
            }
            return null;
        };
        miscResources.put(rl, ResettingSupplier.of(s, supplier));
    }

    public static Map<ResourceLocation, Supplier<InputStream>> getResources() {
        HashMap<ResourceLocation, Supplier<InputStream>> output = new HashMap<ResourceLocation, Supplier<InputStream>>(miscResources);
        for (Supplier<Map<ResourceLocation, Supplier<InputStream>>> l : unresolved) {
            output.putAll(l.get());
        }
        HashMap<ResourceLocation, String> sources = ClientPrePackRepository.getSourceJsons();
        for (ResourceLocation rl : sources.keySet()) {
            DynamicTextureJson source;
            String s = sources.get(rl);
            if (s == null || (source = DynamicTextureJson.fromJson(s)) == null) continue;
            ResourceLocation orig_rl = ResourceLocation.m_135822_((String)source.output_location, (char)':');
            ResourceLocation out_rl = new ResourceLocation(orig_rl.m_135827_(), "textures/" + orig_rl.m_135815_() + ".png");
            Supplier<InputStream> sup = () -> {
                try (NativeImage image = source.source.get();){
                    if (image == null) return null;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                    return byteArrayInputStream;
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Could not write buffered image to stream: " + out_rl.toString());
                    return null;
                }
                catch (JsonSyntaxException e) {
                    DynamicAssetGenerator.LOGGER.error("Issue loading texture source JSON: " + rl.toString());
                }
                return null;
            };
            output.put(out_rl, sup);
        }
        for (ResourceLocation rl : output.keySet()) {
            Supplier d = (Supplier)output.get(rl);
            if (d instanceof ResettingSupplier) {
                ResettingSupplier rs = (ResettingSupplier)d;
                rs.reset();
            }
            if (!DynamicAssetGenerator.getConfig().cacheAssets || d instanceof WrappedSupplier) continue;
            WrappedSupplier<InputStream> supplier = new WrappedSupplier<InputStream>(() -> DynAssetGenClientPlanner.lambda$getResources$3((Supplier)d, rl));
            output.put(rl, supplier);
        }
        return output;
    }

    public static void planLoadingStream(ResourceLocation location, Supplier<InputStream> sup) {
        if (DynamicAssetGenerator.getConfig().cacheAssets) {
            try {
                if (!Files.exists(ModConfig.ASSET_CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectories(ModConfig.ASSET_CACHE_FOLDER, new FileAttribute[0]);
                }
                if (Files.exists(ModConfig.ASSET_CACHE_FOLDER.resolve(location.m_135827_()).resolve(location.m_135815_()), new LinkOption[0])) {
                    miscResources.put(location, () -> {
                        try {
                            File file = ModConfig.ASSET_CACHE_FOLDER.resolve(location.m_135827_()).resolve(location.m_135815_()).toFile();
                            if (file.isFile()) {
                                return new BufferedInputStream(new FileInputStream(file));
                            }
                        }
                        catch (IOException e) {
                            DynamicAssetGenerator.LOGGER.error("Issue with cached asset...", (Throwable)e);
                        }
                        return null;
                    });
                    return;
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not cache asset...", (Throwable)e);
            }
        }
        miscResources.put(location, sup);
    }

    public static void planLoaders(Supplier<Map<ResourceLocation, Supplier<InputStream>>> suppliers) {
        unresolved.add(() -> {
            Map map = (Map)suppliers.get();
            HashMap<ResourceLocation, Supplier> out = new HashMap<ResourceLocation, Supplier>();
            for (ResourceLocation location : map.keySet()) {
                if (DynamicAssetGenerator.getConfig().cacheData) {
                    try {
                        if (!Files.exists(ModConfig.DATA_CACHE_FOLDER, new LinkOption[0])) {
                            Files.createDirectories(ModConfig.DATA_CACHE_FOLDER, new FileAttribute[0]);
                        }
                        if (Files.exists(ModConfig.DATA_CACHE_FOLDER.resolve(location.m_135827_()).resolve(location.m_135815_()), new LinkOption[0])) {
                            out.put(location, () -> {
                                try {
                                    File file = ModConfig.DATA_CACHE_FOLDER.resolve(location.m_135827_()).resolve(location.m_135815_()).toFile();
                                    if (file.isFile()) {
                                        return new BufferedInputStream(new FileInputStream(file));
                                    }
                                }
                                catch (IOException e) {
                                    DynamicAssetGenerator.LOGGER.error("Could not load cached data...", (Throwable)e);
                                }
                                return null;
                            });
                            continue;
                        }
                    }
                    catch (IOException e) {
                        DynamicAssetGenerator.LOGGER.error("Could not cache data...", (Throwable)e);
                    }
                }
                out.put(location, (Supplier)map.get(location));
            }
            return out;
        });
    }

    private static /* synthetic */ InputStream lambda$getResources$3(Supplier d, ResourceLocation rl) {
        InputStream stream = (InputStream)d.get();
        if (stream != null) {
            try {
                Path path = ModConfig.ASSET_CACHE_FOLDER.resolve(rl.m_135827_()).resolve(rl.m_135815_());
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
                }
                return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not save asset...", (Throwable)e);
            }
        }
        return stream;
    }
}

