/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import java.util.function.Supplier;

public interface ResettingSupplier<T>
extends Supplier<T> {
    public void reset();

    public static <R> ResettingSupplier<R> of(final Supplier<R> s, final Runnable r) {
        return new ResettingSupplier<R>(){

            @Override
            public void reset() {
                r.run();
            }

            @Override
            public R get() {
                return s.get();
            }
        };
    }

    public static <R> ResettingSupplier<R> of(Supplier<R> s, Object creator) {
        if (creator instanceof ResettingSupplier) {
            ResettingSupplier rs = (ResettingSupplier)creator;
            return ResettingSupplier.of(s, rs::reset);
        }
        return ResettingSupplier.of(s, () -> {});
    }
}

