/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.deposit;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;

public class DepositSample {
    private final Deposit.Size size;
    private final Deposit.Altitude altitude;
    private final Deposit.Rarity rarity;

    public DepositSample(Deposit.Size size, Deposit.Altitude altitude, Deposit.Rarity rarity) {
        this.size = size;
        this.altitude = altitude;
        this.rarity = rarity;
    }

    public int getRarity(float factor) {
        return CommonMath.Interpolation.up((float)factor, (IntBounds)this.rarity);
    }

    public Deposit.Size size() {
        return this.size;
    }

    public Deposit.Altitude altitude() {
        return this.altitude;
    }

    public Deposit.Rarity rarity() {
        return this.rarity;
    }

    public DepositSample withAltitude(int min, int max) {
        return new DepositSample(this.size(), new Deposit.Altitude(min, max), this.rarity());
    }
}

