/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adlods.Commands;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.init.Features;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaController;
import com.mojang.brigadier.arguments.ArgumentType;
import java.nio.file.Path;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adlods")
public class AdLods
extends AbstractForgeMod {
    public static final String ID = "adlods";
    public static final String NAME = "Large Ore Deposits";
    private static AdLods instance;
    public final Features features;

    public AdLods() {
        instance = this;
        this.features = new Features(this);
        this.mainConfigInit();
        this.getForgeEventBus().addListener(this::levelLoaded);
    }

    public static AdLods getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public AbstractForgeMod.RequiredSide getRequiredSide() {
        return AbstractForgeMod.RequiredSide.SERVER;
    }

    public void commonInit() {
    }

    public void mainConfigInit() {
        UnitConfig config = UnitConfig.in((Path)this.getConfigsDir(), (String)this.getId());
        String category = "Server";
        String deposits = Names.dotted().join(new String[]{"Server", "Deposits"});
        Deposit.globalSizeMultiplier = Float.valueOf(config.getFloat(deposits, "globalSizeMultiplier", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)), "Size multiplier to be applied to all deposits."));
        Deposit.globalSpawnRateMultiplier = Float.valueOf(config.getFloat(deposits, "globalSpawnRateMultiplier", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)), "Spawn rate multiplier to be applied to all deposits."));
        String veins = Names.dotted().join(new String[]{"Server", "Veins"});
        VanillaController.disableLargeVeins = config.getBool(veins, "disableVanillaLargeVeins", false, "Disables all large ore veins generated by the vanilla noise generator");
        String indicators = Names.dotted().join(new String[]{"Server", "Indicators"});
        Indicator.enabled = config.getBool(indicators, "enabled", true, "Enables/disables all above-ground indicators");
        Indicator.alwaysOnCeiling = config.getBool(indicators, "alwaysOnCeiling", false, "If enabled and the dimension has a ceiling (e.g. the Nether), the indicators will only spawn on the top surface of the ceiling");
        config.save();
    }

    public void commonPostInit() {
        super.commonPostInit();
        this.features.reload();
    }

    public void updateReloadedTags() {
        this.features.reload();
    }

    public void levelLoaded(WorldEvent.Load event) {
        if (!event.getWorld().m_5776_()) {
            this.features.reload();
        }
    }

    protected void serverStopped(MinecraftServer server) {
        this.features.controller.get().unloadOres();
    }

    public void registerCommands(ServerCommand command) {
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listDeposits, "deposits").executes(Commands::listGenerated, "generated");
        command.task("locate").executes(Commands::locateConfigs, "configs");
        command.task("add").executes(context -> Commands.addDeposit(context, false), new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("addspec").executes(context -> Commands.addDeposit(context, true), new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS), ServerCommand.Arg.of((String)"oreId", (ArgumentType)BlockStateArgument.m_116120_())});
        command.task("remove").executes(Commands::removeDeposit, new ServerCommand.Arg[]{Commands.depositArgument()});
        command.task("gen").executes(Commands::generateDeposit, new ServerCommand.Arg[]{Commands.depositArgument()}).executes(Commands::generateDepositAtChunk, new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("genat").executes(Commands::generateDepositAtPos, new ServerCommand.Arg[]{ServerCommand.Arg.integer((String)"posX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"posZ", (IntBounds)IntBounds.INTEGER), Commands.depositArgument()});
        command.task("test").executes(Commands::testDeposit, new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"amount", (IntBounds)Deposit.Size.BOUNDS)});
        command.task("reload").executes(Commands::reloadConfigs, new ServerCommand.Arg[0]);
        command.task("strip").executes(Commands::stripChunk, "chunk").executes(Commands::stripChunksAround, "around");
        command.task("dress").executes(Commands::dressChunk, "chunk").executes(Commands::dressChunksAround, "around").executes(Commands::dressAllChunks, "all");
        command.register();
    }
}

