/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.parsing;

import io.wispforest.owo.ui.component.ColorPickerComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.component.SpriteComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UIParsing {
    private static final Map<String, Function<Element, Component>> COMPONENT_FACTORIES = new HashMap<String, Function<Element, Component>>();

    public static void registerFactory(String componentTagName, Function<Element, Component> factory) {
        if (COMPONENT_FACTORIES.containsKey(componentTagName)) {
            throw new IllegalStateException("A component factory with name " + componentTagName + " is already registered");
        }
        COMPONENT_FACTORIES.put(componentTagName, factory);
    }

    public static Function<Element, Component> getFactory(Element element) {
        Function<Element, Component> factory = COMPONENT_FACTORIES.get(element.getNodeName());
        if (factory == null) {
            throw new UIModelParsingException("Unknown component type: " + element.getNodeName());
        }
        return factory;
    }

    public static <T extends Node> List<T> allChildrenOfType(Element element, short type) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node child = element.getChildNodes().item(i);
            if (child.getNodeType() != type) continue;
            list.add(child);
        }
        return list;
    }

    public static Map<String, Element> childElements(Element element) {
        NodeList children = element.getChildNodes();
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (map.containsKey(child.getNodeName())) {
                throw new UIModelParsingException("Duplicate child " + child.getNodeName() + " in element " + element.getNodeName());
            }
            map.put(child.getNodeName(), (Element)child);
        }
        return map;
    }

    public static int parseSignedInt(Node node) {
        return UIParsing.parseInt(node, true);
    }

    public static int parseUnsignedInt(Node node) {
        return UIParsing.parseInt(node, false);
    }

    public static float parseFloat(Node node) {
        String data = node.getTextContent().strip();
        if (data.matches("-?\\d+(\\.\\d+)?")) {
            return Float.parseFloat(data);
        }
        throw new UIModelParsingException("Invalid value '" + data + "', expected a floating point number");
    }

    public static double parseDouble(Node node) {
        String data = node.getTextContent().strip();
        if (data.matches("-?\\d+(\\.\\d+)?")) {
            return Double.parseDouble(data);
        }
        throw new UIModelParsingException("Invalid value '" + data + "', expected a double-precision floating point number");
    }

    public static boolean parseBool(Node node) {
        return node.getTextContent().strip().equalsIgnoreCase("true");
    }

    public static class_2960 parseIdentifier(Node node) {
        try {
            return new class_2960(node.getTextContent().strip());
        }
        catch (class_151 exception) {
            throw new UIModelParsingException("Invalid identifier '" + node.getTextContent() + "'", exception);
        }
    }

    public static class_2561 parseText(Element element) {
        return element.getAttribute("translate").equalsIgnoreCase("true") ? class_2561.method_43471((String)element.getTextContent()) : class_2561.method_43470((String)element.getTextContent());
    }

    public static <E extends Enum<E>> Function<Element, E> parseEnum(Class<E> enumClass) {
        return element -> {
            String name = element.getTextContent().strip().toUpperCase(Locale.ROOT).replace('-', '_');
            for (Enum value : (Enum[])enumClass.getEnumConstants()) {
                if (!Objects.equals(name, value.name())) continue;
                return value;
            }
            throw new UIModelParsingException("No such constant " + name + " in enum " + enumClass.getSimpleName());
        };
    }

    public static <T, E extends Node> Optional<T> get(Map<String, E> properties, String key, Function<E, T> parser) {
        if (!properties.containsKey(key)) {
            return Optional.empty();
        }
        return Optional.of(parser.apply((Node)properties.get(key)));
    }

    public static <T, E extends Node> void apply(Map<String, E> properties, String key, Function<E, T> parser, Consumer<T> consumer) {
        if (!properties.containsKey(key)) {
            return;
        }
        consumer.accept(parser.apply((Node)properties.get(key)));
    }

    public static void expectAttributes(Element element, String ... attributes) {
        for (String attr : attributes) {
            if (element.hasAttribute(attr)) continue;
            throw new UIModelParsingException("Element '" + element.getNodeName() + "' is missing attribute '" + attr + "'");
        }
    }

    public static void expectChildren(Element element, Map<String, Element> children, String ... expected) {
        for (String childName : expected) {
            if (children.containsKey(childName)) continue;
            throw new UIModelParsingException("Element '" + element.getNodeName() + "' is missing element '" + childName + "'");
        }
    }

    protected static int parseInt(Node node, boolean allowNegative) {
        String data = node.getTextContent().strip();
        if (data.matches((allowNegative ? "-?" : "") + "\\d+")) {
            return Integer.parseInt(data);
        }
        throw new UIModelParsingException("Invalid value '" + data + "', expected " + (allowNegative ? "" : "positive") + " integer");
    }

    static {
        UIParsing.registerFactory("flow-layout", FlowLayout::parse);
        UIParsing.registerFactory("grid-layout", GridLayout::parse);
        UIParsing.registerFactory("scroll", ScrollContainer::parse);
        UIParsing.registerFactory("collapsible", CollapsibleContainer::parse);
        UIParsing.registerFactory("draggable", element -> Containers.draggable(Sizing.content(), Sizing.content(), null));
        UIParsing.registerFactory("sprite", SpriteComponent::parse);
        UIParsing.registerFactory("texture", TextureComponent::parse);
        UIParsing.registerFactory("entity", EntityComponent::parse);
        UIParsing.registerFactory("item", element -> Components.item(class_1799.field_8037));
        UIParsing.registerFactory("label", element -> Components.label((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory("box", element -> Components.box(Sizing.content(), Sizing.content()));
        UIParsing.registerFactory("button", element -> Components.button((class_2561)class_2561.method_43473(), button -> {}));
        UIParsing.registerFactory("checkbox", element -> Components.checkbox((class_2561)class_2561.method_43473()));
        UIParsing.registerFactory("text-box", element -> Components.textBox(Sizing.content()));
        UIParsing.registerFactory("slider", element -> Components.slider(Sizing.content()));
        UIParsing.registerFactory("discrete-slider", DiscreteSliderComponent::parse);
        UIParsing.registerFactory("dropdown", element -> Components.dropdown(Sizing.content()));
        UIParsing.registerFactory("color-picker", element -> new ColorPickerComponent());
    }
}

