/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.client.OwoClient;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.Drawer;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_8002;
import org.joml.Matrix4f;
import org.w3c.dom.Element;

public interface Surface {
    public static final Surface PANEL = (matrices, component) -> Drawer.drawPanel(matrices, component.x(), component.y(), component.width(), component.height(), false);
    public static final Surface DARK_PANEL = (matrices, component) -> Drawer.drawPanel(matrices, component.x(), component.y(), component.width(), component.height(), true);
    public static final Surface VANILLA_TRANSLUCENT = (matrices, component) -> Drawer.drawGradientRect(matrices, component.x(), component.y(), component.width(), component.height(), -1072689136, -1072689136, -804253680, -804253680);
    public static final Surface OPTIONS_BACKGROUND = (matrices, component) -> {
        RenderSystem.setShaderTexture((int)0, (class_2960)Drawer.field_22735);
        RenderSystem.setShaderColor((float)0.2509804f, (float)0.2509804f, (float)0.2509804f, (float)1.0f);
        Drawer.method_25290((class_4587)matrices, (int)component.x(), (int)component.y(), (float)0.0f, (float)0.0f, (int)component.width(), (int)component.height(), (int)32, (int)32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    };
    public static final Surface TOOLTIP = (matrices, component) -> {
        class_287 buffer = class_289.method_1348().method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_8002.method_47946(Drawer::fillGradient, (Matrix4f)matrices.method_23760().method_23761(), (class_287)buffer, (int)(component.x() + 4), (int)(component.y() + 4), (int)(component.width() - 8), (int)(component.height() - 8), (int)0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289.method_1348().method_1350();
    };
    public static final Surface BLANK = (matrices, component) -> {};

    public static Surface blur(float quality, float size) {
        return (matrices, component) -> {
            class_287 buffer = class_289.method_1348().method_1349();
            Matrix4f matrix = matrices.method_23760().method_23761();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
            buffer.method_22918(matrix, (float)component.x(), (float)component.y(), 0.0f).method_1344();
            buffer.method_22918(matrix, (float)component.x(), (float)(component.y() + component.height()), 0.0f).method_1344();
            buffer.method_22918(matrix, (float)(component.x() + component.width()), (float)(component.y() + component.height()), 0.0f).method_1344();
            buffer.method_22918(matrix, (float)(component.x() + component.width()), (float)component.y(), 0.0f).method_1344();
            OwoClient.BLUR_PROGRAM.setParameters(16, quality, size);
            OwoClient.BLUR_PROGRAM.use();
            class_289.method_1348().method_1350();
        };
    }

    public static Surface flat(int color) {
        return (matrices, component) -> Drawer.method_25294((class_4587)matrices, (int)component.x(), (int)component.y(), (int)(component.x() + component.width()), (int)(component.y() + component.height()), (int)color);
    }

    public static Surface outline(int color) {
        return (matrices, component) -> Drawer.drawRectOutline(matrices, component.x(), component.y(), component.width(), component.height(), color);
    }

    public static Surface tiled(class_2960 texture, int textureWidth, int textureHeight) {
        return (matrices, component) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            Drawer.method_25290((class_4587)matrices, (int)component.x(), (int)component.y(), (float)0.0f, (float)0.0f, (int)component.width(), (int)component.height(), (int)textureWidth, (int)textureHeight);
        };
    }

    public void draw(class_4587 var1, ParentComponent var2);

    default public Surface and(Surface surface) {
        return (matrices, component) -> {
            this.draw(matrices, component);
            surface.draw(matrices, component);
        };
    }

    public static Surface parse(Element surfaceElement) {
        List<Element> children = UIParsing.allChildrenOfType(surfaceElement, (short)1);
        Surface surface = BLANK;
        for (Element child : children) {
            surface = switch (child.getNodeName()) {
                case "panel" -> surface.and(child.getAttribute("dark").equalsIgnoreCase("true") ? DARK_PANEL : PANEL);
                case "tiled" -> {
                    UIParsing.expectAttributes(child, "texture-width", "texture-height");
                    yield surface.and(Surface.tiled(UIParsing.parseIdentifier(child), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(child.getAttributeNode("texture-height"))));
                }
                case "options-background" -> surface.and(OPTIONS_BACKGROUND);
                case "vanilla-translucent" -> surface.and(VANILLA_TRANSLUCENT);
                case "tooltip" -> surface.and(TOOLTIP);
                case "outline" -> surface.and(Surface.outline(Color.parseAndPack(child)));
                case "flat" -> surface.and(Surface.flat(Color.parseAndPack(child)));
                default -> throw new UIModelParsingException("Unknown surface type '" + child.getNodeName() + "'");
            };
        }
        return surface;
    }
}

