/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.MountingHelper;
import io.wispforest.owo.util.Observable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4587;
import org.apache.commons.lang3.mutable.MutableInt;
import org.w3c.dom.Element;

public class FlowLayout
extends BaseParentComponent {
    protected final List<Component> children = new ArrayList<Component>();
    protected final List<Component> childrenView = Collections.unmodifiableList(this.children);
    protected final Algorithm algorithm;
    protected Size contentSize = Size.zero();
    protected Observable<Integer> gap = Observable.of(0);

    protected FlowLayout(Sizing horizontalSizing, Sizing verticalSizing, Algorithm algorithm) {
        super(horizontalSizing, verticalSizing);
        this.algorithm = algorithm;
        this.gap.observe(integer -> this.updateLayout());
    }

    @Deprecated(forRemoval=true)
    protected FlowLayout(Sizing horizontalSizing, Sizing verticalSizing) {
        this(horizontalSizing, verticalSizing, container -> {
            throw new IllegalStateException("Deprecated FlowLayout constructor used, no layout algorithm provided");
        });
        Owo.debugWarn(Owo.LOGGER, "Deprecated FlowLayout constructor invoked without providing a layout algorithm, this will crash");
    }

    @Override
    protected int determineHorizontalContentSize(Sizing sizing) {
        return this.contentSize.width() + ((Insets)this.padding.get()).horizontal();
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        return this.contentSize.height() + ((Insets)this.padding.get()).vertical();
    }

    @Override
    public void layout(Size space) {
        this.algorithm.layout(this);
    }

    public FlowLayout child(Component child) {
        this.children.add(child);
        this.updateLayout();
        return this;
    }

    public FlowLayout children(Collection<Component> children) {
        this.children.addAll(children);
        this.updateLayout();
        return this;
    }

    public FlowLayout child(int index, Component child) {
        this.children.add(index, child);
        this.updateLayout();
        return this;
    }

    public FlowLayout children(int index, Collection<Component> children) {
        this.children.addAll(index, children);
        this.updateLayout();
        return this;
    }

    @Override
    public FlowLayout removeChild(Component child) {
        if (this.children.remove(child)) {
            child.dismount(Component.DismountReason.REMOVED);
            this.updateLayout();
        }
        return this;
    }

    public FlowLayout clearChildren() {
        for (Component child : this.children) {
            child.dismount(Component.DismountReason.REMOVED);
        }
        this.children.clear();
        this.updateLayout();
        return this;
    }

    @Override
    public List<Component> children() {
        return this.childrenView;
    }

    public FlowLayout gap(int gap) {
        this.gap.set(gap);
        return this;
    }

    public int gap() {
        return this.gap.get();
    }

    @Override
    public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(matrices, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(matrices, mouseX, mouseY, partialTicks, delta, this.children);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "gap", UIParsing::parseSignedInt, this::gap);
        List components = UIParsing.get(children, "children", e -> UIParsing.allChildrenOfType(e, (short)1)).orElse(Collections.emptyList());
        for (Element child : components) {
            this.child(model.parseComponent(Component.class, child));
        }
    }

    public static FlowLayout parse(Element element) {
        UIParsing.expectAttributes(element, "direction");
        return element.getAttribute("direction").equals("vertical") ? Containers.verticalFlow(Sizing.content(), Sizing.content()) : Containers.horizontalFlow(Sizing.content(), Sizing.content());
    }

    @FunctionalInterface
    public static interface Algorithm {
        public static final Algorithm HORIZONTAL = container -> {
            MutableInt layoutWidth = new MutableInt(0);
            MutableInt layoutHeight = new MutableInt(0);
            ArrayList layout = new ArrayList();
            Insets padding = (Insets)container.padding.get();
            Size childSpace = container.calculateChildSpace(container.space);
            container.children.forEach(child -> child.inflate(childSpace));
            MountingHelper mountState = MountingHelper.mountEarly((x$0, x$1, x$2) -> container.mountChild(x$0, x$1, x$2), container.children, childSpace, child -> {
                layout.add(child);
                child.mount(container, container.x + padding.left() + ((Insets)child.margins().get()).left() + layoutWidth.intValue(), container.y + padding.top() + ((Insets)child.margins().get()).top());
                Size childSize = child.fullSize();
                layoutWidth.add(childSize.width() + container.gap());
                if (childSize.height() > layoutHeight.intValue()) {
                    layoutHeight.setValue(childSize.height());
                }
            });
            layoutWidth.subtract(container.gap());
            container.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
            container.applySizing();
            if (container.verticalAlignment() != VerticalAlignment.TOP) {
                for (Component component : layout) {
                    component.updateY(component.y() + container.verticalAlignment().align(component.fullSize().height(), container.height - padding.vertical()));
                }
            }
            if (container.horizontalAlignment() != HorizontalAlignment.LEFT) {
                for (Component component : layout) {
                    if (container.horizontalAlignment() == HorizontalAlignment.CENTER) {
                        component.updateX(component.x() + (container.width - padding.horizontal() - layoutWidth.intValue()) / 2);
                        continue;
                    }
                    component.updateX(component.x() + (container.width - padding.horizontal() - layoutWidth.intValue()));
                }
            }
            mountState.mountLate();
        };
        public static final Algorithm VERTICAL = container -> {
            MutableInt layoutHeight = new MutableInt(0);
            MutableInt layoutWidth = new MutableInt(0);
            ArrayList layout = new ArrayList();
            Insets padding = (Insets)container.padding.get();
            Size childSpace = container.calculateChildSpace(container.space);
            container.children.forEach(child -> child.inflate(childSpace));
            MountingHelper mountState = MountingHelper.mountEarly((x$0, x$1, x$2) -> container.mountChild(x$0, x$1, x$2), container.children, childSpace, child -> {
                layout.add(child);
                child.mount(container, container.x + padding.left() + ((Insets)child.margins().get()).left(), container.y + padding.top() + ((Insets)child.margins().get()).top() + layoutHeight.intValue());
                Size childSize = child.fullSize();
                layoutHeight.add(childSize.height() + container.gap());
                if (childSize.width() > layoutWidth.intValue()) {
                    layoutWidth.setValue(childSize.width());
                }
            });
            layoutHeight.subtract(container.gap());
            container.contentSize = Size.of(layoutWidth.intValue(), layoutHeight.intValue());
            container.applySizing();
            if (container.horizontalAlignment() != HorizontalAlignment.LEFT) {
                for (Component component : layout) {
                    component.updateX(component.x() + container.horizontalAlignment().align(component.fullSize().width(), container.width - padding.horizontal()));
                }
            }
            if (container.verticalAlignment() != VerticalAlignment.TOP) {
                for (Component component : layout) {
                    if (container.verticalAlignment() == VerticalAlignment.CENTER) {
                        component.updateY(component.y() + (container.height - padding.vertical() - layoutHeight.intValue()) / 2);
                        continue;
                    }
                    component.updateY(component.y() + (container.height - padding.vertical() - layoutHeight.intValue()));
                }
            }
            mountState.mountLate();
        };

        public void layout(FlowLayout var1);
    }
}

