/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.Drawer;
import io.wispforest.owo.util.pond.OwoTextRendererExtension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.w3c.dom.Element;

public class LabelComponent
extends BaseComponent {
    protected final class_327 textRenderer;
    protected class_2561 text;
    protected List<class_5481> wrappedText;
    protected VerticalAlignment verticalTextAlignment;
    protected HorizontalAlignment horizontalTextAlignment;
    protected final AnimatableProperty<Color> color;
    protected boolean shadow;
    protected int maxWidth;

    protected LabelComponent(class_2561 text) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.verticalTextAlignment = VerticalAlignment.TOP;
        this.horizontalTextAlignment = HorizontalAlignment.LEFT;
        this.color = AnimatableProperty.of(Color.WHITE);
        this.text = text;
        this.wrappedText = new ArrayList<class_5481>();
        this.shadow = false;
        this.maxWidth = Integer.MAX_VALUE;
    }

    public LabelComponent text(class_2561 text) {
        this.text = text;
        this.notifyParentIfMounted();
        return this;
    }

    public class_2561 text() {
        return this.text;
    }

    public LabelComponent maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.notifyParentIfMounted();
        return this;
    }

    public int maxWidth() {
        return this.maxWidth;
    }

    public LabelComponent shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean shadow() {
        return this.shadow;
    }

    public LabelComponent color(Color color) {
        this.color.set(color);
        return this;
    }

    public AnimatableProperty<Color> color() {
        return this.color;
    }

    public LabelComponent verticalTextAlignment(VerticalAlignment verticalAlignment) {
        this.verticalTextAlignment = verticalAlignment;
        return this;
    }

    public VerticalAlignment verticalTextAlignment() {
        return this.verticalTextAlignment;
    }

    public LabelComponent horizontalTextAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalTextAlignment = horizontalAlignment;
        return this;
    }

    public HorizontalAlignment horizontalTextAlignment() {
        return this.horizontalTextAlignment;
    }

    @Override
    protected int determineHorizontalContentSize(Sizing sizing) {
        int widestText = 0;
        for (class_5481 line : this.wrappedText) {
            int width = this.textRenderer.method_30880(line);
            if (width <= widestText) continue;
            widestText = width;
        }
        if (widestText > this.maxWidth) {
            this.wrapLines();
            return this.determineHorizontalContentSize(sizing);
        }
        return widestText;
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        this.wrapLines();
        int n = this.wrappedText.size();
        Objects.requireNonNull(this.textRenderer);
        return n * (9 + 2) - 2;
    }

    @Override
    public void inflate(Size space) {
        this.wrapLines();
        super.inflate(space);
    }

    private void wrapLines() {
        this.wrappedText = this.textRenderer.method_1728((class_5348)this.text, ((Sizing)this.horizontalSizing.get()).isContent() ? this.maxWidth : this.width);
    }

    @Override
    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.color.update(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        try {
            int x = this.x;
            int y = this.y;
            if (((Sizing)this.horizontalSizing.get()).isContent()) {
                x += ((Sizing)this.horizontalSizing.get()).value;
            }
            if (((Sizing)this.verticalSizing.get()).isContent()) {
                y += ((Sizing)this.verticalSizing.get()).value;
            }
            switch (this.verticalTextAlignment) {
                case CENTER: {
                    int n = this.wrappedText.size();
                    Objects.requireNonNull(this.textRenderer);
                    y += (this.height - (n * (9 + 2) - 2)) / 2;
                    break;
                }
                case BOTTOM: {
                    int n = this.wrappedText.size();
                    Objects.requireNonNull(this.textRenderer);
                    y += this.height - (n * (9 + 2) - 2);
                }
            }
            ((OwoTextRendererExtension)this.textRenderer).owo$beginCache();
            for (int i = 0; i < this.wrappedText.size(); ++i) {
                class_5481 renderText = this.wrappedText.get(i);
                int renderX = x;
                switch (this.horizontalTextAlignment) {
                    case CENTER: {
                        renderX += (this.width - this.textRenderer.method_30880(renderText)) / 2;
                        break;
                    }
                    case RIGHT: {
                        renderX += this.width - this.textRenderer.method_30880(renderText);
                    }
                }
                if (this.shadow) {
                    this.textRenderer.method_27517(matrices, renderText, (float)renderX, (float)(y + i * 11), ((Color)this.color.get()).argb());
                    continue;
                }
                this.textRenderer.method_27528(matrices, renderText, (float)renderX, (float)(y + i * 11), ((Color)this.color.get()).argb());
            }
        }
        finally {
            ((OwoTextRendererExtension)this.textRenderer).owo$submitCache();
        }
    }

    @Override
    public void drawTooltip(class_4587 matrices, int mouseX, int mouseY, float partialTicks, float delta) {
        super.drawTooltip(matrices, mouseX, mouseY, partialTicks, delta);
        if (!this.isInBoundingBox(mouseX, mouseY)) {
            return;
        }
        Drawer.utilityScreen().method_25418(matrices, this.text.method_10866(), mouseX, mouseY);
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        return Drawer.utilityScreen().method_25430(this.text.method_10866()) | super.onMouseDown(mouseX, mouseY, button);
    }

    @Override
    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "text", UIParsing::parseText, this::text);
        UIParsing.apply(children, "max-width", UIParsing::parseUnsignedInt, this::maxWidth);
        UIParsing.apply(children, "color", Color::parse, this::color);
        UIParsing.apply(children, "shadow", UIParsing::parseBool, this::shadow);
        UIParsing.apply(children, "vertical-text-alignment", VerticalAlignment::parse, this::verticalTextAlignment);
        UIParsing.apply(children, "horizontal-text-alignment", HorizontalAlignment::parse, this::horizontalTextAlignment);
    }
}

