/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.mixin.ui.ButtonWidgetAccessor;
import io.wispforest.owo.mixin.ui.ClickableWidgetAccessor;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.Drawer;
import io.wispforest.owo.ui.util.OwoNinePatchRenderers;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.w3c.dom.Element;

public class ButtonComponent
extends class_4185 {
    protected Renderer renderer = Renderer.VANILLA;
    protected boolean textShadow = true;

    protected ButtonComponent(class_2561 message, Consumer<ButtonComponent> onPress) {
        super(0, 0, 0, 0, message, button -> onPress.accept((ButtonComponent)button), class_4185.field_40754);
        this.sizing(Sizing.content());
    }

    public void method_48579(class_4587 matrices, int mouseX, int mouseY, float delta) {
        int color;
        this.renderer.draw(matrices, this, delta);
        class_327 textRenderer = class_310.method_1551().field_1772;
        int n = color = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        if (this.textShadow) {
            Drawer.method_27534((class_4587)matrices, (class_327)textRenderer, (class_2561)this.method_25369(), (int)(this.method_46426() + this.field_22758 / 2), (int)(this.method_46427() + (this.field_22759 - 8) / 2), (int)color);
        } else {
            textRenderer.method_30883(matrices, this.method_25369(), (float)this.method_46426() + (float)this.field_22758 / 2.0f - (float)textRenderer.method_27525((class_5348)this.method_25369()) / 2.0f, (float)this.method_46427() + (float)(this.field_22759 - 8) / 2.0f, color);
        }
        class_7919 tooltip = ((ClickableWidgetAccessor)((Object)this)).owo$getTooltip();
        if (this.field_22762 && tooltip != null) {
            Drawer.utilityScreen().method_25417(matrices, tooltip.method_47405(class_310.method_1551()), mouseX, mouseY);
        }
    }

    public ButtonComponent onPress(Consumer<ButtonComponent> onPress) {
        ((ButtonWidgetAccessor)((Object)this)).owo$setOnPress(button -> onPress.accept((ButtonComponent)button));
        return this;
    }

    public ButtonComponent renderer(Renderer renderer) {
        this.renderer = renderer;
        return this;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public ButtonComponent textShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public boolean textShadow() {
        return this.textShadow;
    }

    public ButtonComponent active(boolean active) {
        this.field_22763 = active;
        return this;
    }

    public boolean active() {
        return this.field_22763;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, "text", UIParsing::parseText, arg_0 -> ((ButtonComponent)this).method_25355(arg_0));
        UIParsing.apply(children, "text-shadow", UIParsing::parseBool, this::textShadow);
        UIParsing.apply(children, "renderer", Renderer::parse, this::renderer);
    }

    protected CursorStyle owo$preferredCursorStyle() {
        return CursorStyle.HAND;
    }

    @FunctionalInterface
    public static interface Renderer {
        public static final Renderer VANILLA = (matrices, button, delta) -> {
            RenderSystem.enableDepthTest();
            if (button.field_22763) {
                if (button.field_22762) {
                    OwoNinePatchRenderers.HOVERED_BUTTON.draw(matrices, button.method_46426(), button.method_46427(), button.field_22758, button.field_22759);
                } else {
                    OwoNinePatchRenderers.ACTIVE_BUTTON.draw(matrices, button.method_46426(), button.method_46427(), button.field_22758, button.field_22759);
                }
            } else {
                OwoNinePatchRenderers.BUTTON_DISABLED.draw(matrices, button.method_46426(), button.method_46427(), button.field_22758, button.field_22759);
            }
        };

        public static Renderer flat(int color, int hoveredColor, int disabledColor) {
            return (matrices, button, delta) -> {
                RenderSystem.enableDepthTest();
                if (button.field_22763) {
                    if (button.field_22762) {
                        Drawer.method_25294((class_4587)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)(button.method_46426() + button.field_22758), (int)(button.method_46427() + button.field_22759), (int)hoveredColor);
                    } else {
                        Drawer.method_25294((class_4587)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)(button.method_46426() + button.field_22758), (int)(button.method_46427() + button.field_22759), (int)color);
                    }
                } else {
                    Drawer.method_25294((class_4587)matrices, (int)button.method_46426(), (int)button.method_46427(), (int)(button.method_46426() + button.field_22758), (int)(button.method_46427() + button.field_22759), (int)disabledColor);
                }
            };
        }

        public static Renderer texture(class_2960 texture, int u, int v, int textureWidth, int textureHeight) {
            return (matrices, button, delta) -> {
                int renderV = v;
                if (!button.field_22763) {
                    renderV += button.field_22759 * 2;
                } else if (button.method_49606()) {
                    renderV += button.field_22759;
                }
                RenderSystem.enableDepthTest();
                RenderSystem.setShaderTexture((int)0, (class_2960)texture);
                Drawer.method_25290((class_4587)matrices, (int)button.method_46426(), (int)button.method_46427(), (float)u, (float)renderV, (int)button.field_22758, (int)button.field_22759, (int)textureWidth, (int)textureHeight);
            };
        }

        public void draw(class_4587 var1, ButtonComponent var2, float var3);

        public static Renderer parse(Element element) {
            List children = UIParsing.allChildrenOfType(element, (short)1);
            if (children.size() > 1) {
                throw new UIModelParsingException("'renderer' declaration may only contain a single child");
            }
            Element rendererElement = (Element)children.get(0);
            return switch (rendererElement.getNodeName()) {
                case "vanilla" -> VANILLA;
                case "flat" -> {
                    UIParsing.expectAttributes(rendererElement, "color", "hovered-color", "disabled-color");
                    yield Renderer.flat(Color.parseAndPack(rendererElement.getAttributeNode("color")), Color.parseAndPack(rendererElement.getAttributeNode("hovered-color")), Color.parseAndPack(rendererElement.getAttributeNode("disabled-color")));
                }
                case "texture" -> {
                    UIParsing.expectAttributes(rendererElement, "texture", "u", "v", "texture-width", "texture-height");
                    yield Renderer.texture(UIParsing.parseIdentifier(rendererElement.getAttributeNode("texture")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("u")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("v")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("texture-width")), UIParsing.parseUnsignedInt(rendererElement.getAttributeNode("texture-height")));
                }
                default -> throw new UIModelParsingException("Unknown button renderer '" + rendererElement.getNodeName() + "'");
            };
        }
    }
}

