/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network;

import io.wispforest.owo.mixin.ServerPlayNetworkHandlerAccessor;
import io.wispforest.owo.network.ClientAccess;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.OwoClientConnectionExtension;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.network.ServerAccess;
import io.wispforest.owo.network.serialization.RecordSerializer;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ReflectionUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class OwoNetChannel {
    static final Map<class_2960, OwoNetChannel> REGISTERED_CHANNELS = new HashMap<class_2960, OwoNetChannel>();
    static final Map<class_2960, OwoNetChannel> REQUIRED_CHANNELS = new HashMap<class_2960, OwoNetChannel>();
    static final Map<class_2960, OwoNetChannel> OPTIONAL_CHANNELS = new HashMap<class_2960, OwoNetChannel>();
    private final Map<Class<?>, IndexedSerializer<?>> serializersByClass = new HashMap();
    final Int2ObjectMap<IndexedSerializer<?>> serializersByIndex = new Int2ObjectOpenHashMap();
    private final List<ChannelHandler<Record, ClientAccess>> clientHandlers = new ArrayList<ChannelHandler<Record, ClientAccess>>();
    private final List<ChannelHandler<Record, ServerAccess>> serverHandlers = new ArrayList<ChannelHandler<Record, ServerAccess>>();
    private final Reference2IntMap<Class<?>> deferredClientSerializers = new Reference2IntOpenHashMap();
    final class_2960 packetId;
    private final String ownerClassName;
    final boolean required;
    private ClientHandle clientHandle = null;
    private ServerHandle serverHandle = null;

    public static OwoNetChannel create(class_2960 id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2), true);
    }

    public static OwoNetChannel createOptional(class_2960 id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2), false);
    }

    private OwoNetChannel(class_2960 id, String ownerClassName, boolean required) {
        OwoFreezer.checkRegister("Network channels");
        if (REGISTERED_CHANNELS.containsKey(id)) {
            throw new IllegalStateException("Channel with id '" + id + "' was already registered from class '" + OwoNetChannel.REGISTERED_CHANNELS.get((Object)id).ownerClassName + "'");
        }
        this.deferredClientSerializers.defaultReturnValue(-1);
        this.packetId = id;
        this.ownerClassName = ownerClassName;
        this.required = required;
        if (required) {
            OwoHandshake.requireHandshake();
        }
        ServerPlayNetworking.registerGlobalReceiver((class_2960)this.packetId, (server, player, handler, buf, responseSender) -> {
            int handlerIndex = buf.method_10816();
            Object message = ((IndexedSerializer)this.serializersByIndex.get((int)handlerIndex)).serializer.read(buf);
            server.execute(() -> this.serverHandlers.get(handlerIndex).handle((Record)message, new ServerAccess(player)));
        });
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)this.packetId, (client, handler, buf, responseSender) -> {
                int handlerIndex = buf.method_10816();
                Object message = ((IndexedSerializer)this.serializersByIndex.get((int)(-handlerIndex))).serializer.read(buf);
                client.execute(() -> this.clientHandlers.get(handlerIndex).handle((Record)message, new ClientAccess(handler)));
            });
        }
        this.clientHandlers.add(null);
        this.serverHandlers.add(null);
        REGISTERED_CHANNELS.put(id, this);
        if (required) {
            REQUIRED_CHANNELS.put(id, this);
        } else {
            OPTIONAL_CHANNELS.put(id, this);
        }
    }

    public <R extends Record> void registerClientbound(Class<R> messageClass, ChannelHandler<R, ClientAccess> handler) {
        int deferredIndex = this.deferredClientSerializers.removeInt(messageClass);
        if (deferredIndex != -1) {
            OwoFreezer.checkRegister("Network handlers");
            this.clientHandlers.set(deferredIndex, handler);
            return;
        }
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, EnvType.CLIENT);
        this.clientHandlers.add(handler);
    }

    public <R extends Record> void registerClientboundDeferred(Class<R> messageClass) {
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, EnvType.CLIENT);
        this.clientHandlers.add(null);
        this.deferredClientSerializers.put(messageClass, index);
    }

    public <R extends Record> void registerServerbound(Class<R> messageClass, ChannelHandler<R, ServerAccess> handler) {
        int index = this.serverHandlers.size();
        this.createSerializer(messageClass, index, EnvType.SERVER);
        this.serverHandlers.add(handler);
    }

    public boolean canSendToPlayer(class_3222 player) {
        return this.canSendToPlayer(player.field_13987);
    }

    public boolean canSendToPlayer(class_3244 networkHandler) {
        if (this.required) {
            return true;
        }
        return OwoHandshake.isValid() ? OwoNetChannel.getChannelSet(((ServerPlayNetworkHandlerAccessor)networkHandler).owo$getConnection()).contains(this.packetId) : ServerPlayNetworking.canSend((class_3244)networkHandler, (class_2960)this.packetId);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canSendToServer() {
        if (this.required) {
            return true;
        }
        return OwoHandshake.isValid() ? OwoNetChannel.getChannelSet(class_310.method_1551().method_1562().method_48296()).contains(this.packetId) : ClientPlayNetworking.canSend((class_2960)this.packetId);
    }

    private static Set<class_2960> getChannelSet(class_2535 connection) {
        return ((OwoClientConnectionExtension)connection).owo$getChannelSet();
    }

    public ClientHandle clientHandle() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new NetworkException("Cannot obtain client handle in environment type '" + FabricLoader.getInstance().getEnvironmentType() + "'");
        }
        if (this.clientHandle == null) {
            this.clientHandle = new ClientHandle();
        }
        return this.clientHandle;
    }

    public ServerHandle serverHandle(MinecraftServer server) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = PlayerLookup.all((MinecraftServer)server);
        return handle;
    }

    public ServerHandle serverHandle(Collection<class_3222> targets) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = targets;
        return handle;
    }

    public ServerHandle serverHandle(class_1657 player) {
        if (!(player instanceof class_3222)) {
            throw new NetworkException("'player' must be a 'ServerPlayerEntity'");
        }
        class_3222 serverPlayer = (class_3222)player;
        ServerHandle handle = this.getServerHandle();
        handle.targets = Collections.singleton(serverPlayer);
        return handle;
    }

    public ServerHandle serverHandle(class_2586 entity) {
        if (entity.method_10997().field_9236) {
            throw new NetworkException("Server handle cannot be obtained on the client");
        }
        return this.serverHandle(PlayerLookup.tracking((class_2586)entity));
    }

    public ServerHandle serverHandle(class_3218 world, class_2338 pos) {
        return this.serverHandle(PlayerLookup.tracking((class_3218)world, (class_2338)pos));
    }

    private ServerHandle getServerHandle() {
        if (this.serverHandle == null) {
            this.serverHandle = new ServerHandle();
        }
        return this.serverHandle;
    }

    private <R extends Record> void createSerializer(Class<R> messageClass, int handlerIndex, EnvType target) {
        OwoFreezer.checkRegister("Network handlers");
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer == null) {
            IndexedSerializer<R> indexedSerializer = IndexedSerializer.create(RecordSerializer.create(messageClass), handlerIndex, target);
            this.serializersByClass.put(messageClass, indexedSerializer);
            this.serializersByIndex.put(target == EnvType.CLIENT ? -handlerIndex : handlerIndex, indexedSerializer);
        } else if (serializer.handlerIndex(target) == -1) {
            serializer.setHandlerIndex(handlerIndex, target);
            this.serializersByIndex.put(target == EnvType.CLIENT ? -handlerIndex : handlerIndex, serializer);
        } else {
            throw new IllegalStateException("Message class '" + messageClass.getName() + "' is already registered for target environment " + target);
        }
    }

    private <R extends Record> class_2540 encode(R message, EnvType target) {
        class_2540 buffer = PacketByteBufs.create();
        Class<?> messageClass = message.getClass();
        if (!this.serializersByClass.containsKey(messageClass)) {
            throw new NetworkException("Message class '" + messageClass + "' is not registered");
        }
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer.handlerIndex(target) == -1) {
            throw new NetworkException("Message class '" + messageClass + "' has not handler registered for target environment " + target);
        }
        buffer.method_10804(serializer.handlerIndex(target));
        serializer.serializer.write(buffer, message);
        return buffer;
    }

    private void verify() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && this.deferredClientSerializers.size() > 0) {
            throw new NetworkException("Some deferred client handlers for channel " + this.packetId + " haven't been registered: " + this.deferredClientSerializers.keySet().stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
    }

    static {
        OwoHandshake.enable();
        OwoFreezer.registerFreezeCallback(() -> {
            for (OwoNetChannel channel : REGISTERED_CHANNELS.values()) {
                channel.verify();
            }
        });
    }

    public class ClientHandle {
        public <R extends Record> void send(R message) {
            ClientPlayNetworking.send((class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, EnvType.SERVER));
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                this.send(message);
            }
        }
    }

    public class ServerHandle {
        private Collection<class_3222> targets = Collections.emptySet();

        public <R extends Record> void send(R message) {
            this.targets.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, EnvType.CLIENT)));
            this.targets = null;
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            this.targets.forEach(player -> {
                for (Record message : messages) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, EnvType.CLIENT));
                }
            });
            this.targets = null;
        }
    }

    static final class IndexedSerializer<R extends Record> {
        private int clientHandlerIndex = -1;
        private int serverHandlerIndex = -1;
        final RecordSerializer<R> serializer;

        private IndexedSerializer(RecordSerializer<R> serializer) {
            this.serializer = serializer;
        }

        public static <R extends Record> IndexedSerializer<R> create(RecordSerializer<R> serializer, int index, EnvType target) {
            return new IndexedSerializer<R>(serializer).setHandlerIndex(index, target);
        }

        public IndexedSerializer<R> setHandlerIndex(int index, EnvType target) {
            switch (target) {
                case CLIENT: {
                    this.clientHandlerIndex = index;
                    break;
                }
                case SERVER: {
                    this.serverHandlerIndex = index;
                }
            }
            return this;
        }

        public int handlerIndex(EnvType target) {
            return switch (target) {
                default -> throw new IncompatibleClassChangeError();
                case EnvType.CLIENT -> this.clientHandlerIndex;
                case EnvType.SERVER -> this.serverHandlerIndex;
            };
        }
    }

    public static interface ChannelHandler<R extends Record, E extends EnvironmentAccess<?, ?, ?>> {
        public void handle(R var1, E var2);
    }

    public static interface EnvironmentAccess<P extends class_1657, R, N> {
        public P player();

        public R runtime();

        public N netHandler();
    }
}

