/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config.ui;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.RangeConstraint;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.component.ConfigEnumButton;
import io.wispforest.owo.config.ui.component.ConfigSlider;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.config.ui.component.ConfigToggleButton;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.base.BaseParentComponent;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.parsing.UIModel;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class OptionComponents {
    public static OptionComponentFactory.Result<FlowLayout, ConfigTextBox> createTextBox(UIModel model, Option<?> option, Consumer<ConfigTextBox> processor) {
        return OptionComponents.createTextBox(model, option, Object::toString, processor);
    }

    public static <T> OptionComponentFactory.Result<FlowLayout, ConfigTextBox> createTextBox(UIModel model, Option<T> option, Function<T, String> toStringFunction, Consumer<ConfigTextBox> processor) {
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "text-box-config-option", OptionComponents.packParameters(option.translationKey(), toStringFunction.apply(option.value())));
        ConfigTextBox valueBox = optionComponent.childById(ConfigTextBox.class, "value-box");
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        if (option.detached()) {
            resetButton.field_22763 = false;
            valueBox.method_1888(false);
        } else {
            resetButton.field_22763 = !valueBox.method_1882().equals(toStringFunction.apply(option.defaultValue()));
            resetButton.onPress(button -> {
                valueBox.method_1852((String)toStringFunction.apply(option.defaultValue()));
                button.field_22763 = false;
            });
            valueBox.onChanged().subscribe(s -> {
                resetButton.field_22763 = !s.equals(toStringFunction.apply(option.defaultValue()));
            });
        }
        processor.accept(valueBox);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString();
        supplierArray[1] = () -> ((ConfigTextBox)valueBox).method_1882();
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), supplierArray));
        return new OptionComponentFactory.Result<FlowLayout, ConfigTextBox>(optionComponent, valueBox);
    }

    @Deprecated(forRemoval=true)
    public static OptionComponentFactory.Result<FlowLayout, OptionValueProvider> createSlider(UIModel model, Option<? extends Number> option, boolean withDecimals) {
        return OptionComponents.createRangeControls(model, option, withDecimals ? 2 : 0);
    }

    public static OptionComponentFactory.Result<FlowLayout, OptionValueProvider> createRangeControls(UIModel model, Option<? extends Number> option, int decimalPlaces) {
        boolean withDecimals = decimalPlaces > 0;
        Number value = option.value();
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "range-config-option", OptionComponents.packParameters(option.translationKey(), value.toString()));
        RangeConstraint constraint = option.backingField().field().getAnnotation(RangeConstraint.class);
        double min = constraint.min();
        double max = constraint.max();
        final ConfigSlider sliderInput = optionComponent.childById(ConfigSlider.class, "value-slider");
        sliderInput.min(min).max(max).decimalPlaces(decimalPlaces).snap(!withDecimals).setFromDiscreteValue(value.doubleValue());
        sliderInput.valueType(option.clazz());
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        if (option.detached()) {
            resetButton.field_22763 = false;
            sliderInput.field_22763 = false;
        } else {
            resetButton.field_22763 = (withDecimals ? value.doubleValue() : (double)Math.round(value.doubleValue())) != option.defaultValue().doubleValue();
            resetButton.onPress(button -> {
                sliderInput.setFromDiscreteValue(((Number)option.defaultValue()).doubleValue());
                button.field_22763 = false;
            });
            sliderInput.onChanged().subscribe(newValue -> {
                resetButton.field_22763 = (withDecimals ? newValue : (double)Math.round(newValue)) != ((Number)option.defaultValue()).doubleValue();
            });
        }
        FlowLayout sliderControls = optionComponent.childById(FlowLayout.class, "slider-controls");
        BaseParentComponent textControls = OptionComponents.createTextBox(model, option, configTextBox -> {
            configTextBox.configureForNumber(option.clazz());
            Predicate<String> predicate = configTextBox.applyPredicate();
            configTextBox.applyPredicate(predicate.and(s -> {
                double parsed = Double.parseDouble(s);
                return parsed >= min && parsed <= max;
            }));
        }).baseComponent().childById(FlowLayout.class, "controls-flow").positioning(Positioning.layout());
        final ConfigTextBox textInput = textControls.childById(ConfigTextBox.class, "value-box");
        FlowLayout controlsLayout = optionComponent.childById(FlowLayout.class, "controls-flow");
        ButtonComponent toggleButton = optionComponent.childById(ButtonComponent.class, "toggle-button");
        final MutableBoolean textMode = new MutableBoolean(false);
        toggleButton.onPress(button -> {
            textMode.setValue(textMode.isFalse());
            if (textMode.isTrue()) {
                sliderControls.remove();
                textInput.text(sliderInput.decimalPlaces() == 0 ? String.valueOf((int)sliderInput.discreteValue()) : String.valueOf(sliderInput.discreteValue()));
                controlsLayout.child(textControls);
            } else {
                textControls.remove();
                sliderInput.setFromDiscreteValue(((Number)textInput.parsedValue()).doubleValue());
                controlsLayout.child(sliderControls);
            }
            button.tooltip((class_2561)(textMode.isTrue() ? class_2561.method_43471((String)"text.owo.config.button.range.edit_with_slider") : class_2561.method_43471((String)"text.owo.config.button.range.edit_as_text")));
        });
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(), () -> textMode.isTrue() ? textInput.method_1882() : sliderInput.method_25369().getString()));
        return new OptionComponentFactory.Result<FlowLayout, OptionValueProvider>(optionComponent, new OptionValueProvider(){

            @Override
            public boolean isValid() {
                return textMode.isTrue() ? textInput.isValid() : sliderInput.isValid();
            }

            @Override
            public Object parsedValue() {
                return textMode.isTrue() ? textInput.parsedValue() : sliderInput.parsedValue();
            }
        });
    }

    public static OptionComponentFactory.Result<FlowLayout, ConfigToggleButton> createToggleButton(UIModel model, Option<Boolean> option) {
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "boolean-toggle-config-option", OptionComponents.packParameters(option.translationKey(), option.value().toString()));
        ConfigToggleButton toggleButton = optionComponent.childById(ConfigToggleButton.class, "toggle-button");
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        toggleButton.enabled(option.value());
        if (option.detached()) {
            resetButton.field_22763 = false;
            toggleButton.field_22763 = false;
        } else {
            resetButton.field_22763 = option.value() != option.defaultValue();
            resetButton.onPress(button -> {
                toggleButton.enabled((Boolean)option.defaultValue());
                button.field_22763 = false;
            });
            toggleButton.onPress(button -> {
                resetButton.field_22763 = toggleButton.parsedValue() != option.defaultValue();
            });
        }
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(), () -> toggleButton.method_25369().getString()));
        return new OptionComponentFactory.Result<FlowLayout, ConfigToggleButton>(optionComponent, toggleButton);
    }

    public static OptionComponentFactory.Result<FlowLayout, ConfigEnumButton> createEnumButton(UIModel model, Option<? extends Enum<?>> option) {
        FlowLayout optionComponent = model.expandTemplate(FlowLayout.class, "enum-config-option", OptionComponents.packParameters(option.translationKey(), option.value().toString()));
        ConfigEnumButton enumButton = optionComponent.childById(ConfigEnumButton.class, "enum-button");
        ButtonComponent resetButton = optionComponent.childById(ButtonComponent.class, "reset-button");
        enumButton.init(option, option.value().ordinal());
        if (option.detached()) {
            resetButton.field_22763 = false;
            enumButton.field_22763 = false;
        } else {
            resetButton.field_22763 = option.value() != option.defaultValue();
            resetButton.onPress(button -> {
                enumButton.select(((Enum)option.defaultValue()).ordinal());
                button.field_22763 = false;
            });
            enumButton.onPress(button -> {
                resetButton.field_22763 = enumButton.parsedValue() != option.defaultValue();
            });
        }
        optionComponent.child(new SearchAnchorComponent(optionComponent, option.key(), () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(), () -> enumButton.method_25369().getString()));
        return new OptionComponentFactory.Result<FlowLayout, ConfigEnumButton>(optionComponent, enumButton);
    }

    public static Map<String, String> packParameters(String name, String value) {
        return Map.of("config-option-name", name, "config-option-value", value);
    }
}

