/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.forges;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_3518;

public class ForgeFuelRegistry {
    private static final Map<class_1792, ForgeFuelDefinition> REGISTRY = new HashMap<class_1792, ForgeFuelDefinition>();

    public static void clear() {
        REGISTRY.clear();
    }

    public static ForgeFuelDefinition getFuelForItem(class_1792 item) {
        return REGISTRY.getOrDefault(item, ForgeFuelDefinition.EMPTY);
    }

    public static boolean hasFuel(class_1792 item) {
        return REGISTRY.containsKey(item);
    }

    public static void register(class_1792 item, ForgeFuelDefinition fuel) {
        REGISTRY.put(item, fuel);
    }

    public record ForgeFuelDefinition(int fuel, class_1792 returnType) {
        public static final ForgeFuelDefinition EMPTY = new ForgeFuelDefinition(0, null);

        public boolean hasReturnType() {
            return this.returnType != null;
        }

        public static ForgeFuelDefinition fromJson(JsonObject json) {
            int fuel = json.get("fuel").getAsInt();
            class_1792 returnType = class_3518.method_34916((JsonObject)json, (String)"return_item", null);
            return new ForgeFuelDefinition(fuel, returnType);
        }
    }
}

