/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.misc;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.wispforest.owo.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import nourl.mythicmetals.armor.ArmorSet;
import nourl.mythicmetals.armor.MythicArmor;
import nourl.mythicmetals.config.MythicOreConfigs;
import nourl.mythicmetals.config.OreConfig;
import org.apache.commons.lang3.mutable.MutableInt;

public final class MythicCommands {
    private MythicCommands() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccessdedicated, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mythicmetals").requires(source -> source.method_9259(1))).then(class_2170.method_9247((String)"range").then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::dumpType).executes(context -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"type").equals("console")) {
                ReflectionUtils.iterateAccessibleStaticFields(MythicOreConfigs.class, OreConfig.class, (feature, name, field) -> {
                    if (!feature.offset && !feature.trapezoid) {
                        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + " to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                    }
                    if (feature.offset) {
                        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has the range between " + feature.bottom + "(offset) to " + feature.top + ", with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                    }
                    if (feature.trapezoid) {
                        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)(name.toUpperCase(Locale.ROOT) + " has a triangle range between " + feature.bottom + " to " + feature.top + ", where the sweet spot is at Y = " + (feature.bottom + feature.top) / 2 + " with a discard chance of " + feature.discardChance * 100.0f + "%")), false);
                    }
                });
                return 1;
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"armor-stand").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"material", (ArgumentType)StringArgumentType.word()).suggests(MythicCommands::material).executes(context -> {
            if (StringArgumentType.getString((CommandContext)context, (String)"material").equals("all")) {
                if (MythicArmor.ARMOR_MAP.isEmpty()) {
                    return 1;
                }
                class_3218 world = ((class_2168)context.getSource()).method_9225();
                ArrayList<class_8053> allArmorTrims = MythicCommands.getAllArmorTrims((class_1937)world);
                MutableInt i = new MutableInt(0);
                MutableInt j = new MutableInt(0);
                MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> {
                    allArmorTrims.forEach(armorTrim -> MythicCommands.summonArmorStandWithTrim((class_1937)world, armorTrim, armorSet, j.getAndIncrement(), i.getValue()));
                    i.increment();
                    j.setValue(0);
                });
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Summoned armorstands"), true);
                return 1;
            }
            class_3218 world = ((class_2168)context.getSource()).method_9225();
            if (MythicArmor.ARMOR_MAP.get(StringArgumentType.getString((CommandContext)context, (String)"material")) != null) {
                ArrayList<class_8053> trims = MythicCommands.getAllArmorTrims((class_1937)world);
                int splitPoint = trims.size() / world.method_30349().method_30530(class_7924.field_42083).method_10204();
                int xOffset = 0;
                int zOffset = 0;
                for (int i = 0; i < trims.size(); ++i) {
                    if (i % splitPoint == 0) {
                        xOffset = 0;
                        zOffset += 2;
                    }
                    ArmorSet armorSet2 = MythicArmor.ARMOR_MAP.get(StringArgumentType.getString((CommandContext)context, (String)"material"));
                    MythicCommands.summonArmorStandWithTrim((class_1937)world, trims.get(i), armorSet2, (int)((class_2168)context.getSource()).method_9222().field_1352 + xOffset, (int)((class_2168)context.getSource()).method_9222().field_1350 + zOffset);
                    xOffset += 2;
                }
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Summoned armorstands"), true);
            }
            return 1;
        })))));
    }

    public static void summonArmorStandWithTrim(class_1937 world, @Nullable class_8053 trim, ArmorSet armorSet, int x, int z) {
        if (world.field_9236) {
            return;
        }
        class_1531 armorStand = new class_1531(world, (double)x, (double)(world.method_31600() - 50), (double)z);
        armorSet.getArmorItems().forEach(armorItem -> {
            class_1799 armorStack = new class_1799((class_1935)armorItem);
            if (trim != null) {
                class_8053.method_48429((class_5455)world.method_30349(), (class_1799)armorStack, (class_8053)trim);
            }
            armorStand.method_5673(armorItem.method_7685(), armorStack);
        });
        world.method_8649((class_1297)armorStand);
    }

    public static ArrayList<class_8053> getAllArmorTrims(class_1937 world) {
        if (world.field_9236) {
            return new ArrayList<class_8053>();
        }
        ArrayList<class_8053> list = new ArrayList<class_8053>();
        world.method_30349().method_30530(class_7924.field_42083).method_40270().forEach(armorMaterialEntry -> world.method_30349().method_30530(class_7924.field_42082).method_40270().forEach(armorTrimEntry -> list.add(new class_8053((class_6880)armorMaterialEntry, (class_6880)armorTrimEntry))));
        return list;
    }

    private static CompletableFuture<Suggestions> dumpType(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        suggestion.suggest("console");
        return suggestion.buildFuture();
    }

    private static CompletableFuture<Suggestions> material(CommandContext<class_2168> ctx, SuggestionsBuilder suggestion) {
        MythicArmor.ARMOR_MAP.forEach((s, armorSet) -> suggestion.suggest(s));
        suggestion.suggest("all");
        return suggestion.buildFuture();
    }
}

