/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.item.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.wispforest.owo.nbt.NbtKey;
import io.wispforest.owo.ui.core.Color;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.mininglevel.v1.MiningLevelManager;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import nourl.mythicmetals.MythicMetals;
import nourl.mythicmetals.abilities.DrillUpgrades;
import nourl.mythicmetals.item.MythicItems;
import nourl.mythicmetals.misc.UsefulSingletonForColorUtil;
import nourl.mythicmetals.registry.RegisterSounds;
import org.jetbrains.annotations.Nullable;

public class MythrilDrill
extends class_1810 {
    public static final NbtKey<Integer> FUEL = new NbtKey("Fuel", NbtKey.Type.INT);
    public static final NbtKey<Boolean> IS_ACTIVE = new NbtKey("IsActive", NbtKey.Type.BOOLEAN);
    public static final NbtKey<class_1792> UPGRADE_SLOT_ONE = new NbtKey("UpgradeSlot1", NbtKey.Type.ofRegistry((class_2378)class_7923.field_41178));
    public static final NbtKey<class_1792> UPGRADE_SLOT_TWO = new NbtKey("UpgradeSlot2", NbtKey.Type.ofRegistry((class_2378)class_7923.field_41178));
    public static final int MAX_FUEL = 1000;
    public static final int FUEL_CONSTANT = 10;

    public MythrilDrill(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1792 class_17922;
        class_1799 offhandStack;
        if (context.method_20287().equals((Object)class_1268.field_5810)) {
            return super.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
        }
        if (context.method_20287().equals((Object)class_1268.field_5808) && context.method_8036() != null && (offhandStack = context.method_8036().method_5998(class_1268.field_5810)) != null && offhandStack.method_7909() != null && (class_17922 = offhandStack.method_7909()) instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            blockItem.method_7884(new class_1838(context.method_8045(), context.method_8036(), class_1268.field_5810, offhandStack, new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699())));
            context.method_8036().method_6104(class_1268.field_5810);
            return class_1269.field_33562;
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        class_1799 offHandStack = user.method_5998(class_1268.field_5810);
        if (user.method_7357().method_7904(stack.method_7909())) {
            return class_1271.method_22430((Object)stack);
        }
        if (!offHandStack.equals(stack) && this.respectFood(offHandStack, user) || offHandStack.method_7976().equals((Object)class_1839.field_8946)) {
            return class_1271.method_22430((Object)stack);
        }
        if (this.hasFuel(stack)) {
            this.toggleDrillState(world, user, stack);
            return class_1271.method_22427((Object)stack);
        }
        if (world.field_9236) {
            user.method_7353((class_2561)class_2561.method_43471((String)"tooltip.mythril_drill.out_of_fuel"), true);
            user.method_17356((class_3414)class_3417.field_14624.comp_349(), class_3419.field_15248, 0.8f, 0.5f);
        }
        return class_1271.method_22430((Object)stack);
    }

    public boolean method_31565(class_1799 drill, class_1735 slot, class_5536 clickType, class_1657 player) {
        if (clickType == class_5536.field_27014 && slot.method_7677().method_7909().equals(MythicItems.Mats.MORKITE)) {
            int morkiteCount = slot.method_7677().method_7947();
            if (slot.method_34264((1000 - (Integer)drill.get(FUEL)) / 10, morkiteCount, player).isPresent()) {
                int fuel = class_3532.method_15340((int)((Integer)drill.get(FUEL) + morkiteCount * 10), (int)0, (int)1000);
                drill.put(FUEL, (Object)fuel);
                return true;
            }
        }
        return false;
    }

    public boolean method_31566(class_1799 drill, class_1799 cursorStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014) {
            class_1792 cursorItem = cursorStack.method_7909();
            if (cursorItem.equals(MythicItems.Mats.MORKITE)) {
                if (((Integer)drill.get(FUEL)).equals(1000)) {
                    return false;
                }
                int morkiteCount = cursorStack.method_7947();
                if (morkiteCount * 10 < 1000 - (Integer)drill.get(FUEL)) {
                    int fuel = class_3532.method_15340((int)((Integer)drill.get(FUEL) + morkiteCount * 10), (int)0, (int)1000);
                    cursorStack.method_7934(morkiteCount);
                    drill.put(FUEL, (Object)fuel);
                    return true;
                }
                if (morkiteCount * 10 >= 1000 - (Integer)drill.get(FUEL)) {
                    int morkiteToTake = 100 - (Integer)drill.get(FUEL) / 10;
                    int fuel = class_3532.method_15340((int)((Integer)drill.get(FUEL) + morkiteToTake * 10), (int)0, (int)1000);
                    cursorStack.method_7934(morkiteToTake);
                    drill.put(FUEL, (Object)fuel);
                    return true;
                }
            }
            if (!MythrilDrill.hasUpgrade(drill, 0) || !MythrilDrill.hasUpgrade(drill, 1)) {
                if (!DrillUpgrades.MAP.containsKey(cursorItem) || MythrilDrill.hasUpgradeItem(drill, cursorItem)) {
                    return false;
                }
                if (!drill.has(UPGRADE_SLOT_ONE)) {
                    cursorStack.method_7934(1);
                    drill.put(UPGRADE_SLOT_ONE, (Object)cursorItem);
                    return true;
                }
                if (!drill.has(UPGRADE_SLOT_TWO)) {
                    cursorStack.method_7934(1);
                    drill.put(UPGRADE_SLOT_TWO, (Object)cursorItem);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (!world.field_9236 && state.method_26214((class_1922)world, pos) != 0.0f) {
            class_5819 random = world.method_8409();
            if (this.isActive(stack) && random.method_43048(10) > 3) {
                return true;
            }
            stack.method_7956(1, miner, e -> e.method_20235(class_1304.field_6173));
            if (!class_1890.method_8222((class_1799)stack).containsKey(class_1893.field_9099) && state.method_26164(ConventionalBlockTags.ORES)) {
                if (MythrilDrill.hasUpgradeItem(stack, MythicItems.Mats.AQUARIUM_PEARL)) {
                    miner.method_5855(Math.min(miner.method_5669() + 24, miner.method_5748()));
                }
                if (MythrilDrill.hasUpgradeItem(stack, MythicItems.Mats.ENCHANTED_MIDAS_GOLD_BLOCK) && random.method_43048(40) == 27) {
                    miner.method_5706((class_1935)class_1802.field_33402);
                }
            }
        }
        return true;
    }

    public boolean hasFuel(class_1799 stack) {
        return stack.has(FUEL) && (Integer)stack.get(FUEL) > 0;
    }

    public boolean isActive(class_1799 stack) {
        return stack.has(IS_ACTIVE) && (Boolean)stack.get(IS_ACTIVE) != false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        class_124 format1;
        int fuel = stack.has(FUEL) ? (Integer)stack.get(FUEL) : 0;
        class_124 format2 = MythrilDrill.hasUpgrade(stack, 2) ? class_124.field_1070 : class_124.field_1080;
        class_124 class_1242 = format1 = MythrilDrill.hasUpgrade(stack, 1) ? class_124.field_1070 : class_124.field_1080;
        if (MythrilDrill.hasEmptyUpgradeSlot(stack)) {
            tooltip.add(1, (class_2561)class_2561.method_43471((String)"tooltip.mythril_drill.upgrade_tip"));
        }
        tooltip.add(1, (class_2561)class_2561.method_43469((String)"tooltip.mythril_drill.upgrade_slot_2", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.mythril_drill.upgrade." + MythrilDrill.getUpgradeString(stack, 2)))}).method_27692(format2));
        tooltip.add(1, (class_2561)class_2561.method_43469((String)"tooltip.mythril_drill.upgrade_slot_1", (Object[])new Object[]{class_2561.method_43471((String)("tooltip.mythril_drill.upgrade." + MythrilDrill.getUpgradeString(stack, 1)))}).method_27692(format1));
        if (this.isActive(stack)) {
            tooltip.add(1, (class_2561)class_2561.method_43471((String)"tooltip.mythril_drill.activated").method_27692(class_124.field_1075));
        } else {
            tooltip.add(1, (class_2561)class_2561.method_43471((String)"tooltip.mythril_drill.deactivated").method_10862(class_2583.field_24360.method_36139(Color.ofRgb((int)0x622622).rgb()).method_27706(class_124.field_1056)));
        }
        if (fuel == 0) {
            tooltip.add(1, (class_2561)class_2561.method_43471((String)"tooltip.mythril_drill.refuel").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        tooltip.add(1, (class_2561)class_2561.method_43469((String)"tooltip.mythril_drill.fuel", (Object[])new Object[]{fuel, 1000}).method_27696(class_2583.field_24360.method_36139(UsefulSingletonForColorUtil.getSlightlyDarkerOwoBlueToRedGradient(fuel, 1000.0f))));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && this.hasFuel(stack) && this.isActive(stack) && world.method_8510() % 40L == 1L) {
            stack.put(FUEL, (Object)((Integer)stack.get(FUEL) - 1));
        }
        if (!this.hasFuel(stack)) {
            stack.put(IS_ACTIVE, (Object)false);
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return ((Integer)oldStack.get(FUEL)).equals(newStack.get(FUEL)) && oldStack.method_7919() == newStack.method_7919();
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return !((Integer)oldStack.get(FUEL)).equals(newStack.get(FUEL)) || oldStack.method_7919() != newStack.method_7919();
    }

    public boolean isSuitableFor(class_1799 stack, class_2680 state) {
        if (this.isActive(stack) && state.method_26164(class_3481.field_33716) && this.method_8022().method_8024() >= MiningLevelManager.getRequiredMiningLevel((class_2680)state)) {
            return true;
        }
        return super.isSuitableFor(stack, state);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        if (this.isActive(stack)) {
            if (state.method_26164(class_3481.field_33716) && this.method_8022().method_8024() >= MiningLevelManager.getRequiredMiningLevel((class_2680)state)) {
                return this.field_7940;
            }
            return super.method_7865(stack, state);
        }
        return super.method_7865(stack, state) / 2.5f;
    }

    public static boolean hasUpgradeItem(class_1799 drillStack, class_1792 upgradeItem) {
        boolean result = false;
        if (drillStack.has(UPGRADE_SLOT_ONE)) {
            boolean bl = result = drillStack.get(UPGRADE_SLOT_ONE) == upgradeItem;
        }
        if (drillStack.has(UPGRADE_SLOT_TWO) && !result) {
            result = drillStack.get(UPGRADE_SLOT_TWO) == upgradeItem;
        }
        return result;
    }

    public static boolean hasUpgrade(class_1799 drillStack, int slot) {
        if (slot == 2) {
            return drillStack.has(UPGRADE_SLOT_TWO);
        }
        if (slot == 1) {
            return drillStack.has(UPGRADE_SLOT_ONE);
        }
        MythicMetals.LOGGER.error("BAD DRILL QUERY - Upgrade slot " + slot + " does NOT exist on this Drill!");
        return false;
    }

    public static boolean hasEmptyUpgradeSlot(class_1799 drillStack) {
        return drillStack.has(UPGRADE_SLOT_TWO) || drillStack.has(UPGRADE_SLOT_ONE);
    }

    public static String getUpgradeString(class_1799 stack, int slot) {
        if (slot == 2) {
            if (stack.has(UPGRADE_SLOT_TWO)) {
                return DrillUpgrades.MAP.get(stack.get(UPGRADE_SLOT_TWO));
            }
        } else if (stack.has(UPGRADE_SLOT_ONE)) {
            return DrillUpgrades.MAP.get(stack.get(UPGRADE_SLOT_ONE));
        }
        return "empty";
    }

    public void toggleDrillState(class_1937 world, class_1657 user, class_1799 drill) {
        if (!drill.has(IS_ACTIVE)) {
            drill.put(IS_ACTIVE, (Object)false);
        }
        if (world.field_9236) {
            class_3414 sound = (Boolean)drill.get(IS_ACTIVE) != false ? RegisterSounds.MYTHRIL_DRILL_DEACTIVATE : RegisterSounds.MYTHRIL_DRILL_ACTIVATE;
            user.method_17356(sound, class_3419.field_15248, 1.0f, 1.0f);
        }
        user.method_7357().method_7906(drill.method_7909(), 20);
        drill.put(IS_ACTIVE, (Object)((Boolean)drill.get(IS_ACTIVE) == false ? 1 : 0));
    }

    private boolean respectFood(class_1799 foodStack, class_1657 user) {
        return foodStack.method_19267() && user.method_7332(foodStack.method_7909().method_19264() != null && foodStack.method_7909().method_19264().method_19233());
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        HashMultimap mapnite = HashMultimap.create((Multimap)this.method_7844(slot));
        if (MythrilDrill.hasUpgradeItem(stack, MythicItems.Mats.ENCHANTED_MIDAS_GOLD_BLOCK)) {
            mapnite.put((Object)class_5134.field_23726, (Object)new class_1322(UUID.fromString("dc61bf90-67b4-414e-8ecf-994065208b3e"), "Drill Luck", 2.0, class_1322.class_1323.field_6328));
        }
        return slot == class_1304.field_6173 ? mapnite : super.method_7844(slot);
    }
}

