/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_forge.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.CommandFunctions;
import com.natamus.collective_common_forge.functions.CompareBlockFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.collective_common_forge.functions.RayTraceFunctions;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockPosFunctions {
    private static final HashMap<BlockPos, Integer> rgnbcount = new HashMap();
    private static final HashMap<BlockPos, Integer> rgnbmcount = new HashMap();

    public static List<BlockPos> getBlocksAround(BlockPos pos, boolean down) {
        ArrayList<BlockPos> around = new ArrayList<BlockPos>();
        around.add(pos.m_122012_());
        around.add(pos.m_122029_());
        around.add(pos.m_122019_());
        around.add(pos.m_122024_());
        around.add(pos.m_7494_());
        if (down) {
            around.add(pos.m_7495_());
        }
        return around;
    }

    public static List<BlockPos> getBlocksNextToEachOther(Level world, BlockPos startpos, List<Block> possibleblocks) {
        return BlockPosFunctions.getBlocksNextToEachOther(world, startpos, possibleblocks, 50);
    }

    public static List<BlockPos> getBlocksNextToEachOther(Level world, BlockPos startpos, List<Block> possibleblocks, int maxDistance) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possibleblocks.contains(world.m_8055_(startpos).m_60734_())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbcount.put(startpos.m_7949_(), 0);
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, startpos, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(Level world, BlockPos startpos, BlockPos pos, List<Block> possibleblocks, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks, int maxDistance) {
        int rgnbc = rgnbcount.get(startpos);
        if (rgnbc > 100) {
            return;
        }
        rgnbcount.put(startpos, rgnbc + 1);
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.m_8055_(pba).m_60734_()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocks(world, startpos, pba, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(Level world, BlockPos startpos, List<Material> possiblematerials) {
        return BlockPosFunctions.getBlocksNextToEachOtherMaterial(world, startpos, possiblematerials, 50);
    }

    public static List<BlockPos> getBlocksNextToEachOtherMaterial(Level world, BlockPos startpos, List<Material> possiblematerials, int maxDistance) {
        ArrayList<BlockPos> checkedblocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> theblocksaround = new ArrayList<BlockPos>();
        if (possiblematerials.contains(world.m_8055_(startpos).m_60767_())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbmcount.put(startpos.m_7949_(), 0);
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, startpos, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(Level world, BlockPos startpos, BlockPos pos, List<Material> possiblematerials, List<BlockPos> theblocksaround, List<BlockPos> checkedblocks, int maxDistance) {
        int rgnbmc = rgnbmcount.get(startpos);
        if (rgnbmc > 100) {
            return;
        }
        rgnbmcount.put(startpos, rgnbmc + 1);
        List<BlockPos> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (BlockPos pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.m_8055_(pba).m_60767_()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, pba, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static BlockPos getSurfaceBlockPos(ServerLevel serverLevel, int x, int z) {
        return BlockPosFunctions.getSurfaceBlockPos(serverLevel, x, z, false);
    }

    public static BlockPos getSurfaceBlockPos(ServerLevel serverLevel, int x, int z, boolean ignoreTrees) {
        int height = serverLevel.m_141928_();
        int lowestY = serverLevel.m_141937_();
        BlockPos returnpos = new BlockPos(x, height - 1, z);
        if (!WorldFunctions.isNether((Level)serverLevel)) {
            BlockPos pos = new BlockPos(x, height, z);
            for (int y = height; y > lowestY; --y) {
                Block block;
                boolean continueCycle = false;
                BlockState blockState = serverLevel.m_8055_(pos);
                if (ignoreTrees && (CompareBlockFunctions.isTreeLeaf(block = blockState.m_60734_()) || CompareBlockFunctions.isTreeLog(block))) {
                    continueCycle = true;
                }
                if (!continueCycle) {
                    Material material = blockState.m_60767_();
                    if (blockState.m_60739_((BlockGetter)serverLevel, pos) >= 15 || GlobalVariables.surfacematerials.contains(material)) {
                        returnpos = pos.m_7494_().m_7949_();
                        break;
                    }
                }
                pos = pos.m_7495_();
            }
        } else {
            int maxheight = 128;
            BlockPos pos = new BlockPos(x, lowestY, z);
            for (int y = lowestY; y < maxheight; ++y) {
                BlockState upstate;
                BlockState blockstate = serverLevel.m_8055_(pos);
                if (blockstate.m_60734_().equals(Blocks.f_50016_) && (upstate = serverLevel.m_8055_(pos.m_7494_())).m_60734_().equals(Blocks.f_50016_)) {
                    returnpos = pos.m_7949_();
                    break;
                }
                pos = pos.m_7494_();
            }
        }
        return returnpos;
    }

    public static BlockPos getCenterNearbyVillage(ServerLevel serverLevel) {
        return BlockPosFunctions.getNearbyVillage(serverLevel, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyVillage(ServerLevel serverLevel, BlockPos nearPos) {
        BlockPos closestvillage = null;
        if (!serverLevel.m_7654_().m_129910_().m_246337_().m_247749_()) {
            return null;
        }
        String rawOutput = CommandFunctions.getRawCommandOutput(serverLevel, Vec3.m_82539_((Vec3i)nearPos), "/locate structure #minecraft:village");
        if (rawOutput.contains("[") && rawOutput.contains("]") && rawOutput.contains(", ")) {
            String[] coords;
            try {
                if (rawOutput.contains(":")) {
                    rawOutput = rawOutput.split(":", 2)[1];
                }
                String rawcoords = rawOutput.split("\\[")[1].split("]")[0];
                coords = rawcoords.split(", ");
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
            if (coords.length == 3) {
                String sx = coords[0];
                String sz = coords[2];
                if (NumberFunctions.isNumeric(sx) && NumberFunctions.isNumeric(sz)) {
                    return BlockPosFunctions.getSurfaceBlockPos(serverLevel, Integer.parseInt(sx), Integer.parseInt(sz));
                }
            }
        }
        return closestvillage;
    }

    public static BlockPos getCenterNearbyBiome(ServerLevel serverLevel, String biome) {
        return BlockPosFunctions.getNearbyBiome(serverLevel, new BlockPos(0, 0, 0), biome);
    }

    public static BlockPos getNearbyBiome(ServerLevel serverLevel, BlockPos nearPos, String biome) {
        String rawcoords;
        String[] coords;
        String rawOutput = CommandFunctions.getRawCommandOutput(serverLevel, Vec3.m_82539_((Vec3i)nearPos), "/locate biome " + biome);
        if (rawOutput.contains("nearest") && rawOutput.contains("[") && (coords = (rawcoords = rawOutput.split("nearest")[1].split("\\[")[1].split("]")[0]).split(", ")).length == 3) {
            String sx = coords[0];
            String sz = coords[2];
            if (NumberFunctions.isNumeric(sx) && NumberFunctions.isNumeric(sz)) {
                return BlockPosFunctions.getSurfaceBlockPos(serverLevel, Integer.parseInt(sx), Integer.parseInt(sz));
            }
        }
        return null;
    }

    public static BlockPos getCenterNearbyStructure(ServerLevel serverworld, HolderSet<Structure> structure) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, new BlockPos(0, 0, 0));
    }

    public static BlockPos getNearbyStructure(ServerLevel serverworld, HolderSet<Structure> structure, BlockPos nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, nearpos, 9999);
    }

    public static BlockPos getNearbyStructure(ServerLevel serverworld, HolderSet<Structure> structure, BlockPos nearpos, int radius) {
        Pair pair = serverworld.m_7726_().m_8481_().m_223037_(serverworld, structure, nearpos, radius, false);
        if (pair == null) {
            return null;
        }
        BlockPos villagepos = (BlockPos)pair.getFirst();
        if (villagepos == null) {
            return null;
        }
        BlockPos spawnpos = null;
        for (int y = serverworld.m_141928_() - 1; y > 0; --y) {
            BlockPos checkpos = new BlockPos(villagepos.m_123341_(), y, villagepos.m_123343_());
            if (serverworld.m_8055_(checkpos).m_60734_().equals(Blocks.f_50016_)) continue;
            spawnpos = checkpos.m_7494_().m_7949_();
            break;
        }
        return spawnpos;
    }

    public static BlockPos getBlockPlayerIsLookingAt(Level world, Player player, boolean stopOnLiquid) {
        HitResult raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.m_82450_().f_82479_;
        double posY = Math.floor(raytraceresult.m_82450_().f_82480_);
        double posZ = raytraceresult.m_82450_().f_82481_;
        return BlockPos.m_274561_((double)posX, (double)posY, (double)posZ);
    }

    public static BlockPos getRandomCoordinatesInNearestUngeneratedChunk(ServerLevel serverLevel, BlockPos aroundPosition) {
        int outputRegionZ;
        int outputRegionX;
        ArrayList<String> regionList = new ArrayList<String>();
        try {
            File[] listOfRegionFiles;
            File regionFolder = new File(WorldFunctions.getWorldPath(serverLevel) + File.separator + "region");
            for (File regionFile : listOfRegionFiles = regionFolder.listFiles()) {
                if (!regionFile.isFile()) continue;
                regionList.add(regionFile.getName().replaceAll("r.", "").replaceAll(".mca", ""));
            }
        }
        catch (NullPointerException ignored) {
            return null;
        }
        ChunkPos chunkPos = serverLevel.m_46745_(aroundPosition).m_7697_();
        int curRegionX = chunkPos.m_45610_();
        int curRegionZ = chunkPos.m_45612_();
        int currentRange = 1;
        int loops = 0;
        Object closestUngeneratedRegionString = "";
        while (((String)closestUngeneratedRegionString).equals("")) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int regionX = curRegionX + x * currentRange;
                    int regionZ = curRegionZ + z * currentRange;
                    String regionString = regionX + "." + regionZ;
                    if (regionList.contains(regionString)) continue;
                    closestUngeneratedRegionString = regionString;
                    break;
                }
                if (!((String)closestUngeneratedRegionString).equals("")) break;
            }
            ++currentRange;
            if (++loops <= 50) continue;
            return null;
        }
        String[] cursspl = ((String)closestUngeneratedRegionString).split("\\.");
        try {
            outputRegionX = Integer.parseInt(cursspl[0]);
            outputRegionZ = Integer.parseInt(cursspl[1]);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        int minXRange = outputRegionX * 512 - 256;
        int maxXRange = outputRegionX * 512 + 256;
        int minZRange = outputRegionZ * 512 - 256;
        int maxZRange = outputRegionZ * 512 + 256;
        int randomXCoord = ThreadLocalRandom.current().nextInt(minXRange, maxXRange + 1);
        int randomZCoord = ThreadLocalRandom.current().nextInt(minZRange, maxZRange + 1);
        int randomYCoord = BlockPosFunctions.getSurfaceBlockPos(serverLevel, randomXCoord, randomZCoord).m_123342_();
        return new BlockPos(randomXCoord, randomYCoord, randomZCoord);
    }

    public static Boolean isOnSurface(Level world, BlockPos pos) {
        return world.m_45527_(pos);
    }

    public static Boolean isOnSurface(Level world, Vec3 vecpos) {
        return BlockPosFunctions.isOnSurface(world, BlockPos.m_274561_((double)vecpos.f_82479_, (double)vecpos.f_82480_, (double)vecpos.f_82481_));
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, int distance) {
        return BlockPosFunctions.withinDistance(start, end, (double)distance);
    }

    public static Boolean withinDistance(BlockPos start, BlockPos end, double distance) {
        return start.m_123314_((Vec3i)end, distance);
    }

    public static BlockPos getBlockPosFromHitResult(HitResult hitresult) {
        Vec3 vec = hitresult.m_82450_();
        return BlockPos.m_274561_((double)vec.f_82479_, (double)vec.f_82480_, (double)vec.f_82481_);
    }
}

