/*
 * Decompiled with CFR 0.152.
 */
package com.hugman.dawn.api.creator;

import com.hugman.dawn.api.creator.SimpleCreator;
import com.hugman.dawn.api.object.ModData;
import com.hugman.dawn.api.util.BlockTemplate;
import com.hugman.dawn.api.util.StringUtil;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class BlockCreator
extends SimpleCreator<class_2248> {
    private final Builder builder;

    private BlockCreator(Builder builder) {
        super((class_2378<?>)class_2378.field_11146, builder.name, builder.blockProvider.apply(builder.settings));
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public void register(ModData modData) {
        super.register(modData);
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)this.value, this.builder.flammabilityBurn, this.builder.flammabilitySpread);
        if (!this.builder.noItem) {
            class_1747 blockItem = (class_1747)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)modData.id(this.builder.name), (Object)new class_1747((class_2248)this.value, new class_1792.class_1793().method_7892(this.builder.itemGroup)));
            blockItem.method_7713(class_1792.field_8003, (class_1792)blockItem);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientRegister(ModData modData) {
        class_1921 renderF;
        if (this.builder.render != null) {
            renderF = switch (this.builder.render) {
                default -> class_1921.method_23577();
                case Render.CUTOUT -> class_1921.method_23581();
                case Render.CUTOUT_MIPPED -> class_1921.method_23579();
                case Render.TRANSLUCENT -> class_1921.method_23583();
            };
        } else {
            renderF = class_1921.method_23577();
        }
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this.value, renderF);
    }

    @Override
    public void serverRegister(ModData modData, boolean isDedicatedServer) {
        if (!this.builder.noItem) {
            if (this.builder.cookTime != 0) {
                FuelRegistry.INSTANCE.add((class_1935)this.value, (Object)this.builder.cookTime);
            }
            if (this.builder.compostingChance != 0.0f) {
                CompostingChanceRegistry.INSTANCE.add((class_1935)this.value, (Object)Float.valueOf(this.builder.compostingChance));
            }
        }
    }

    public static class Builder {
        protected String name;
        protected Function<class_4970.class_2251, ? extends class_2248> blockProvider;
        protected class_4970.class_2251 settings;
        protected Render render;
        protected class_1761 itemGroup;
        protected int flammabilityBurn;
        protected int flammabilitySpread;
        protected boolean noItem;
        protected int cookTime;
        protected float compostingChance;

        public Builder() {
        }

        public Builder(String name, Function<class_4970.class_2251, ? extends class_2248> blockProvider, class_4970.class_2251 settings, Render render, class_1761 itemGroup, int flammabilityBurn, int flammabilitySpread, boolean noItem, int cookTime, float compostingChance) {
            this.name = name;
            this.blockProvider = blockProvider;
            this.settings = settings;
            this.render = render;
            this.itemGroup = itemGroup;
            this.flammabilityBurn = flammabilityBurn;
            this.flammabilitySpread = flammabilitySpread;
            this.noItem = noItem;
            this.cookTime = cookTime;
            this.compostingChance = compostingChance;
        }

        public Builder(String prefix, BlockTemplate template, class_4970.class_2251 settings) {
            this.name = prefix;
            this.applyTemplate(template);
            this.settings = settings;
        }

        public Builder(String name, Function<class_4970.class_2251, ? extends class_2248> blockProvider, class_4970.class_2251 settings) {
            this.name = name;
            this.blockProvider = blockProvider;
            this.settings = settings;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder name(String name, BlockTemplate getter) {
            return this.name(StringUtil.getShapedName(name, getter));
        }

        public String getName() {
            return this.name;
        }

        public Builder blockProvider(Function<class_4970.class_2251, ? extends class_2248> blockProvider) {
            this.blockProvider = blockProvider;
            return this;
        }

        public Builder settings(class_4970.class_2251 settings) {
            this.settings = settings;
            return this;
        }

        public Builder render(Render render) {
            this.render = render;
            return this;
        }

        public Builder itemGroup(class_1761 itemGroup) {
            this.itemGroup = itemGroup;
            return this;
        }

        public Builder flammability(int flammability) {
            this.flammabilityBurn = flammability;
            this.flammabilitySpread = flammability;
            return this;
        }

        public Builder flammability(int burn, int spread) {
            this.flammabilityBurn = burn;
            this.flammabilitySpread = spread;
            return this;
        }

        public Builder cookTime(int cookTime) {
            this.cookTime = cookTime;
            return this;
        }

        public Builder compostingChance(float compostingChance) {
            this.compostingChance = compostingChance;
            return this;
        }

        public Builder noItem() {
            this.noItem = true;
            return this;
        }

        public Builder applyTemplate(BlockTemplate template) {
            return this.name(this.name, template).itemGroup(template.getItemGroup()).render(template.getRender()).blockProvider(template.getBlockProvider());
        }

        public BlockCreator build() {
            Objects.requireNonNull(this.name, "Cannot build a block with no name!");
            Objects.requireNonNull(this.blockProvider, "Cannot build a block with no block provider!");
            Objects.requireNonNull(this.settings, "Cannot build a block with no block settings!");
            return new BlockCreator(this.copy());
        }

        public Builder copy() {
            return new Builder(this.name, this.blockProvider, (class_4970.class_2251)FabricBlockSettings.copyOf((class_4970.class_2251)this.settings), this.render, this.itemGroup, this.flammabilityBurn, this.flammabilitySpread, this.noItem, this.cookTime, this.compostingChance);
        }
    }

    public static enum Render {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }
}

