/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.owo.util;

import com.glisco.owo.registration.annotations.AssignedName;
import com.glisco.owo.registration.annotations.IterationIgnored;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ReflectionUtils {
    public static <C> C tryInstantiateWithNoArgs(Class<C> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException((e instanceof NoSuchMethodException ? "No zero-args constructor defined on class " : "Could not instantiate class ") + clazz, e);
        }
    }

    public static <C, F> void iterateAccessibleStaticFields(Class<C> clazz, Class<F> targetFieldType, BiConsumer<F, String> fieldConsumer) {
        for (Field field : clazz.getDeclaredFields()) {
            Object value;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (!targetFieldType.isAssignableFrom(value.getClass()) || field.isAnnotationPresent(IterationIgnored.class)) continue;
            String fieldId = field.getName().toLowerCase();
            if (field.isAnnotationPresent(AssignedName.class)) {
                fieldId = field.getAnnotation(AssignedName.class).value();
            }
            fieldConsumer.accept(value, fieldId);
        }
    }

    public static void forApplicableSubclasses(Class<?> parent, Class<?> targetType, Consumer<Class<?>> action) {
        for (Class<?> subclass : parent.getDeclaredClasses()) {
            if (!targetType.isAssignableFrom(subclass)) continue;
            action.accept(subclass);
        }
    }
}

