/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.owo.registration.reflect;

import com.glisco.owo.registration.annotations.RegistryNamespace;
import com.glisco.owo.registration.reflect.AutoRegistryContainer;
import com.glisco.owo.registration.reflect.FieldProcessingSubject;
import com.glisco.owo.registration.reflect.SimpleFieldProcessingSubject;
import com.glisco.owo.util.ReflectionUtils;
import java.util.function.BiConsumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class FieldRegistrationHandler {
    public static <T> void process(Class<? extends FieldProcessingSubject<T>> clazz, BiConsumer<T, String> processor, boolean recurseIntoInnerClasses) {
        FieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(processor, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, FieldProcessingSubject.class, subclass -> FieldRegistrationHandler.process(subclass, processor, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void processSimple(Class<? extends SimpleFieldProcessingSubject<T>> clazz, boolean recurseIntoInnerClasses) {
        SimpleFieldProcessingSubject<T> handler = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, handler.getTargetFieldType(), FieldRegistrationHandler.createProcessor(handler::processField, handler));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, SimpleFieldProcessingSubject.class, subclass -> FieldRegistrationHandler.processSimple(subclass, true));
        }
        handler.afterFieldProcessing();
    }

    public static <T> void register(Class<? extends AutoRegistryContainer<T>> clazz, String namespace, boolean recurseIntoInnerClasses) {
        AutoRegistryContainer container = ReflectionUtils.tryInstantiateWithNoArgs(clazz);
        ReflectionUtils.iterateAccessibleStaticFields(clazz, container.getTargetFieldType(), FieldRegistrationHandler.createProcessor((fieldValue, identifier) -> {
            class_2378.method_10230(container.getRegistry(), (class_2960)new class_2960(namespace, identifier), (Object)fieldValue);
            container.postProcessField(namespace, (Object)fieldValue, (String)identifier);
        }, container));
        if (recurseIntoInnerClasses) {
            ReflectionUtils.forApplicableSubclasses(clazz, AutoRegistryContainer.class, subclass -> {
                String classModId = namespace;
                if (subclass.isAnnotationPresent(RegistryNamespace.class)) {
                    classModId = subclass.getAnnotation(RegistryNamespace.class).value();
                }
                FieldRegistrationHandler.register(subclass, classModId, true);
            });
        }
        container.afterFieldProcessing();
    }

    private static <T> BiConsumer<T, String> createProcessor(BiConsumer<T, String> delegate, FieldProcessingSubject<T> handler) {
        return (t, u) -> {
            if (!handler.shouldProcessField((Object)t, (String)u)) {
                return;
            }
            delegate.accept((Object)t, (String)u);
        };
    }
}

