/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.owo.registration;

import com.glisco.owo.registration.ComplexRegistryAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class RegistryHelper<T> {
    private final class_2378<T> registry;
    private final Map<class_2960, Consumer<T>> actions;
    private final List<ComplexRegistryAction> complexActions = new ArrayList<ComplexRegistryAction>();

    @ApiStatus.Internal
    public RegistryHelper(class_2378<T> registry) {
        this.registry = registry;
        this.actions = new HashMap<class_2960, Consumer<T>>();
        RegistryEntryAddedCallback.event(registry).register((rawId, id, object) -> {
            if (this.actions.containsKey(id)) {
                this.actions.get(id).accept(object);
                this.actions.remove(id);
            }
            this.complexActions.removeIf(action -> action.update(id));
        });
    }

    public void runWhenPresent(class_2960 id, Consumer<T> action) {
        if (RegistryHelper.isContained(this.registry, id)) {
            action.accept(this.registry.method_10223(id));
        } else {
            this.actions.put(id, action);
        }
    }

    public void runWhenPresent(ComplexRegistryAction action) {
        if (!action.preCheck(this.registry)) {
            this.complexActions.add(action);
        }
    }

    private static <T> boolean isContained(class_2378<T> registry, class_2960 identifier) {
        return registry.method_10250(identifier);
    }
}

