/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.owo.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class ComplexRegistryAction {
    private final List<class_2960> predicates;
    private final Runnable action;

    protected ComplexRegistryAction(List<class_2960> predicates, Runnable action) {
        this.predicates = predicates;
        this.action = action;
    }

    protected <T> boolean preCheck(class_2378<T> registry) {
        this.predicates.removeIf(arg_0 -> registry.method_10250(arg_0));
        if (!this.predicates.isEmpty()) {
            return false;
        }
        this.action.run();
        return true;
    }

    protected boolean update(class_2960 id) {
        this.predicates.remove(id);
        if (!this.predicates.isEmpty()) {
            return false;
        }
        this.action.run();
        return true;
    }

    public static class Builder {
        private final Runnable action;
        private final List<class_2960> predicates;

        private Builder(Runnable action) {
            this.action = action;
            this.predicates = new ArrayList<class_2960>();
        }

        public static Builder create(Runnable action) {
            return new Builder(action);
        }

        public Builder entry(class_2960 id) {
            this.predicates.add(id);
            return this;
        }

        public Builder entries(Collection<class_2960> ids) {
            this.predicates.addAll(ids);
            return this;
        }

        public ComplexRegistryAction build() {
            if (this.predicates.isEmpty()) {
                throw new IllegalStateException("Predicate list must not be empty");
            }
            return new ComplexRegistryAction(this.predicates, this.action);
        }
    }
}

