/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.owo.itemgroup.json;

import com.glisco.owo.itemgroup.Icon;
import com.glisco.owo.itemgroup.OwoItemExtensions;
import com.glisco.owo.itemgroup.gui.ItemGroupButton;
import com.glisco.owo.itemgroup.gui.ItemGroupTab;
import com.glisco.owo.itemgroup.json.WrapperGroup;
import com.glisco.owo.moddata.ModDataConsumer;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3545;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class GroupTabLoader
implements ModDataConsumer {
    private static final Map<String, class_3545<List<ItemGroupTab>, List<ItemGroupButton>>> CACHED_BUTTONS = new HashMap<String, class_3545<List<ItemGroupTab>, List<ItemGroupButton>>>();

    public static class_1761 onGroupCreated(String name, int index, Supplier<class_1799> icon) {
        if (!CACHED_BUTTONS.containsKey(name)) {
            return null;
        }
        class_3545<List<ItemGroupTab>, List<ItemGroupButton>> cache = CACHED_BUTTONS.remove(name);
        WrapperGroup wrapperGroup = new WrapperGroup(index, name, (List)cache.method_15442(), (List)cache.method_15441(), icon);
        wrapperGroup.initialize();
        return wrapperGroup;
    }

    @Override
    public String getDataSubdirectory() {
        return "item_group_tabs";
    }

    @Override
    public void acceptParsedFile(class_2960 id, JsonObject json) {
        String targetGroup = class_3518.method_15265((JsonObject)json, (String)"target_group");
        JsonArray tabsArray = class_3518.method_15292((JsonObject)json, (String)"tabs", (JsonArray)new JsonArray());
        JsonArray buttonsArray = class_3518.method_15292((JsonObject)json, (String)"buttons", (JsonArray)new JsonArray());
        ArrayList<ItemGroupTab> createdTabs = new ArrayList<ItemGroupTab>();
        ArrayList<ItemGroupButton> createdButtons = new ArrayList<ItemGroupButton>();
        tabsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject tabObject = jsonElement.getAsJsonObject();
            class_2960 texture = new class_2960(class_3518.method_15253((JsonObject)tabObject, (String)"texture", (String)ItemGroupTab.DEFAULT_TEXTURE.toString()));
            class_3494.class_5123 tag = TagFactory.ITEM.create(new class_2960(class_3518.method_15265((JsonObject)tabObject, (String)"tag")));
            class_1792 icon = (class_1792)class_2378.field_11142.method_10223(new class_2960(class_3518.method_15265((JsonObject)tabObject, (String)"icon")));
            String name = class_3518.method_15265((JsonObject)tabObject, (String)"name");
            createdTabs.add(new ItemGroupTab(Icon.of((class_1935)icon), name, (class_3494<class_1792>)tag, texture));
        });
        buttonsArray.forEach(jsonElement -> {
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject buttonObject = jsonElement.getAsJsonObject();
            String link = class_3518.method_15265((JsonObject)buttonObject, (String)"link");
            String name = class_3518.method_15265((JsonObject)buttonObject, (String)"name");
            int u = class_3518.method_15260((JsonObject)buttonObject, (String)"texture_u");
            int v = class_3518.method_15260((JsonObject)buttonObject, (String)"texture_v");
            createdButtons.add(ItemGroupButton.link(Icon.of(ItemGroupButton.ICONS_TEXTURE, u, v, 64, 64), name, link));
        });
        for (class_1761 group : class_1761.field_7921) {
            if (!group.method_7751().equals(targetGroup)) continue;
            WrapperGroup wrappedGroup = new WrapperGroup(group.method_7741(), group.method_7751(), createdTabs, createdButtons, () -> ((class_1761)group).method_7750());
            wrappedGroup.initialize();
            for (class_1792 item : class_2378.field_11142) {
                if (item.method_7859() != group) continue;
                ((OwoItemExtensions)item).setItemGroup(wrappedGroup);
            }
            return;
        }
        CACHED_BUTTONS.put(targetGroup, (class_3545<List<ItemGroupTab>, List<ItemGroupButton>>)new class_3545(createdTabs, createdButtons));
    }
}

