/*
 * Decompiled with CFR 0.152.
 */
package nourl.mythicmetals.blocks;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1792;
import net.minecraft.class_2199;
import net.minecraft.class_2248;
import net.minecraft.class_2346;
import net.minecraft.class_2431;
import net.minecraft.class_2498;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import net.minecraft.class_6019;
import nourl.mythicmetals.blocks.StarriteOreBlock;
import nourl.mythicmetals.utils.RegistryHelper;

public class BlockSet {
    private final class_2431 ore;
    private final class_2248 storageBlock;
    private final class_2248 oreStorageBlock;
    private final class_2199 anvil;
    private final String name;
    private final boolean fireproof;
    private final Map<String, class_2431> oreVariants;

    private BlockSet(String name, class_2431 ore, class_2248 storageBlock, class_2248 oreStorageBlock, class_2199 anvil, Map<String, class_2431> oreVariants, boolean fireproof) {
        this.name = name;
        this.ore = ore;
        this.storageBlock = storageBlock;
        this.oreStorageBlock = oreStorageBlock;
        this.anvil = anvil;
        this.oreVariants = oreVariants;
        this.fireproof = fireproof;
    }

    private void register() {
        if (this.ore != null) {
            RegistryHelper.block(this.name + "_ore", (class_2248)this.ore, this.fireproof);
        }
        this.oreVariants.forEach((s, block) -> RegistryHelper.block(s + "_" + this.name + "_ore", (class_2248)block, this.fireproof));
        if (this.oreStorageBlock != null) {
            RegistryHelper.block("raw_" + this.name + "_block", this.oreStorageBlock, this.fireproof);
        }
        if (this.storageBlock != null) {
            RegistryHelper.block(this.name + "_block", this.storageBlock, this.fireproof);
        }
        if (this.anvil != null) {
            RegistryHelper.block(this.name + "_anvil", (class_2248)this.anvil, this.fireproof);
        }
    }

    public class_2431 getOre() {
        return this.ore;
    }

    public class_2248 getStorageBlock() {
        return this.storageBlock;
    }

    public class_2431 getOreVariant(String variant) {
        return this.oreVariants.get(variant);
    }

    public static class Builder {
        private static final List<BlockSet> toBeRegistered = new ArrayList<BlockSet>();
        private final String name;
        private final boolean fireproof;
        private final Map<String, class_2431> oreVariants = new LinkedHashMap<String, class_2431>();
        private class_2431 ore = null;
        private class_2248 storageBlock = null;
        private class_2248 oreStorageBlock = null;
        private class_2199 anvil = null;
        private class_2498 currentSounds = class_2498.field_11544;
        private float currentHardness = -1.0f;
        private float currentResistance = -1.0f;
        private Consumer<FabricBlockSettings> settingsProcessor = fabricBlockSettings -> {};

        private Builder(String name, boolean fireproof) {
            this.name = name;
            this.fireproof = fireproof;
        }

        public static Builder begin(String name, boolean fireproof) {
            return new Builder(name, fireproof);
        }

        public static void register() {
            toBeRegistered.forEach(BlockSet::register);
            toBeRegistered.clear();
        }

        private static FabricBlockSettings blockSettings(class_3614 material, float hardness, float resistance, class_2498 sounds, int miningLevel) {
            return FabricBlockSettings.of((class_3614)material).strength(hardness, resistance).sounds(sounds).breakByTool(FabricToolTags.PICKAXES, miningLevel).requiresTool();
        }

        public Builder createDefaultSet(float strength, int miningLevel) {
            return this.strength(strength).createOre(miningLevel).strength(strength + 1.0f).createOreStorageBlock(miningLevel).createStorageBlock(miningLevel++).createAnvil(miningLevel);
        }

        public Builder createDefaultSet(float strength, int miningLevel, int storageMiningLevel) {
            return this.strength(strength).createOre(miningLevel).strength(strength + 1.0f).createStorageBlock(storageMiningLevel).createOreStorageBlock(storageMiningLevel);
        }

        public Builder createDefaultSet(float oreStrength, int oreMiningLevel, float storageStrength, int storageMiningLevel) {
            return this.strength(oreStrength).createOre(oreMiningLevel).strength(storageStrength).createStorageBlock(storageMiningLevel).createOreStorageBlock(storageMiningLevel);
        }

        public Builder createAnvilSet(float strength, int miningLevel) {
            return this.strength(strength).sounds(class_2498.field_11533).createStorageBlock(miningLevel).createAnvil(miningLevel);
        }

        public Builder createAnvilSet(float hardness, float resistance, int miningLevel) {
            return this.strength(hardness, resistance).createStorageBlock(miningLevel).createAnvil(miningLevel);
        }

        public Builder sounds(class_2498 sounds) {
            this.currentSounds = sounds;
            return this;
        }

        public Builder strength(float strength) {
            return this.strength(strength, strength + 1.0f);
        }

        public Builder strength(float hardness, float resistance) {
            this.currentHardness = hardness;
            this.currentResistance = resistance;
            return this;
        }

        public Builder createOre(int miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.ore = new class_2431((class_4970.class_2251)settings);
            return this;
        }

        public Builder createOre(int miningLevel, class_6019 experience) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.ore = new class_2431((class_4970.class_2251)settings, experience);
            return this;
        }

        public Builder createOreVariant(String name, int miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new class_2431((class_4970.class_2251)settings));
            return this;
        }

        public Builder createOreVariant(String name, int miningLevel, class_6019 experience) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new class_2431((class_4970.class_2251)settings, experience));
            return this;
        }

        public Builder createStarriteOre(int miningLevel, class_6019 experience) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.ore = new StarriteOreBlock((class_4970.class_2251)settings, experience);
            return this;
        }

        public Builder createStarriteOreVariant(String name, int miningLevel, class_6019 experience) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.oreVariants.put(name, new StarriteOreBlock((class_4970.class_2251)settings, experience));
            return this;
        }

        public Builder createStorageBlock(int miningLevel) {
            return this.createStorageBlock(class_2498.field_11533, miningLevel);
        }

        public Builder createStorageBlock(class_3614 material, int miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15953, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.storageBlock = new class_2248((class_4970.class_2251)settings);
            return this;
        }

        public Builder createStorageBlock(class_2498 sounds, int miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15953, this.currentHardness, this.currentResistance, sounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.storageBlock = new class_2248((class_4970.class_2251)settings);
            return this;
        }

        public Builder createFallingStorageBlock(class_3614 material, int miningLevel, class_3494<class_1792> toolTag) {
            this.storageBlock = new class_2346((class_4970.class_2251)FabricBlockSettings.of((class_3614)material).strength(this.currentHardness, this.currentResistance).sounds(this.currentSounds).breakByTool(toolTag, miningLevel));
            return this;
        }

        public Builder createOreStorageBlock(int miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15914, this.currentHardness, this.currentResistance, this.currentSounds, miningLevel);
            this.settingsProcessor.accept(settings);
            this.oreStorageBlock = new class_2248((class_4970.class_2251)settings);
            return this;
        }

        public Builder createAnvil(int miningLevel) {
            FabricBlockSettings settings = Builder.blockSettings(class_3614.field_15949, 5.0f, 15000.0f, class_2498.field_11531, miningLevel);
            this.settingsProcessor.accept(settings);
            this.anvil = new class_2199((class_4970.class_2251)settings);
            return this;
        }

        public BlockSet finish() {
            BlockSet set = new BlockSet(this.name, this.ore, this.storageBlock, this.oreStorageBlock, this.anvil, this.oreVariants, this.fireproof);
            toBeRegistered.add(set);
            return set;
        }
    }
}

