/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgeRecipeSerializer
implements class_1865<AlloyForgeRecipe> {
    public static final AlloyForgeRecipeSerializer INSTANCE = new AlloyForgeRecipeSerializer();

    public AlloyForgeRecipe read(class_2960 id, JsonObject json) {
        ArrayList<class_1856> inputs = new ArrayList<class_1856>();
        class_3518.method_15261((JsonObject)json, (String)"inputs").forEach(jsonElement -> inputs.add(class_1856.method_8102((JsonElement)jsonElement)));
        if (inputs.isEmpty()) {
            throw new JsonSyntaxException("Inputs cannot be empty");
        }
        class_1799 outputStack = this.getItemStack(class_3518.method_15296((JsonObject)json, (String)"output"));
        int minForgeTier = class_3518.method_15260((JsonObject)json, (String)"min_forge_tier");
        int requiredFuel = class_3518.method_15260((JsonObject)json, (String)"fuel_per_tick");
        JsonObject overridesJson = class_3518.method_15281((JsonObject)json, (String)"overrides", (JsonObject)new JsonObject());
        ImmutableMap.Builder overridesBuilder = ImmutableMap.builder();
        for (Map.Entry entry : overridesJson.entrySet()) {
            String overrideString = (String)entry.getKey();
            AlloyForgeRecipe.OverrideRange overrideRange = null;
            if (overrideString.matches("\\d+\\+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(overrideString.substring(0, overrideString.length() - 1)));
            } else if (overrideString.matches("\\d+ to \\d+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(overrideString.substring(0, overrideString.indexOf(" "))), Integer.parseInt(overrideString.substring(overrideString.lastIndexOf(" ") + 1, overrideString.length())));
            } else if (overrideString.matches("\\d+")) {
                overrideRange = new AlloyForgeRecipe.OverrideRange(Integer.parseInt(overrideString), Integer.parseInt(overrideString));
            }
            if (overrideRange == null) {
                throw new JsonSyntaxException("Invalid override range token: " + overrideString);
            }
            overridesBuilder.put((Object)overrideRange, (Object)this.getItemStack(((JsonElement)entry.getValue()).getAsJsonObject()));
        }
        return new AlloyForgeRecipe(id, inputs, outputStack, minForgeTier, requiredFuel, (ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>)overridesBuilder.build());
    }

    private class_1799 getItemStack(JsonObject json) {
        class_1792 item = class_3518.method_15288((JsonObject)json, (String)"id");
        int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        return new class_1799((class_1935)item, count);
    }

    public AlloyForgeRecipe read(class_2960 id, class_2540 buf) {
        ArrayList inputs = (ArrayList)buf.method_34068(value -> new ArrayList(), class_1856::method_8086);
        class_1799 output = buf.method_10819();
        int minForgeTier = buf.method_10816();
        int requiredFuel = buf.method_10816();
        Map overrides = buf.method_34067(buf1 -> new AlloyForgeRecipe.OverrideRange(buf1.method_10816(), buf1.method_10816()), class_2540::method_10819);
        return new AlloyForgeRecipe(id, inputs, output, minForgeTier, requiredFuel, (ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>)ImmutableMap.copyOf((Map)overrides));
    }

    public void write(class_2540 buf, AlloyForgeRecipe recipe) {
        buf.method_34062(recipe.method_8117(), (buf1, ingredient) -> ingredient.method_8088(buf1));
        buf.method_10793(recipe.method_8110());
        buf.method_10804(recipe.getMinForgeTier());
        buf.method_10804(recipe.getFuelPerTick());
        buf.method_34063(recipe.getTierOverrides(), (buf1, overrideRange) -> {
            buf1.method_10804(overrideRange.lowerBound());
            buf1.method_10804(overrideRange.upperBound());
        }, class_2540::method_10793);
    }
}

