/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.block;

import com.glisco.owo.ops.ItemOps;
import com.glisco.owo.particles.ServerParticles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import wraith.alloyforgery.AlloyForgeScreenHandler;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.block.ForgeControllerBlock;
import wraith.alloyforgery.block.ImplementedInventory;
import wraith.alloyforgery.forges.ForgeDefinition;
import wraith.alloyforgery.forges.ForgeFuelRegistry;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class ForgeControllerBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278,
class_3908 {
    private static final int[] DOWN_SLOTS = new int[]{10, 11};
    private static final int[] RIGHT_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] LEFT_SLOTS = new int[]{11};
    private final class_2371<class_1799> ITEMS = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    private final ForgeDefinition forgeDefinition;
    private final ImmutableList<class_2338> multiblockPositions;
    private final class_2338 passthroughPos;
    private final class_2350 facing;
    private int smeltProgress;
    private int fuelProgress;
    private int fuel;
    private int currentSmeltTime;
    private final class_3913 PROPERTIES = new class_3913(){

        public int method_17390(int index) {
            return index == 0 ? ForgeControllerBlockEntity.this.smeltProgress : ForgeControllerBlockEntity.this.fuelProgress;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                ForgeControllerBlockEntity.this.smeltProgress = value;
            } else {
                ForgeControllerBlockEntity.this.fuelProgress = value;
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public ForgeControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(AlloyForgery.FORGE_CONTROLLER_BLOCK_ENTITY, pos, state);
        this.forgeDefinition = ((ForgeControllerBlock)state.method_26204()).forgeDefinition;
        this.facing = (class_2350)state.method_11654((class_2769)ForgeControllerBlock.FACING);
        this.passthroughPos = pos.method_10074();
        this.multiblockPositions = ForgeControllerBlockEntity.generateMultiblockPositions(pos.method_10062(), (class_2350)state.method_11654((class_2769)ForgeControllerBlock.FACING));
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.ITEMS);
        this.currentSmeltTime = nbt.method_10550("CurrentSmeltTime");
        this.fuel = nbt.method_10550("Fuel");
    }

    public class_2487 method_11007(class_2487 nbt) {
        class_1262.method_5426((class_2487)nbt, this.ITEMS);
        nbt.method_10569("Fuel", this.fuel);
        nbt.method_10569("CurrentSmeltTime", this.currentSmeltTime);
        return super.method_11007(nbt);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.ITEMS;
    }

    public class_1799 getFuelStack() {
        return this.method_5438(11);
    }

    public boolean canAddFuel(int fuel) {
        return this.fuel + fuel <= this.forgeDefinition.fuelCapacity();
    }

    public void addFuel(int fuel) {
        this.fuel += fuel;
    }

    public int getSmeltProgress() {
        return this.smeltProgress;
    }

    public int getCurrentSmeltTime() {
        return this.currentSmeltTime;
    }

    public void tick() {
        class_1799 fuelStack;
        ForgeFuelRegistry.ForgeFuelDefinition fuelDefinition;
        this.smeltProgress = Math.round((float)this.currentSmeltTime / (float)this.forgeDefinition.maxSmeltTime() * 19.0f);
        this.fuelProgress = Math.round((float)this.fuel / (float)this.forgeDefinition.fuelCapacity() * 48.0f);
        this.field_11863.method_8455(this.field_11867, class_2246.field_10124);
        if (!this.verifyMultiblock()) {
            this.currentSmeltTime = 0;
            class_2680 currentState = this.field_11863.method_8320(this.field_11867);
            if (((Boolean)currentState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
                this.field_11863.method_8501(this.field_11867, (class_2680)currentState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
            return;
        }
        if (!this.getFuelStack().method_7960() && (fuelDefinition = ForgeFuelRegistry.getFuelForItem((fuelStack = this.getFuelStack()).method_7909())) != ForgeFuelRegistry.ForgeFuelDefinition.EMPTY && this.canAddFuel(fuelDefinition.fuel())) {
            if (!ItemOps.emptyAwareDecrement((class_1799)this.getFuelStack())) {
                this.method_5447(11, fuelDefinition.hasReturnType() ? new class_1799((class_1935)fuelDefinition.returnType()) : class_1799.field_8037);
            }
            this.fuel += fuelDefinition.fuel();
        }
        class_2680 currentBlockState = this.field_11863.method_8320(this.field_11867);
        if (this.fuel > 100 && !((Boolean)currentBlockState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)currentBlockState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (this.fuel < 100 && ((Boolean)currentBlockState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)currentBlockState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        Optional recipeOptional = this.field_11863.method_8433().method_8132((class_3956)AlloyForgeRecipe.Type.INSTANCE, (class_1263)this, this.field_11863);
        if (recipeOptional.isEmpty()) {
            this.currentSmeltTime = 0;
        } else {
            AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeOptional.get();
            if (recipe.getMinForgeTier() > this.forgeDefinition.forgeTier()) {
                this.currentSmeltTime = 0;
                return;
            }
            class_1799 outputStack = this.method_5438(10);
            class_1799 recipeOutput = recipe.getOutput(this.forgeDefinition.forgeTier());
            if (!(outputStack.method_7960() || ItemOps.canStack((class_1799)outputStack, (class_1799)recipeOutput) && outputStack.method_7947() + recipeOutput.method_7947() <= outputStack.method_7914())) {
                this.currentSmeltTime = 0;
                return;
            }
            if (this.currentSmeltTime < this.forgeDefinition.maxSmeltTime()) {
                float fuelRequirement = (float)recipe.getFuelPerTick() * this.forgeDefinition.speedMultiplier();
                if ((float)this.fuel - fuelRequirement < 0.0f) {
                    this.currentSmeltTime = 0;
                    return;
                }
                this.currentSmeltTime = (int)((float)this.currentSmeltTime + this.forgeDefinition.speedMultiplier());
                this.fuel = (int)((float)this.fuel - fuelRequirement);
                if (this.field_11863.field_9229.nextDouble() > 0.75) {
                    ServerParticles.issueEvent((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24954((class_2382)this.field_11867), (class_2960)AlloyForgery.id("smelting_particles"), buf -> buf.method_10817((Enum)this.facing));
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (ItemOps.emptyAwareDecrement((class_1799)((class_1799)this.ITEMS.get(i)))) continue;
                    this.ITEMS.set(i, (Object)class_1799.field_8037);
                }
                if (outputStack.method_7960()) {
                    this.method_5447(10, recipeOutput);
                } else {
                    outputStack.method_7933(recipeOutput.method_7947());
                }
                this.currentSmeltTime = 0;
                this.method_5431();
            }
        }
    }

    public boolean verifyMultiblock() {
        class_2680 belowController = this.field_11863.method_8320((class_2338)this.multiblockPositions.get(0));
        if (!belowController.method_27852(class_2246.field_10312) && !this.forgeDefinition.isBlockValid(belowController.method_26204())) {
            return false;
        }
        for (int i = 1; i < this.multiblockPositions.size(); ++i) {
            if (this.forgeDefinition.isBlockValid(this.field_11863.method_8320((class_2338)this.multiblockPositions.get(i)).method_26204())) continue;
            return false;
        }
        return true;
    }

    public static ImmutableList<class_2338> generateMultiblockPositions(class_2338 controllerPos, class_2350 controllerFacing) {
        ArrayList<class_2338> posses = new ArrayList<class_2338>();
        class_2338 center = controllerPos.method_10093(controllerFacing.method_10153());
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(1, -1, 1), (class_2338)center.method_10069(-1, -1, -1))) {
            posses.add(pos.method_10062());
        }
        posses.remove(controllerPos.method_10074());
        posses.add(0, controllerPos.method_10074());
        for (int i = 0; i < 2; ++i) {
            class_2338 newCenter = center.method_10069(0, i, 0);
            posses.add(newCenter.method_10078());
            posses.add(newCenter.method_10067());
            posses.add(newCenter.method_10095());
            posses.add(newCenter.method_10072());
        }
        posses.remove(controllerPos);
        return ImmutableList.copyOf(posses);
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return DOWN_SLOTS;
        }
        if (side == this.facing.method_10170()) {
            return LEFT_SLOTS;
        }
        if (side == this.facing.method_10160()) {
            return RIGHT_SLOTS;
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 11 ? ForgeFuelRegistry.hasFuel(stack.method_7909()) : this.method_5438(slot).method_7960();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 10 || slot == 11 && !ForgeFuelRegistry.hasFuel(stack.method_7909());
    }

    public class_2561 method_5476() {
        return new class_2588("container.alloy_forgery.forge_controller");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AlloyForgeScreenHandler(syncId, inv, this, this.PROPERTIES);
    }

    public static void ticker(class_1937 world, class_2338 blockPos, class_2680 state, ForgeControllerBlockEntity controller) {
        controller.tick();
    }

    public static class Type
    extends class_2591<ForgeControllerBlockEntity> {
        public static Type INSTANCE = new Type();

        public Type() {
            super(ForgeControllerBlockEntity::new, (Set)ImmutableSet.of(), null);
        }

        public boolean method_20526(class_2680 state) {
            return state.method_26204() instanceof ForgeControllerBlock;
        }
    }
}

