/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.api.ArmorRemoveHandler;
import com.kwpugh.gobber2.api.ArmorTickable;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class DragonArmorNoFlight
extends class_1738
implements ArmorRemoveHandler,
ArmorTickable {
    static boolean enableDragonAllPerks = Gobber2.CONFIG.GENERAL.enableDragonAllPerks;
    static boolean enableDragonHealthPerks = Gobber2.CONFIG.GENERAL.enableDragonHealthPerks;
    static boolean enableDragonProtectiveEffects = Gobber2.CONFIG.GENERAL.enableDragonProtectiveEffects;
    static boolean enableDragonNoFallDamage = Gobber2.CONFIG.GENERAL.enableDragonNoFallDamage;
    static boolean unbreakableDragonArmor = Gobber2.CONFIG.GENERAL.unbreakableDragonArmor;
    static int gobberDragonArmorHealingPoints = Gobber2.CONFIG.GENERAL.gobberDragonArmorHealingPoints;

    public DragonArmorNoFlight(class_1741 material, class_1304 slot, class_1792.class_1793 settings) {
        super(material, slot, settings);
    }

    @Override
    public void tickArmor(class_1799 stack, class_1657 player) {
        class_1937 world = player.field_6002;
        if (PlayerEquipUtil.isPlayerWearingDragonArmor(player) && enableDragonAllPerks) {
            if (enableDragonHealthPerks && player.field_6012 % 180 == 0) {
                PlayerSpecialAbilities.giveGreaterAbsorption(player);
                PlayerSpecialAbilities.giveSaturationEffect(player);
                PlayerSpecialAbilities.giveHealing(player, gobberDragonArmorHealingPoints);
                PlayerSpecialAbilities.giveCuringEffect(world, player);
            }
            if (enableDragonProtectiveEffects) {
                PlayerSpecialAbilities.giveWaterBreathing(player);
                PlayerSpecialAbilities.givePhoenixEffect(world, player);
            }
            if (enableDragonNoFallDamage) {
                player.field_6017 = 0.0f;
            }
        }
    }

    @Override
    public void onRemoved(class_1657 player) {
        if (this.field_7880 == class_1304.field_6169 || this.field_7880 == class_1304.field_6174 || this.field_7880 == class_1304.field_6172 || this.field_7880 == class_1304.field_6166) {
            // empty if block
        }
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        if (unbreakableDragonArmor) {
            stack.method_7948().method_10556("Unbreakable", true);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        if (enableDragonAllPerks) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip1").method_27692(class_124.field_1060));
            if (enableDragonProtectiveEffects) {
                tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip2").method_27692(class_124.field_1060));
            }
            if (enableDragonHealthPerks) {
                tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip3").method_27692(class_124.field_1060));
                tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip4").method_27692(class_124.field_1060));
            }
            if (enableDragonNoFallDamage) {
                tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip5").method_27692(class_124.field_1060));
            }
        }
    }
}

