## TODO
+ add Positions.inAdjacentChunk(pos, level, center, includeCorners) method
+ implement CacheCleaner class
+ improve ItemGroup class to accept suppliers and item lists
+ implement base datagen classes

## 10.0.5.0
+ implemented: ability to connect a hopper to a vent pipe in order to pump smoke/pollution down (thanks to bubabbedi) 
+ added: ISmokeContainer.Type.PIPE enum constant
* improved: SmokeContainers class to support pipes and reversed pumps
* fixed: a bug where setting item durability to 0 would make the item permanently broken
* __requires: Forge 42.0.0 or above__

## 10.0.4.0
* updated to Minecraft 1.19.2
+ added: config setting to define custom hoppers with different suction range (thanks to darkosto)
+ added: BlockStatesMap.parseIntegers method
* fixed: potential issue in Positions.getLastInLine method
* __requires: Forge 42.0.0 or above__

## 10.0.3.0
* updated to breaking changes in the latest Forge
* __requires: Forge 41.0.94 or above__

## 10.0.2.0
* updated to the latest Forge
* __requires: Forge 41.0.64 or above__

## 10.0.1.0
+ implemented: ChameleonBlockModel class
+ implemented: ChameleonBlockTile class
+ added: ForgeEntity.otherHand() method
+ added: ForgeItem.indexIn() method
* improved: model replacer to work with block models
* __requires: Forge 41.0.28 or above__

## 10.0.0.0
* updated to Minecraft 1.19
* fixed: terrible formatting of float values in toml configs
* fixed: glass meters getting damage when hitting non-solid objects
* fixed: CommonMath.roundTo() method
* __requires: Forge 41.0.28 or above__

## 9.0.2.0
+ added: ISmokeContainer.getClosestActiveExhaustPumps() method
+ added: CommonMath.sameSign() method
+ implemented: VentPipe.Output and VentPipe.Input classes
+ implemented: Counters.IntCounter class
* reworked: SmokeContainers class
* fixed: hook for BlockRandomTickEvent not working
* __requires: Forge 40.0.23 or above__

## 9.0.1.0
+ added: methods to ColorARGB class for blending and approximating colors
+ added: WorldSearch.TileNeighbors.getActivePumps method
+ added: new default methods to IPollutant interface for pumping pollution
+ added: SmokeContainers.getChimneysAround method
+ implemented: IPole interface
+ implemented: WorldSearch.VertCylinder abstract class
* fixed: GameTime.mult method not preserving time shift and breaking compatibility with periodic updates 
* __requires: Forge 40.0.23 or above__

## 9.0.0.0
* updated to Minecraft 1.18.2
* rebuilt: registry system to use lazy suppliers instead of direct initialization
* fixed: incorrect path for mineable blocks in JsonGen.Tags class
* fixed: JsonGen writer not creating parent directories
* fixed: debug log messages being displayed as info messages
* __requires: Forge 40.0.0 or above__

## 8.0.1.0
+ added: CommonString.getRandomChar method
+ added: CommonString.replaceRandom method
+ implemented: JsonGen.Tags class
+ implemented: ResourceType class
* improved: WeightedList class
* fixed: server-side mods rejecting vanilla connections (thanks to liskoslayer63)
* fixed: concurrent modification exception in GlassMeterRenderer class (thanks to PJRamaglia, NotherWhiteDude and Taknax)
* __requires: Forge 39.0.0 or above__

## 8.0.0.0
* updated to Minecraft 1.18.1
* __requires: Forge 39.0.0 or above__

## 7.2.2.0
+ implemented: ChunkFullyLoadedEvent class to prevent nasty deadlocks
* fixed: compatibility issue with Water Physics Overhaul (thanks to bomberplayzhun and nedyx_)
* fixed: a crash with Illegal type at constant pool entry error (thanks to FoxMcloud5655, vizthex and thenimbleninja)

## 7.2.1.0
+ added: ForgeMod.registerArgumentTypes method
+ implemented: Namespace class
+ implemented: custom suggestions in ServerCommand.Arg class
* fixed: custom argument types not being registered (thanks to vindcar)
* __requires: Forge 35.1.4 or above__

## 7.2.0.0
* updated to Forge 36.2.0
* migrated to Mojang mappings
+ added: ReloadableUnitsInit class
+ added: IReloadableData interface
+ added: AbstractParsableList class
+ added: AbstractParsableBlackWhiteList class
+ added: BlockStateList class
+ added: Percentage.multiply method
+ added: ConfigCategory.name static method
+ added: ForgeEntity.isHostileMob static method
+ added: ForgeEntity.getAirShortage static method
- removed: conflicting methods in ForgeEntity class
- removed: all deprecated methods
- removed: showing default values for string lists in configs
- changed: the required side from Both to Server
* reworked: ServerCommand.Context class
+ implemented: ServerCommand.Msg class
+ implemented: missing Percentage.hashCode method
+ implemented: missing ConfigCategory.hashCode method
* done: lots of refactorings
* __requires: updating all mods that depend on this library__

## 7.1.0.0
+ implemented: correct BlockStatesSet.removeAll method
+ implemented: correct BlockStatesMap.addAll method
+ implemented: ItemModel.Properties class
+ implemented: BlockStateChange event
+ implemented: ForgeBucketItem class
+ implemented: ForgeBlock.Properties class
+ implemented: RegistryEntriesInit class
+ implemented: ChestWearRenderer class
+ implemented: TileInventory class
+ implemented: ForgeTileWithInventory class
+ implemented: ITickableUnit interface
+ added: SmokeContainers.maxBlocksInMultiblock config parameter
+ added: ItemModel.IModelWrapperFactory interface
+ added: ItemModel.BuiltIn class
+ added: GlassMeterRenderer class
+ added: IEmitter.Type enum
+ added: proper event for registering item model properties
+ added: better method for replacing item models
+ added: GameMath.isNan method
+ added: UnitsInit.addNew method
+ added: ForgeMod.getModEventBus method
+ added: ForgeMod.registerTileRenderer method
+ added: ForgeMod.setRenderLayer method
+ added: ForgeMod.registerContainerScreen method
+ added: ForgeMod.addPlayerRenderLayer method
+ added: ForgeTileEntity.syncWithClients method
+ added: ForgeEntity.rayTraceEntityBeingLookedAt method
+ added: BlockStateCarrier.carriesSameBlock method
+ added: Tooltip.addRaw method
+ added: ChunkLoc.existIn and ChunkLoc.getChunk methods
* improved: UnitId class to work with fluids
* improved: RelatedUnitsInit class to work with fluids
* improved: ISmokeContainer interface
* improved: ForgeEmitter.Properties class
* improved: ForgeEntity.rayTraceBlockBeingLookedAt method
* improved: UnitsInitWithEnum class to allow reload configs
* replaced: all nullables in BlockStateCarrier class with optionals
* replaced: ForgeTileEntityBlock class with ForgeTiledBlock
* reworked: GameWorld.Directions class
* reworked: Common.CachedValue class
- removed: IWithMeta interface
* fixed: not working hook for RandomTickEvent
* fixed: UnitId.toConfigName not removing metadata
* fixed: issues with syncing TileEntities on initial chunk loading
* fixed: bizarre scientific format of small values in configs
* __requires: Forge 35.1.4 or above__

## 7.0.10.0
+ added: compatibility with Minecraft 1.16.5
* __requires: Forge 35.1.4 or above__

## 7.0.9.0
* updated to latest recommended Forge 1.16.4-35.1.4
* changed: WorldSearch.BlockChain algorithm to use iteration instead of recursion
* fixed: java.lang.StackOverflowError when block chain is too long (thanks to vizthex)
* __requires: Forge 35.1.4 or above__

## 7.0.8.0
+ added: BiomeDictionary support again (thanks to Danny_and_Son)
* __requires: Forge 35.0.3 or above__

## 7.0.7.0
* updated to Minecraft 1.16.4
* __requires: Forge 35.0.3 or above__

## 7.0.6.0
+ implemented: BiomeId class for proper biome comparison
* reworked: World.Biomes utility class
* fixed: invalid biome comparisons used in biome white/black lists (thanks to bessiq)
* __requires: Forge 34.1.0 or above__

## 7.0.5.0
+ added: better methods for parsing dimensions from black/white lists
+ added: IntBounds.ZERO and FloatBounds.ZERO constants
+ added: GameWorld.isBlockLoaded method
* fixed: invalid resource location returned by DimensionId class
* __requires: Forge 34.1.0 or above__

## 7.0.4.0
* updated to Minecraft 1.16.3
* fixed: ForgeEntity.hasStack method not searching in the armor inventory
* __requires: Forge 34.1.0 or above__

## 7.0.3.0
+ added: RequiredSide enum
+ added: ForgeMod.getRequiredSide method
+ added: Biomes.addFeatures method
* improved: Vect3d class to handle pitch and yaw rotations
* fixed: commands not working after /reload (thanks to bessiq)
* fixed: network channel not allowing the connection from clients without the channel present
* __requires: Forge 33.0.20 or above__

## 7.0.2.0
* updated to Minecraft 1.16.2
+ added: DimensionId class
* fixed: handling of dimensions
* __requires: Forge 33.0.20 or above__

## 7.0.1.0
+ added: ability to use tags in the biome blacklists/whitelists by adding '#' prefix (thanks to bessiq)

## 7.0.0.0
* ported to Minecraft 1.16.1
* __requires: Forge 32.0.90 or above__

## 6.0.4.0
+ added: CampfireSmokeEvent class
+ added: ability to define several repair materials for a damageable item (thanks to StormbringerGT)
- removed: useless ItemRenderHook to improve performance

## 6.0.3.2
* fixed: a possible crash with GLFW Error 65539 - Invalid Key (thanks to iloveloosy12)

## 6.0.3.1
* fixed: BlockStatesMap not finding a value for a block with ID defined using a mask ('*' or [])
* fixed: UnitId not treating empty block properties ([]) as a mask

## 6.0.3.0
* improved: ISmokeContainer interface
* fixed: a possible crash with java.lang.ExceptionInInitializerError (thanks to OCDCleric and lennardplay)

## 6.0.2.2
* fixed: UnitId.PATTERN allowing the use of forbidden characters and throwing exceptions that prevented data packs from normal loading (thanks to efekaan321)

## 6.0.2.1
* fixed: ItemModel.Replacer.handlePerspective() returning original model instead of the new one
* fixed: GlassMeter.onLeftClickBlock() triggering several hits instead of one (thanks to mastasquidge)
* fixed: DamagableItem.durability being not synchronized with clients (thanks to Splutty)

## 6.0.2.0
+ added: IBounds.approxTo() method for quick approximation between different bounds
+ added: Percentage.parse() & value() methods
+ added: empty texture for future use
+ implemented: Ordered interface for better comparison of comparable classes
+ implemented: Percentage.equals() & compareTo() methods
* improved: Percentage class to implement Ordered interface
* changed: visibility of GamePath.model() & texture() methods to public
* marked: MeterIndicators class as deprecated

## 6.0.1.0
+ added: GamePath.blockLootTable method
* improved: JsonGen class to generate loot tables
* fixed: a crash when trying to configure the mod through the game menu (thanks to Judeous)

## 6.0.0.0
* ported to Minecraft 1.15.2
* __requires: Forge 31.1.0 or above__

## 5.2.1.0
+ added: TagsUpdatedEvent handler to ForgeMod class
* improved: UnitId format (@ or # characters can now be used to specify a tag)
* refactored: ServerCommand class and its subclasses
* fixed: FMLServer events being registered on the wrong bus
* fixed: invalid replaceableBlockId definition for the Overworld dimension

## 5.2.0.1
* fixed: compatibility issue with Java 1.8.0_51 that prevented coremods to be applied (thanks to ragemechanic and sylvastheicefairy)
* fixed: server-side events not being registered for the integrated server
* fixed: incorrect target method names in the random_tick_hook.js

## 5.2.0.0
+ added: ServerCommand class
* rewritten: Connection class so that all mods register their own channels instead of using a shared one 
* fixed: a critical bug with network messages that broke dependent mods in multiplayer (thanks to sylvastheicefairy and Evansit1)
* __requires: updating all mods that depend on this library__
* __requires: Forge 28.1.90 or above__

## 5.1.0.0
+ added: ForgeEmitter.Properties class
+ added: IWaterLoggable interface for blocks
+ added: UnitId.getBlockProperties method
+ added: UnitProperties abstract class
+ added: RelatedUnit.Properties class
+ added: RelatedBlock.Properties class
+ added: ForgeBlockItem class
+ added: JsonGen class for automatic generation of models and recipes
* improved: GameWorld class for working with lava and water
* refactored: GameWorld.TimeInterval class to a separate class GameTime
* refactored: IEmitter interface
* refactored: ISmokeContainer interface
* refactored: ForgeEnergy class
* refactored: GamePaths class and renamed to GamePath
* refactored: Names class and moved to data package
* __requires: updating all mods that depend on this library__ 
* __requires: Forge 28.1.90 or above__

## 5.0.0.0
* ported to Minecraft 1.14.4
* __requires: Forge 28.1.90 or above__

## 4.4.22.1
* fixed: incorrect identification of emitters that use meta from a dropped item instead of a block state (IC2 machines) (thanks to Wootaboot2)

## 4.4.22.0
+ added: ForgeEnergyStorage class for working with Forge Energy
+ added: ISmokeContainer.isActive method for determining the active state of the pump
* moved: "invertedPumpState" config parameter to adchimneys.cfg and renamed to "invertedRedstoneSignal"
* changed: the default value of "maxVentPipeLength" from 16 to 32
* __requires: updating Advanced Chimneys to version 3.5.4.0 or higher__

## 4.4.21.1
* fixed: an issue where invokeInterface method acted as invokeVirtual
* fixed: incorrect catching of some non-critical exceptions

## 4.4.21.0
+ added: InstructList.invokeInterface method
+ added: InstructList.invokeSpecial method

## 4.4.20.1
* fixed: an issue where the ForgeBlock.isRegistered method returned "true" for unregistered blocks in some cases

## 4.4.20.0
* improved: UnitConfig class for better interaction with config files

## 4.4.19.1
* fixed: incorrect converting UnitId to String when meta=0

## 4.4.19.0
+ added: InstructList.VarNode class
+ added: new coremod predefined instructions (IFQE & IFNE)
+ added: ForgeClassTransformer.isCompatibilityMode() method to get rid of the lousy ClassNotFound error
* improved: InstructList class to work with VarNodes 
- removed: forgotten debug messages
* __requires: updating Pollution of the Realms to version 1.0.13.0 or higher__

## 4.4.18.0
+ added: ForgeEmitter class as a base implementation of IEmitter interface
* improved: IEmitter interface for better compatibility with multi-blocks
* improved: WorldSearch.TileNeighbors class
* __requires: updating Advanced Chimneys to version 3.4.0.0 or higher__
* __requires: updating Pollution of the Realms to version 1.0.12.0 or higher__
* __requires: updating Large Ore Deposits to version 1.0.4.1 or higher__

## 4.4.17.1
* fixed: not always correct detection of hollows in multi-block structures

## 4.4.17.0
+ added: TileNeighbors.isMultiblockHollow method
+ added: EndertechMods enum
* moved: classes from the "explosive" package to a separate mod

## 4.4.16.0
+ added: ForgeLocating.environmentTexture method
+ added: descriptors for ResourceLocation, EntityRenderer and TextureManager classes
+ added: predefined signature for TextureManager.bindTexture method
+ added: Common.CachedValue class
+ added: new coremod predefined instructions
* fixed: invalid predefined signatures with srg names instead of normal ones

## 4.4.15.1
* optimized: CommonCollect.WeightedList
* fixed: log being spammed with "Unable to parse ':'. Invalid id format" (thanks to Osmuni)
* fixed: converting empty id to string

## 4.4.15.0
+ added: IPollutant.canPassThrough method with direction parameters
+ added: AABB.isFullBlockingPanel method
+ added: AABB.isFullBlockingFace method
+ added: block collision bounding box info to developer tooltips

## 4.4.14.0
+ added: Biomes.readFrom method for reading biome black/white lists from configs
+ added: BlackWhiteList.isEmpty method

## 4.4.13.0
+ added: DevInfo class
+ added: VanillaMaterials class
+ added: Position.withY method
+ added: MultiConfigProperty.StrArrayProperty class
+ added: CommonCollect.BlackWhiteList class
+ added: CommonCollect.WeightedList class
+ added: CommonMath.getFloor methods
+ added: Dimensions.readFrom method
+ added: Percentage.takeChance method
+ added: ForgeConfig.getIntBounds, getFloatBounds and getPercentage methods
+ added: ForgeNBT.hasCompoundTag method
* improved: ForgeWorld.Position class to work with chunks
* improved: WorldBounds class to work with relative coords
* fixed: ForgeNBT.writeBlockPos saving doubles instead of integers

## 4.4.12.0
+ added: INBTSerializable interface
+ added: INetSerializable interface
+ added: Connection.sendToAllInChunk method
* improved: ForgeNetMsg class to work with INetSerializable implementations
* reworked: ChunkLoc class
* fixed: incorrect serialization of ChunkLoc class
* fixed: sending incorrect World instance when executing server commands
* __requires: updating Pollution of the Realms to version 1.0.3.0 or higher__

## 4.4.11.0
+ added: IWind interface
+ added: StaticWind class
+ added: compatibility with Weather2 wind (thanks to CynicalBrat and Corosus)
* changed: ForgeWorld.getWindAt method return type
* __requires: updating Advanced Chimneys to version 3.3.19.0 or higher__
* __requires: updating Pollution of the Realms to version 1.0.2.0 or higher__

## 4.4.10.0
+ added: ForgeEntity.isUnderOpenSky method
* changed: IPollutant.canAffectBlock method signature

## 4.4.9.0
+ added: support for nested NBT tags (thanks to LordPINE)
+ added: IBaubleWear interface
+ added: RepairMatcher class
+ added: ForgeEntity.getEquipmentOn method
+ added: ForgeNBT.KeyPathPair class
- removed: IProtectiveWear interface

## 4.4.8.0
+ added: FluidBlock class
+ added: ForgeEntity.rayTraceBlockBeingLookedAt method
+ added: ForgeLocating.fluidTexture method
+ added: INeedRender interface
* fixed: unit ID pattern for accepting "/", "." characters

## 4.4.7.0
+ added: ForgeEntity.isUnderRain method
+ added: ForgeBlock.isUnderRain method
+ added: ForgeEntity.getPositionTop method
+ added: ForgeBlock.isUnderOpenSky method
* changed: IPollutant.canAffectEntity method signature
* fixed: an issue where some emitters were not receiving random updates (thanks to Ghost8909)

## 4.4.6.0
+ added: StateHashMap class
+ added: UnitId.getIBlockState method
+ added: ClassName.join method
+ added: InstructList.dup method
+ added: predefined descriptor for Predicate class
+ added: UnitId.withMetaData method
+ added: ForgeWorld.Position.getLastInLine method
* fixed: an issue where the pattern for unit ID was not allowing non-letter characters (thanks to golrith)

## 4.4.5.0
+ added: redstone power bounds
* improved: UnitId class for working with block properties

## 4.4.4.0
+ added: predefined signatures for ItemStack.setCount and Entity.OnUpdate methods
+ added: swapPositions method to ForgeEntity class
+ added: EmittersInit class
* improved: IEmitter interface to work with entities
* improved: RelatedUnitsInit class for better inheritance

## 4.4.3.0
+ added: PercentageSliderEntry class
* improved: Percentage class
* improved: ModConfig class
* fixed: showing of child categories in the config root menu

## 4.4.2.0
+ added: Tooltip class for better handling and formatting of tooltips
* improved: IEmitter interface (added getIdentityTag() and isIdentified() methods)

## 4.4.1.0
+ added: Column class that extends BlockChain class
+ added: IWithMeta interface
+ added: StateHashSet class

## 4.4.0.0
+ added: RelatedBlock class
+ added: CommonCollect class
+ added: MeterIndicators class
+ added: methods to ForgeCreativeTab class for proper setting tab icon
+ added: toBlockPos method to Vect3d class
* improved: UnitsInit and UnitsInitWithEnum classes
* changed: behavior of UnitId.from(Enum) method
* fixed: configs being not properly saved for units initialized from enums
* fixed: RenderItemHook injection before model rendering
* __note: update all related mods to the latest versions__

## 4.3.21.0
+ added: method sortDirections() for Wind class
* fixed: current wind motion dancing around target value 

## 4.3.20.1
* fixed: server crash with NoClassDefFoundError: com.endertech.minecraft.forge.configs.ForgeKeys

## 4.3.20.0
+ added: durability bounds const
+ added: method to join arrays 
+ added: AxisAlignedBB helper class
* fixed: ForgeTileEntity.shouldRefresh method

## 4.3.19.0
+ added: IUnitWithMeshDefinition interface
+ added: GlassMeter abstract class
* improved: UnitVariant class to match forge blockstate format

## 4.3.18.0
+ added: config option to remove repair penalty for breakable items
* fixed: getting incorrect variants from ModelResourceLocation
* fixed: incorrect caching for ModelResourceLocation

## 4.3.17.0
+ added: Multi-config String property
+ added: Multi-config UnitId property

## 4.3.16.0
+ added: predefined signature for NonNullList.get method
+ added: LadderShapedCharge abstract class for shaped explosions
+ added: WorldBounds class for working with 3d bounds
+ added: IEmitter interface
* implemented: IntBounds class as Iterable
* improved: IBounds<T> interface

## 4.3.15.0
* extended: IPollutant interface for better performance

## 4.3.14.0
+ added: new methods to IPollutant interface
+ added: new predefined method descriptors

## 4.3.13.0
+ implemented: asynchronous timers for periodic updates and better performance

## 4.3.12.0
+ added: "enabled" option for all biome configs to prevent overriding default parameters
+ added: "debug" option to the main config
* moved: most of the info messages to the debug level to reduce console spam

## 4.3.11.0
+ added: MultiConfigProperty class
* improved: ForgeMaterial class
* fixed: inability to repair armor and tools with ingots

## 4.3.10.0
+ added: config parameter for defining repair material on an anvil for all damageable items
* made: lots of refactoring

## 4.3.9.0
+ added: LavaTouchesWater hook
+ added: CustomArmorModel class
+ added: ChestWearItem class
+ added: Percentage class

## 4.3.8.0
+ added: config option to completely remove disabled units (thanks to Ilvrak) 

## 4.3.7.0
+ added: scheduled explosions
* fixed: registration of recipes for disabled units (thanks to Ilvrak)

## 4.3.6.1
* fixed: server crash on startup with NoClassDefFoundError (thanks to DeltaWolf7)

## 4.3.6.0
+ added: mod config GUI
+ added: maxVentPipeLength config option
+ added: invertedPumpState config option
+ added: ventInhaleDistance config option
* improved: GUI controls (input boxes for integer values replaced with sliders)

## 4.3.5.0
+ added: IPollutant interface
* made: lots of refactoring
* moved: ISmokeContainer interface to api package
* improved: BlockChain class implementations
* fixed: Position.getAroundCube() method

## 4.3.4.0
+ added: RelativeUnit abstract class
+ added: IRespirator interface
+ added: ModConfigGUI class
+ added: a bunch of new bytecode operations
+ implemented: VentDuct class for vent systems
* made: lots of refactoring
* improved: initialization classes for relative units
* improved: ModConfig class

## 4.3.3.0
+ added: NBT compound methods for working with string arrays
+ added: predefined signatures for ItemStack.shrink and ItemStack.splitStack methods
+ implemented: hashCode and equals methods of IntBounds and FloatBounds classes
* improved: config system for biomes
* fixed: beach biome name 
* fixed: disabled units not being registered instead of hiding from creative tabs

## 4.3.2.0
+ added: BlockCaughtFire hook

## 4.3.1.0
+ added: ShapedCharge abstract class
+ added: invertStackValue asm instruction
+ implemented: smoke outlets searching algorithm
* improved: explosives
* improved: rails
* improved: lots of refactoring
* fixed: normal names being used when invoking obfuscated methods
* fixed: shapeless recipe validating
* fixed: improper processing of ore dictionary names in crafting recipes

## 4.3.0.0
+ added: shared code to recognize chimneys and conductors
+ added: reader and writer for enum fields in network packets
+ added: Connection class for simple network messaging
+ added: new super classes for explosives, potions and consumable items
+ added: methods for saving time intervals in configs
* improved: IBounds interface and its implementations
* restructured: item and block super classes
* fixed: item configs not being saved on initialization
* fixed: field cache not working in ForgeNetMsg class

## 4.2.0.1
* fixed: wind synchronization on clients

## 4.2.0.0
+ implemented: global wind simulation with configs for each biome
+ implemented: reading obfuscated names from notch-mcp.srg
* improved: class transformers

## 4.1.0.0
* reworked: class transformers
* reworked: network messages and handlers
* updated to recommended forge-1.12.2-14.23.0.2491

## 4.0.0.0
* ported to Minecraft 1.12.1
* updated all srgs

## 3.0.2.0
* improved: threading classes

## 3.0.1.0
* improved: all network messages are synchronized with a main thread

## 3.0.0.0
* ported to Minecraft 1.12

## 2.2.0.0
* improved: asm hooks and class transformers