/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.datagen;

import mod.alexndr.simplecorelib.api.datagen.AbstractLootTableProvider;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class BlockLootTableProvider
extends AbstractLootTableProvider {
    protected static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));

    public BlockLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected void standardDropTable(Block b) {
        this.blockTable(b, LootTable.m_79147_().m_79161_(this.createStandardDrops((ItemLike)b)));
    }

    protected void specialDropTable(Block b, Item ii) {
        this.blockTable(b, LootTable.m_79147_().m_79161_(this.createItemWithFortuneDrops(b, ii)));
    }

    protected void multipleDropTable(Block b, Item ii, int mincount, int maxcount) {
        this.blockTable(b, LootTable.m_79147_().m_79161_(this.createMultiItemsWithFortuneDrops(b, ii, mincount, maxcount)));
    }

    protected void copyNameDropTable(Block b, Item ii) {
        this.blockTable(b, LootTable.m_79147_().m_79161_(this.createItemWithNameCopy(ii)));
    }

    protected void slabDropTable(Block b) {
        this.blockTable(b, LootTable.m_79147_().m_79161_(this.createSlabDrops(b)));
    }

    protected void doorDropTable(Block b) {
        this.blockTable(b, BlockLoot.m_124137_((Block)b));
    }

    protected void blockTable(Block b, LootTable.Builder lootTable) {
        this.addTable(b.m_60589_(), lootTable, LootContextParamSets.f_81421_);
    }

    protected LootPool.Builder createStandardDrops(ItemLike itemProvider) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemProvider));
    }

    protected LootPool.Builder createSlabDrops(Block b) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)BlockLootTableProvider.withExplosionDecay((ItemLike)b, LootItem.m_79579_((ItemLike)b).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))));
    }

    protected LootPool.Builder createItemWithNameCopy(Item itemProvider) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemProvider)).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY));
    }

    protected LootPool.Builder createItemWithFortuneDrops(Block blockIn, Item itemIn) {
        return BlockLootTableProvider.droppingWithSilkTouch(blockIn, (LootPoolEntryContainer.Builder)BlockLootTableProvider.withExplosionDecay((ItemLike)blockIn, LootItem.m_79579_((ItemLike)itemIn).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected LootPool.Builder createMultiItemsWithFortuneDrops(Block blockIn, Item itemIn, float min_count, float max_count) {
        return BlockLootTableProvider.droppingWithSilkTouch(blockIn, (LootPoolEntryContainer.Builder)BlockLootTableProvider.withExplosionDecay((ItemLike)blockIn, LootItem.m_79579_((ItemLike)itemIn).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min_count, (float)max_count))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static <T extends FunctionUserBuilder<T>> T withExplosionDecay(ItemLike itemIn, FunctionUserBuilder<T> consumer) {
        return (T)consumer.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
    }

    protected static LootPool.Builder dropping(Block blockIn, LootItemCondition.Builder builderIn, LootPoolEntryContainer.Builder<?> entryBuilderIn) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)blockIn).m_79080_(builderIn)).m_7170_(entryBuilderIn));
    }

    protected static LootPool.Builder droppingWithSilkTouch(Block blockIn, LootPoolEntryContainer.Builder<?> builderIn) {
        return BlockLootTableProvider.dropping(blockIn, SILK_TOUCH, builderIn);
    }
}

