/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simplecorelib.api.client.jei;

import java.text.NumberFormat;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mod.alexndr.simplecorelib.api.client.JEIClientModEventSubscriber;
import mod.alexndr.simplecorelib.api.client.jei.AlternateFuelRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class VeryAbstractFurnaceVariantCategory<T extends AlternateFuelRecipe>
implements IRecipeCategory<T> {
    public static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("simplecorelib", "textures/gui/gui_vanilla.png");
    protected static final int inputSlot = 0;
    protected static final int fuelSlot = 1;
    protected static final int outputSlot = 2;
    protected final IDrawableStatic background;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;
    protected final IDrawableStatic flameTransparentBackground;
    protected Component localizedName;
    protected Component smeltCountText;
    protected T fuelRecipe;

    public VeryAbstractFurnaceVariantCategory(IGuiHelper guiHelper) {
        this.staticFlame = guiHelper.createDrawable(RECIPE_GUI_VANILLA, 82, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        this.smeltCountText = Component.m_237110_((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{10000000});
        int stringWidth = fontRenderer.m_92895_(this.smeltCountText.getString());
        this.background = guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 0, 134, 18, 34).addPadding(0, 0, 0, stringWidth + 20).build();
        this.flameTransparentBackground = JEIClientModEventSubscriber.textures.getFlameIcon();
    }

    public Component getSmeltCountText() {
        return this.smeltCountText;
    }

    public IDrawableAnimated getFlame() {
        return this.animatedFlame;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.flameTransparentBackground;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        this.fuelRecipe = recipe;
    }

    public Component createSmeltCountText(int burnTime) {
        if (burnTime == ((AlternateFuelRecipe)this.fuelRecipe).getSingleItemBurnTime()) {
            return Component.m_237115_((String)"gui.jei.category.fuel.smeltCount.single");
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String smeltCount = numberInstance.format((float)burnTime / (float)((AlternateFuelRecipe)this.fuelRecipe).getSingleItemBurnTime());
        return Component.m_237110_((String)"gui.jei.category.fuel.smeltCount", (Object[])new Object[]{smeltCount});
    }
}

