/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.items;

import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SyncClientMsg
extends ForgeNetMsg<SyncClientMsg> {
    private static final String KEY_DEFINITIONS = "Definitions";
    public FinderType type;
    public int scanRadius;
    public int pingDepth;
    public int veinMinSize;
    public int depositMinSize;
    public int durability;
    public CompoundTag compound;

    public SyncClientMsg() {
    }

    public SyncClientMsg(FinderType type) {
        this.type = type;
        this.scanRadius = (Integer)type.scanRadius.get();
        this.pingDepth = (Integer)type.pingDepth.get();
        this.veinMinSize = (Integer)type.veinMinSize.get();
        this.depositMinSize = (Integer)type.depositMinSize.get();
        this.durability = (Integer)type.durability.get();
        this.compound = new CompoundTag();
        TagHelper.putStringArray((CompoundTag)this.compound, (String)KEY_DEFINITIONS, (String[])((Definitions)type.definitions.get()).toArray());
    }

    public SyncClientMsg create() {
        return new SyncClientMsg();
    }

    public void handle(Level level, Player player) {
        Finder finder = (Finder)((Object)this.type.finder.get());
        finder.scanRadius = this.scanRadius;
        finder.pingDepth = this.pingDepth;
        finder.veinMinSize = this.veinMinSize;
        finder.depositMinSize = this.depositMinSize;
        finder.durability = this.durability;
        String[] definitions = TagHelper.getStringArray((CompoundTag)this.compound, (String)KEY_DEFINITIONS);
        finder.syncTargetsWith(definitions);
    }
}

