/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.MagnetRangeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerSpecialAbilities {
    public static void giveFullHealth(Level world, Player player, ItemStack itemstack) {
        player.m_21153_(20.0f);
    }

    public static void giveNewMaxHealth(Level world, Player player, ItemStack itemstack, double newMax) {
        float healthAsFloat = (float)newMax;
        player.m_21153_(healthAsFloat);
    }

    public static void giveRegenEffect(Level world, Player player, ItemStack itemstack, int newfoodlevel, float newsatlevel) {
        if (player.f_19797_ % 180 == 0) {
            player.m_36324_().m_38707_(newfoodlevel, newsatlevel);
        }
    }

    public static void giveSaturationEffect(Level world, Player player, ItemStack itemstack) {
        player.m_36324_().m_38717_(7.0f);
    }

    public static void giveYellowHearts(Level world, LivingEntity player, ItemStack itemstack, int extraHearts, float absorptionRate) {
        float current = player.m_6103_();
        if (player.m_21223_() < 20.0f || current >= (float)extraHearts) {
            return;
        }
        if (current >= (float)(extraHearts - 1)) {
            if (player.f_19797_ % 180 == 0) {
                player.m_7911_((float)extraHearts);
            }
            return;
        }
        if (current < (float)(extraHearts - 1) && player.f_19797_ % 180 == 0) {
            player.m_7911_(current + absorptionRate);
        }
    }

    public static void giveNoExtraHearts(Level world, Player player, ItemStack itemstack) {
        player.m_7911_(0.0f);
    }

    public static void doAttraction(Level level, Player player, ItemStack stack) {
        int ringPullRadius = (Integer)GobberConfigBuilder.RING_ATTRACTION_PULL_RADIUS.get();
        int ringAttractionBlocking = (Integer)GobberConfigBuilder.RING_ATTRACTION_BLOCK_DISTANCE.get();
        boolean ringAttractionMode = (Boolean)GobberConfigBuilder.RING_ATTRACTION_MODE.get();
        if (!level.f_46443_ && EnableUtil.isEnabled(stack)) {
            boolean init = MagnetRangeUtil.getCurrentlySet(stack);
            int range = !init ? ringPullRadius : MagnetRangeUtil.getCurrentRange(stack);
            double x = player.m_20185_();
            double y = player.m_20186_();
            double z = player.m_20189_();
            BlockPos playerPos = new BlockPos(player.m_20182_());
            for (Object targetPos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-range, -ringAttractionBlocking, -range), (BlockPos)playerPos.m_7918_(range, ringAttractionBlocking, range))) {
                BlockState blockstate = level.m_8055_((BlockPos)targetPos);
                if (blockstate.m_60734_() != Blocks.f_50353_) continue;
                return;
            }
            List items = player.f_19853_.m_45976_(ItemEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ItemEntity e : items) {
                if (player.m_6144_() || e.getPersistentData().m_128471_("PreventRemoteMovement")) continue;
                if (ringAttractionMode) {
                    e.m_6123_(player);
                    continue;
                }
                double factor = 0.035;
                e.m_5997_((x - e.m_20185_()) * factor, (y - e.m_20186_() + 1.25) * factor, (z - e.m_20189_()) * factor);
            }
            List xp = player.f_19853_.m_45976_(ExperienceOrb.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ExperienceOrb orb : xp) {
                if (player.m_6144_()) continue;
                if (ringAttractionMode) {
                    orb.m_6123_(player);
                    continue;
                }
                double factor = 0.035;
                orb.m_5997_((x - orb.m_20185_()) * factor, (y - orb.m_20186_() + 1.25) * factor, (z - orb.m_20189_()) * factor);
            }
        }
    }

    public static void doCuring(Player player) {
        if (player.m_21124_(MobEffects.f_19610_) != null) {
            player.m_21195_(MobEffects.f_19610_);
        }
        if (player.m_21124_(MobEffects.f_19597_) != null) {
            player.m_21195_(MobEffects.f_19597_);
        }
        if (player.m_21124_(MobEffects.f_19599_) != null) {
            player.m_21195_(MobEffects.f_19599_);
        }
        if (player.m_21124_(MobEffects.f_19602_) != null) {
            player.m_21195_(MobEffects.f_19602_);
        }
        if (player.m_21124_(MobEffects.f_19604_) != null) {
            player.m_21195_(MobEffects.f_19604_);
        }
        if (player.m_21124_(MobEffects.f_19612_) != null) {
            player.m_21195_(MobEffects.f_19612_);
        }
        if (player.m_21124_(MobEffects.f_19614_) != null) {
            player.m_21195_(MobEffects.f_19614_);
        }
        if (player.m_21124_(MobEffects.f_19615_) != null) {
            player.m_21195_(MobEffects.f_19615_);
        }
        if (player.m_21124_(MobEffects.f_19620_) != null) {
            player.m_21195_(MobEffects.f_19620_);
        }
        if (player.m_21124_(MobEffects.f_19590_) != null) {
            player.m_21195_(MobEffects.f_19590_);
        }
        if (player.m_21124_(MobEffects.f_19613_) != null) {
            player.m_21195_(MobEffects.f_19613_);
        }
        if (player.m_21124_(MobEffects.f_216964_) != null) {
            player.m_21195_(MobEffects.f_216964_);
        }
    }
}

