/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util;

import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class ExpUtils {
    public static int getPlayerXP(Player player) {
        return (int)((float)ExpUtils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = ExpUtils.getPlayerXP(player) + amount;
        player.f_36078_ = ExpUtils.getLevelForExperience(experience);
        int expForLevel = ExpUtils.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExpUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExpUtils.sum(level - 15, 37, 5);
        }
        return 1395 + ExpUtils.sum(level - 30, 112, 9);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = ExpUtils.getLevelForExperience(level);
        int nextXP = ExpUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExpUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static void addAllBooks(Enchantment enchantment, List<ItemStack> items) {
        for (int i = enchantment.m_44702_(); i <= enchantment.m_6586_(); ++i) {
            items.add(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i)));
        }
    }
}

