/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.hammer;

import com.google.common.collect.ImmutableSet;
import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.items.toolbaseclasses.HammerUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomHammerEnd
extends PickaxeItem {
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.f_76278_, (Object)Material.f_76279_, (Object)Material.f_76275_, (Object)Material.f_76276_, (Object)Material.f_76316_, (Object)Material.f_76281_, (Object[])new Material[0]);

    public ItemCustomHammerEnd(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Block block = state.m_60734_();
            boolean isWithinHarvestLevel = player.m_21205_().m_41735_(state);
            boolean isHarvestable = block.canHarvestBlock(state, (BlockGetter)world, pos, player);
            if (isHarvestable && isWithinHarvestLevel) {
                stack.m_220157_(1, world.f_46441_, null);
                HammerUtil.attemptBreakNeighbors(world, pos, player, EFFECTIVE_MATERIALS);
                return true;
            }
        }
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41721_(0);
        return true;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_ && player.m_6144_()) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        if (((Boolean)GobberConfigBuilder.END_GOBBER_TOOLS_UNBREAKABLE.get()).booleanValue()) {
            stack.m_41784_().m_128379_("Unbreakable", true);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"item.gobber2.gobber2_hammer.line1").m_130940_(ChatFormatting.GREEN));
    }
}

