/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.simpleores;

import cech12.bucketlib.api.BucketLibApi;
import javax.annotation.Nonnull;
import mod.alexndr.simplecorelib.api.config.FlagCondition;
import mod.alexndr.simplecorelib.api.config.ISimpleConfig;
import mod.alexndr.simpleores.config.ConfigHelper;
import mod.alexndr.simpleores.config.ConfigHolder;
import mod.alexndr.simpleores.config.SimpleOresConfig;
import mod.alexndr.simpleores.init.ModBlocks;
import mod.alexndr.simpleores.init.ModItems;
import mod.alexndr.simpleores.init.ModTabGroups;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="simpleores", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"simpleores Mod Event Subscriber");

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.debug("Common setup done");
    }

    @SubscribeEvent
    public static void onSendIMC(InterModEnqueueEvent evt) {
        BucketLibApi.registerBucket((ResourceLocation)ModItems.copper_bucket.getId());
    }

    @SubscribeEvent
    public static void onRegisterItems(RegisterEvent event) {
        if (event.getRegistryKey() == Registry.f_122904_) {
            ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
                Item.Properties properties = new Item.Properties().m_41491_(ModTabGroups.MOD_ITEM_GROUP);
                BlockItem blockItem = new BlockItem(block, properties);
                event.register(Registry.f_122904_, helper -> helper.register(ForgeRegistries.BLOCKS.getKey(block), (Object)blockItem));
            });
            LOGGER.debug("Registered BlockItems");
        }
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ConfigHelper.bakeServer(config);
        }
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
        }
    }

    @SubscribeEvent
    public static void onRegisterRecipeSerializers(@Nonnull RegisterEvent event) {
        if (event.getRegistryKey() == Registry.f_122915_) {
            CraftingHelper.register((IConditionSerializer)new FlagCondition.Serializer((ISimpleConfig)SimpleOresConfig.INSTANCE, new ResourceLocation("simpleores", "flag")));
        }
    }
}

