/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.easy_emerald.util.handlers;

import com.kwpugh.easy_emerald.config.GeneralModConfig;
import com.kwpugh.easy_emerald.util.PlayerEquipUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="easy_emerald", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class AbilityEventHandler {
    static boolean enableRubySwordLoot = (Boolean)GeneralModConfig.RUBY_SWORD_PERKS.get();

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource() == DamageSource.f_19315_ && PlayerEquipUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.f_19305_ || event.getSource() == DamageSource.f_19307_ || event.getSource() == DamageSource.f_19309_ || event.getSource() == DamageSource.f_19308_) && PlayerEquipUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.f_19312_ && PlayerEquipUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void extraLootingEvent(LootingLevelEvent event) {
        Player playerEntity;
        Entity entity;
        if (!enableRubySwordLoot) {
            return;
        }
        if (event.getDamageSource() != null && event.getDamageSource().m_7639_() != null && event.getEntity() instanceof Mob && (entity = event.getDamageSource().m_7639_()) instanceof Player && PlayerEquipUtil.isPlayerGotRubySwordInHand(playerEntity = (Player)entity)) {
            event.setLootingLevel(event.getLootingLevel() + 9);
        }
    }
}

