/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.easy_emerald.items.tools.util;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class HammerUtil {
    static int blocksBroken;

    public static int attemptBreakNeighbors(Level world, BlockPos pos, Player player, Set<Material> effectiveMaterials) {
        blocksBroken = 0;
        HitResult trace = HammerUtil.calcRayTrace(world, player, ClipContext.Fluid.ANY);
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockTrace = (BlockHitResult)trace;
            Direction face = blockTrace.m_82434_();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.m_7918_(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.m_7918_(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.m_7918_(0, a, b);
                    }
                    HammerUtil.attemptBreak(world, target, player, effectiveMaterials);
                }
            }
        }
        return blocksBroken;
    }

    public static void attemptBreak(Level world, BlockPos pos, Player player, Set<Material> effectiveMaterials) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        boolean isWithinHarvestLevel = player.m_21205_().m_41735_(state);
        boolean isHarvestable = block.canHarvestBlock(state, (BlockGetter)world, pos, player);
        boolean isEffective = effectiveMaterials.contains(state.m_60767_());
        boolean witherImmune = state.m_204336_(BlockTags.f_13070_);
        if (isEffective && !witherImmune && isWithinHarvestLevel & isHarvestable && !state.m_155947_()) {
            world.m_46961_(pos, false);
            Block.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            ++blocksBroken;
        }
    }

    public static HitResult calcRayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        float f = player.f_19860_;
        float f1 = player.f_19859_;
        Vec3 vec3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0;
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }
}

