/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.common.CommonCollect;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.BlockStatesMap;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import com.endertech.minecraft.mods.adlods.world.WorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractOre
implements IHaveConfig {
    protected final UnitConfig config;
    protected final CommonCollect.BlackWhiteList<BiomeId> biomes;
    protected final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final IntBounds altitude;
    protected final BlockStatesSet replaceableBlocks;
    protected final BlockStatesMap<BlockState> customReplacements;
    protected final Miscellaneous miscellaneous;

    public AbstractOre(UnitConfig config, Properties<?> props) {
        String category = this.getClassCategory();
        this.config = config;
        this.dimensions = Dimensions.from((UnitConfig)config, (String)category, (String)"List of dimensions which this ore can be generated in.", (String[])new String[0], (String[])props.allowedDimensions);
        this.biomes = Biomes.from((UnitConfig)config, (String)category, (String)"List of biomes which this ore can be generated in.");
        this.altitude = UnitConfig.getIntBounds((UnitConfig)config, (String)category, (String)"Altitude", (IntBounds)props.altitude, (IntBounds)IntBounds.INTEGER, (String)"Altitude which this ore can be generated at.");
        this.replaceableBlocks = BlockStatesSet.parseFrom((String[])UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"replaceableBlocks", (String[])props.replaceableBlocks, (String)"List of blocks that can be replaced with this ore."));
        this.customReplacements = BlockStatesMap.parseReplacementsFrom((String[])UnitConfig.getStrArray((UnitConfig)config, (String)category, (String)"customReplacements", (String[])props.customReplacements, (String)"Syntax: targetId -> replacementId"));
        this.miscellaneous = Miscellaneous.of(config, category, props.miscellaneous);
        this.saveConfig();
    }

    protected abstract int generate(WorldGenLevel var1, BlockPos var2, int var3, boolean var4);

    protected abstract boolean replaceWithOre(LevelAccessor var1, BlockPos var2);

    public abstract boolean isValid();

    public UnitConfig getConfig() {
        return this.config;
    }

    public IntBounds getAltitude() {
        return this.altitude;
    }

    public boolean inAllowedDimenstion(ServerLevelAccessor world) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((Level)world.m_6018_()));
    }

    public boolean inAllowedBiome(LevelAccessor world, BlockPos pos) {
        return this.biomes.isEmpty() || this.biomes.isAllowed((Object)BiomeId.from((LevelAccessor)world, (BlockPos)pos));
    }

    public boolean canBeReplaced(LevelAccessor world, BlockPos pos, boolean testing) {
        if (testing && GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) {
            return true;
        }
        BlockState replaceable = world.m_8055_(pos);
        return this.replaceableBlocks.contains((Object)replaceable) || this.customReplacements.containsKey((Object)replaceable);
    }

    public boolean isValidPosition(WorldGenLevel level, BlockPos pos, BlockPos startPos, boolean testing) {
        if (!WorldData.inAdjacentChunk(pos, level, new ChunkPos(startPos), true)) {
            return false;
        }
        if (level.m_151570_(pos)) {
            return false;
        }
        if (testing ? Math.abs(pos.m_123342_() - startPos.m_123342_()) > this.altitude.length() / 2 : !this.altitude.encloses(Integer.valueOf(pos.m_123342_()))) {
            return false;
        }
        if (!testing && !this.inAllowedBiome((LevelAccessor)level, pos)) {
            return false;
        }
        return testing || this.miscellaneous.exposed || !this.exposedToAir((LevelAccessor)level, pos);
    }

    protected boolean exposedToAir(LevelAccessor world, BlockPos posIn) {
        for (BlockPos pos : GameWorld.Positions.getAroundCube((BlockPos)posIn)) {
            if (!GameWorld.isBlockLoaded((LevelReader)world, (BlockPos)pos)) {
                return true;
            }
            if (!GameWorld.isAirBlock((LevelReader)world, (BlockPos)pos)) continue;
            return true;
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends RelatedUnit.Properties<T> {
        public IntBounds altitude = IntBounds.ZERO;
        public String[] replaceableBlocks = new String[0];
        public String[] allowedDimensions = new String[0];
        public String[] customReplacements = new String[0];
        public Miscellaneous.Properties<?> miscellaneous = Miscellaneous.Properties.of();

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T dimension(Dimensions dimension) {
            return ((Properties)((Object)this.allowedDimensions(dimension.dimensionId.toResourceLocation().toString()))).replaceableBlocks(dimension.replaceableBlockId.toString());
        }

        public T altitude(int min, int max) {
            this.altitude = IntBounds.between((Integer)min, (Integer)max);
            return (T)((Object)((Properties)this.self));
        }

        public T allowedDimensions(String ... dimensions) {
            this.allowedDimensions = dimensions;
            return (T)((Object)((Properties)this.self));
        }

        public T deepslate(String ore) {
            String deepslate = "deepslate";
            String target = "#minecraft:deepslate_ore_replaceables";
            String replacement = ore.contains("deepslate") ? ore : Names.registry().join(new String[]{"deepslate", ore});
            return this.customReplacements("#minecraft:deepslate_ore_replaceables -> " + replacement);
        }

        public T replaceableBlocks(String ... blocks) {
            this.replaceableBlocks = blocks;
            return (T)((Object)((Properties)this.self));
        }

        public T customReplacements(String ... replacements) {
            this.customReplacements = replacements;
            return (T)((Object)((Properties)this.self));
        }

        public T exposed(boolean value) {
            this.miscellaneous.exposed(value);
            return (T)((Object)((Properties)this.self));
        }
    }
}

