/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adlods.Commands;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.init.BiomeModifierCodecs;
import com.endertech.minecraft.mods.adlods.init.Features;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaController;
import com.mojang.brigadier.arguments.ArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adlods")
public class AdLods
extends AbstractForgeMod {
    public static final String ID = "adlods";
    private static AdLods instance;
    public final Features features;
    public final BiomeModifierCodecs codecs;

    public AdLods() {
        instance = this;
        this.features = new Features(this);
        this.codecs = new BiomeModifierCodecs(this);
        this.registerCommonConfig();
    }

    public static AdLods getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public AbstractForgeMod.RequiredSide getRequiredSide() {
        return AbstractForgeMod.RequiredSide.SERVER;
    }

    public void commonInit() {
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("Deposits");
        Deposit.globalSizeMultiplier = value.comment("Size multiplier to be applied to all deposits").defineInRange("globalSizeMultiplier", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)));
        Deposit.globalSpawnRateMultiplier = value.comment("Spawn rate multiplier to be applied to all deposits").defineInRange("globalSpawnRateMultiplier", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)));
        value.pop();
    }

    public void commonPostInit() {
        super.commonPostInit();
        this.features.reload();
    }

    public void tagsUpdated() {
        this.features.reload();
    }

    protected void serverStopped(MinecraftServer server) {
        ((VanillaController)((Object)this.features.controller.get())).unloadOres();
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listDeposits, "deposits").executes(Commands::listGenerated, "generated");
        command.task("locate").executes(Commands::locateConfigs, "configs");
        command.task("add").executes(context -> Commands.addDeposit(context, false), new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("addspec").executes(context -> Commands.addDeposit(context, true), new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS), ServerCommand.Arg.of((String)"oreId", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext))});
        command.task("remove").executes(Commands::removeDeposit, new ServerCommand.Arg[]{Commands.depositArgument()});
        command.task("gen").executes(Commands::generateDeposit, new ServerCommand.Arg[]{Commands.depositArgument()}).executes(Commands::generateDepositAtChunk, new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("genat").executes(Commands::generateDepositAtPos, new ServerCommand.Arg[]{ServerCommand.Arg.integer((String)"posX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"posZ", (IntBounds)IntBounds.INTEGER), Commands.depositArgument()});
        command.task("test").executes(Commands::testDeposit, new ServerCommand.Arg[]{Commands.depositArgument(), ServerCommand.Arg.integer((String)"amount", (IntBounds)Deposit.Size.BOUNDS)});
        command.task("reload").executes(Commands::reloadConfigs, new ServerCommand.Arg[0]);
        command.task("strip").executes(Commands::stripChunk, "chunk").executes(Commands::stripChunksAround, "around");
        command.task("dress").executes(Commands::dressChunk, "chunk").executes(Commands::dressChunksAround, "around").executes(Commands::dressAllChunks, "all");
        command.register();
    }
}

