/*
 * Decompiled with CFR 0.152.
 */
package oresAboveDiamonds.world;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import oresAboveDiamonds.config.OADConfig;
import oresAboveDiamonds.world.OADConfiguredFeature;

@Mod.EventBusSubscriber
public class OADPlacedFeature {
    public static final DeferredRegister<PlacedFeature> PLACED_FEATURES;
    public static final HeightRangePlacement aPlacement;
    public static final HeightRangePlacement bPlacement;

    public static HeightRangePlacement buildPlacement(int maxHeight) {
        return HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)(-64 - maxHeight)), (VerticalAnchor)VerticalAnchor.m_158930_((int)(64 + maxHeight)));
    }

    public static HeightRangePlacement buildPlacement(int minHeight, int maxHeight) {
        return HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxHeight));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return OADPlacedFeature.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        if (p_195350_ <= 0) {
            return OADPlacedFeature.commonOrePlacement(0, p_195351_);
        }
        return OADPlacedFeature.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
    }

    private static int[] closestDenominators(double c) {
        int x = 0;
        int y = 0;
        double error = Double.MAX_VALUE;
        double s = 2.0 / c;
        if (Math.floor(s) == Math.ceil(s)) {
            x = (int)s;
            y = (int)s;
            error = 0.0;
        } else {
            s = 1.0 / c;
            int min = Math.floor(s) == Math.ceil(s) ? (int)(Math.floor(s) + 1.0) : (int)Math.ceil(s);
            double r = -((double)min) / (1.0 - c * (double)min);
            if (Math.floor(r) == Math.ceil(r)) {
                x = min;
                y = (int)Math.ceil(r);
                error = 0.0;
            } else {
                int max = (int)Math.floor(r);
                for (int i = min; i <= max; ++i) {
                    double exact = -((double)i) / (1.0 - c * (double)i);
                    if (Math.floor(exact) == Math.ceil(exact)) {
                        x = i;
                        y = (int)Math.ceil(exact);
                        error = 0.0;
                        break;
                    }
                    double local_error = Math.abs(c - 1.0 / (double)i - 1.0 / (double)Math.round(exact));
                    if (!(local_error < error)) continue;
                    error = local_error;
                    x = i;
                    y = (int)Math.round(exact);
                }
            }
        }
        int[] denominators = new int[]{x, y};
        return denominators;
    }

    static {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        int[] nArray5;
        int[] nArray6;
        int[] nArray7;
        int[] nArray8;
        int[] nArray9;
        int[] nArray10;
        PLACED_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"oresabovediamonds");
        aPlacement = OADPlacedFeature.buildPlacement((Integer)OADConfig.amethyst_max_spawn_height_overworld.get());
        bPlacement = OADPlacedFeature.buildPlacement((Integer)OADConfig.black_opal_max_spawn_height_overworld.get());
        boolean enabled = (Boolean)OADConfig.spawn_amethyst_overworld.get();
        String name = "ore_amethyst";
        double veinsPerChunk = 7.0 / (Double)OADConfig.amethyst_times_rarer.get();
        int integerPart = enabled ? (int)veinsPerChunk : 0;
        double doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray10 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray11 = new int[2];
            nArray11[0] = -1;
            nArray10 = nArray11;
            nArray11[1] = -1;
        }
        int[] denominators = nArray10;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_SMALL, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)aPlacement)));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_SMALL, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)aPlacement)));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_SMALL, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)aPlacement)));
        enabled = (Boolean)OADConfig.spawn_amethyst_overworld.get();
        name = "ore_amethyst_buried";
        veinsPerChunk = 4.0 / (Double)OADConfig.amethyst_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray9 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray12 = new int[2];
            nArray12[0] = -1;
            nArray9 = nArray12;
            nArray12[1] = -1;
        }
        denominators = nArray9;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_BURIED, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)aPlacement)));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_BURIED, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)aPlacement)));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_BURIED, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)aPlacement)));
        enabled = (Boolean)OADConfig.spawn_amethyst_overworld.get();
        name = "ore_amethyst_large";
        veinsPerChunk = 1.0 / ((Double)OADConfig.amethyst_times_rarer.get() * 9.0);
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray8 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray13 = new int[2];
            nArray13[0] = -1;
            nArray8 = nArray13;
            nArray13[1] = -1;
        }
        denominators = nArray8;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_LARGE, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)aPlacement)));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_LARGE, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)aPlacement)));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.AMETHYST_LARGE, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)aPlacement)));
        enabled = (Boolean)OADConfig.spawn_black_opal_overworld.get();
        name = "ore_black_opal";
        veinsPerChunk = 7.0 / (Double)OADConfig.black_opal_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray7 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray14 = new int[2];
            nArray14[0] = -1;
            nArray7 = nArray14;
            nArray14[1] = -1;
        }
        denominators = nArray7;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_SMALL, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)bPlacement)));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_SMALL, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)bPlacement)));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_SMALL, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)bPlacement)));
        enabled = (Boolean)OADConfig.spawn_black_opal_overworld.get();
        name = "ore_black_opal_buried";
        veinsPerChunk = 4.0 / (Double)OADConfig.black_opal_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray6 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray15 = new int[2];
            nArray15[0] = -1;
            nArray6 = nArray15;
            nArray15[1] = -1;
        }
        denominators = nArray6;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_BURIED, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)bPlacement)));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_BURIED, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)bPlacement)));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_BURIED, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)bPlacement)));
        enabled = (Boolean)OADConfig.spawn_black_opal_overworld.get();
        name = "ore_black_opal_large";
        veinsPerChunk = 1.0 / ((Double)OADConfig.black_opal_times_rarer.get() * 9.0);
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray5 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray16 = new int[2];
            nArray16[0] = -1;
            nArray5 = nArray16;
            nArray16[1] = -1;
        }
        denominators = nArray5;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_LARGE, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)bPlacement)));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_LARGE, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)bPlacement)));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.BLACK_OPAL_LARGE, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)bPlacement)));
        enabled = (Boolean)OADConfig.spawn_amethyst_nether.get();
        name = "ore_nether_amethyst";
        veinsPerChunk = 9.0 * (Double)OADConfig.nether_chance_multiplier.get() / (Double)OADConfig.amethyst_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray4 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray17 = new int[2];
            nArray17[0] = -1;
            nArray4 = nArray17;
            nArray17[1] = -1;
        }
        denominators = nArray4;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.NETHER_AMETHYST, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.amethyst_max_spawn_height_nether.get()))));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.NETHER_AMETHYST, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.amethyst_max_spawn_height_nether.get()))));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.NETHER_AMETHYST, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.amethyst_max_spawn_height_nether.get()))));
        enabled = (Boolean)OADConfig.spawn_black_opal_nether.get();
        name = "ore_nether_black_opal";
        veinsPerChunk = 9.0 * (Double)OADConfig.nether_chance_multiplier.get() / (Double)OADConfig.black_opal_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray3 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray18 = new int[2];
            nArray18[0] = -1;
            nArray3 = nArray18;
            nArray18[1] = -1;
        }
        denominators = nArray3;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.NETHER_BLACK_OPAL, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.black_opal_max_spawn_height_nether.get()))));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.NETHER_BLACK_OPAL, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.black_opal_max_spawn_height_nether.get()))));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.NETHER_BLACK_OPAL, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.black_opal_max_spawn_height_nether.get()))));
        enabled = (Boolean)OADConfig.spawn_amethyst_end.get();
        name = "ore_end_amethyst";
        veinsPerChunk = 3.0 * (Double)OADConfig.end_chance_multiplier.get() / (Double)OADConfig.amethyst_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray2 = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray19 = new int[2];
            nArray19[0] = -1;
            nArray2 = nArray19;
            nArray19[1] = -1;
        }
        denominators = nArray2;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.END_AMETHYST, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.amethyst_max_spawn_height_end.get()))));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.END_AMETHYST, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.amethyst_max_spawn_height_end.get()))));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.END_AMETHYST, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.amethyst_max_spawn_height_end.get()))));
        enabled = (Boolean)OADConfig.spawn_black_opal_end.get();
        name = "ore_end_black_opal";
        veinsPerChunk = 3.0 * (Double)OADConfig.end_chance_multiplier.get() / (Double)OADConfig.black_opal_times_rarer.get();
        integerPart = enabled ? (int)veinsPerChunk : 0;
        doublePart = veinsPerChunk - (double)integerPart;
        if (enabled) {
            nArray = OADPlacedFeature.closestDenominators(doublePart);
        } else {
            int[] nArray20 = new int[2];
            nArray20[0] = -1;
            nArray = nArray20;
            nArray20[1] = -1;
        }
        denominators = nArray;
        PLACED_FEATURES.register(name, () -> new PlacedFeature(OADConfiguredFeature.END_BLACK_OPAL, OADPlacedFeature.commonOrePlacement(integerPart, (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.black_opal_max_spawn_height_end.get()))));
        PLACED_FEATURES.register(String.format("%s_2", name), () -> new PlacedFeature(OADConfiguredFeature.END_BLACK_OPAL, OADPlacedFeature.rareOrePlacement(denominators[0], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.black_opal_max_spawn_height_end.get()))));
        PLACED_FEATURES.register(String.format("%s_3", name), () -> new PlacedFeature(OADConfiguredFeature.END_BLACK_OPAL, OADPlacedFeature.rareOrePlacement(denominators[1], (PlacementModifier)OADPlacedFeature.buildPlacement(0, (Integer)OADConfig.black_opal_max_spawn_height_end.get()))));
    }
}

