/*
 * Decompiled with CFR 0.152.
 */
package oresAboveDiamonds.world;

import com.google.common.collect.ImmutableList;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import oresAboveDiamonds.blocks.AmethystOre;
import oresAboveDiamonds.blocks.BlackOpalOre;
import oresAboveDiamonds.config.OADConfig;
import oresAboveDiamonds.init.ModBlocks;

public class OADConfiguredFeature {
    public static ImmutableList<OreConfiguration.TargetBlockState> AMETHYST_TARGET_BLOCKS = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((AmethystOre)((Object)ModBlocks.AMETHYST_ORE.get())).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((AmethystOre)((Object)ModBlocks.DEEPSLATE_AMETHYST_ORE.get())).m_49966_()));
    public static ImmutableList<OreConfiguration.TargetBlockState> NETHER_AMETHYST_TARGET_BLOCKS = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)((AmethystOre)((Object)ModBlocks.NETHER_AMETHYST_ORE.get())).m_49966_()));
    public static ImmutableList<OreConfiguration.TargetBlockState> END_AMETHYST_TARGET_BLOCKS = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(Blocks.f_50259_), (BlockState)((AmethystOre)((Object)ModBlocks.END_AMETHYST_ORE.get())).m_49966_()));
    public static ImmutableList<OreConfiguration.TargetBlockState> BLACK_OPAL_TARGET_BLOCKS = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((BlackOpalOre)((Object)ModBlocks.BLACK_OPAL_ORE.get())).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((BlackOpalOre)((Object)ModBlocks.DEEPSLATE_BLACK_OPAL_ORE.get())).m_49966_()));
    public static ImmutableList<OreConfiguration.TargetBlockState> NETHER_BLACK_OPAL_TARGET_BLOCKS = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195075_, (BlockState)((BlackOpalOre)((Object)ModBlocks.NETHER_BLACK_OPAL_ORE.get())).m_49966_()));
    public static ImmutableList<OreConfiguration.TargetBlockState> END_BLACK_OPAL_TARGET_BLOCKS = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(Blocks.f_50259_), (BlockState)((BlackOpalOre)((Object)ModBlocks.END_BLACK_OPAL_ORE.get())).m_49966_()));
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> AMETHYST_SMALL = OADConfiguredFeature.buildConfigured("ore_amethyst", AMETHYST_TARGET_BLOCKS, (double)((Integer)OADConfig.amethyst_vein_size.get()).intValue() / 2.0, ((Double)OADConfig.overworld_discard_chance_on_air_exposure.get()).floatValue() * 0.715f);
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> BLACK_OPAL_SMALL = OADConfiguredFeature.buildConfigured("ore_black_opal", BLACK_OPAL_TARGET_BLOCKS, (double)((Integer)OADConfig.black_opal_vein_size.get()).intValue() / 2.0, ((Double)OADConfig.overworld_discard_chance_on_air_exposure.get()).floatValue() * 0.715f);
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> AMETHYST_LARGE;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> BLACK_OPAL_LARGE;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> AMETHYST_BURIED;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> BLACK_OPAL_BURIED;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> NETHER_AMETHYST;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> NETHER_BLACK_OPAL;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> END_AMETHYST;
    public static Holder<ConfiguredFeature<OreConfiguration, ?>> END_BLACK_OPAL;

    public static Holder<ConfiguredFeature<OreConfiguration, ?>> buildConfigured(String name, ImmutableList<OreConfiguration.TargetBlockState> targets, double veinSize, float discardChance) {
        return FeatureUtils.m_206488_((String)name, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(targets, (int)Math.round(veinSize), discardChance));
    }

    static {
        AMETHYST_BURIED = OADConfiguredFeature.buildConfigured("ore_amethyst_buried", AMETHYST_TARGET_BLOCKS, ((Integer)OADConfig.amethyst_vein_size.get()).intValue(), Math.min(1.0f, ((Double)OADConfig.overworld_discard_chance_on_air_exposure.get()).floatValue() * 1.43f));
        BLACK_OPAL_BURIED = OADConfiguredFeature.buildConfigured("ore_black_opal_buried", BLACK_OPAL_TARGET_BLOCKS, ((Integer)OADConfig.black_opal_vein_size.get()).intValue(), Math.min(1.0f, ((Double)OADConfig.overworld_discard_chance_on_air_exposure.get()).floatValue() * 1.43f));
        AMETHYST_LARGE = OADConfiguredFeature.buildConfigured("ore_amethyst_large", AMETHYST_TARGET_BLOCKS, (double)((Integer)OADConfig.amethyst_vein_size.get()).intValue() * 1.5, ((Double)OADConfig.overworld_discard_chance_on_air_exposure.get()).floatValue());
        BLACK_OPAL_LARGE = OADConfiguredFeature.buildConfigured("ore_black_opal_large", BLACK_OPAL_TARGET_BLOCKS, (double)((Integer)OADConfig.black_opal_vein_size.get()).intValue() * 1.5, ((Double)OADConfig.overworld_discard_chance_on_air_exposure.get()).floatValue());
        int netherAmethystVeinSize = (int)Math.round((double)((Integer)OADConfig.amethyst_vein_size.get()).intValue() * (Double)OADConfig.nether_vein_multiplier.get());
        int netherBlackOpalVeinSize = (int)Math.round((double)((Integer)OADConfig.black_opal_vein_size.get()).intValue() * (Double)OADConfig.nether_vein_multiplier.get());
        NETHER_AMETHYST = OADConfiguredFeature.buildConfigured("ore_nether_amethyst", NETHER_AMETHYST_TARGET_BLOCKS, netherAmethystVeinSize, ((Double)OADConfig.nether_discard_chance_on_air_exposure.get()).floatValue());
        NETHER_BLACK_OPAL = OADConfiguredFeature.buildConfigured("ore_nether_black_opal", NETHER_BLACK_OPAL_TARGET_BLOCKS, netherBlackOpalVeinSize, ((Double)OADConfig.nether_discard_chance_on_air_exposure.get()).floatValue());
        int endAmethystVeinSize = (int)Math.round((double)((Integer)OADConfig.amethyst_vein_size.get()).intValue() * (Double)OADConfig.end_vein_multiplier.get());
        int endBlackOpalVeinSize = (int)Math.round((double)((Integer)OADConfig.black_opal_vein_size.get()).intValue() * (Double)OADConfig.end_vein_multiplier.get());
        END_AMETHYST = OADConfiguredFeature.buildConfigured("ore_end_amethyst", END_AMETHYST_TARGET_BLOCKS, endAmethystVeinSize, ((Double)OADConfig.end_discard_chance_on_air_exposure.get()).floatValue());
        END_BLACK_OPAL = OADConfiguredFeature.buildConfigured("ore_end_black_opal", END_BLACK_OPAL_TARGET_BLOCKS, endBlackOpalVeinSize, ((Double)OADConfig.end_discard_chance_on_air_exposure.get()).floatValue());
    }
}

