/*
 * Decompiled with CFR 0.152.
 */
package oresAboveDiamonds.lists;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import oresAboveDiamonds.config.OADConfig;
import oresAboveDiamonds.init.ModItems;

public enum ArmorMaterialList implements ArmorMaterial
{
    AMETHYST("amethyst", (Integer)OADConfig.amethyst_armor_durability.get(), new int[]{(Integer)OADConfig.amethyst_boots_armor.get(), (Integer)OADConfig.amethyst_leggings_armor.get(), (Integer)OADConfig.amethyst_chestplate_armor.get(), (Integer)OADConfig.amethyst_helmet_armor.get()}, (Integer)OADConfig.amethyst_enchantability.get(), (Item)ModItems.AMETHYST.get(), SoundEvents.f_11673_, ((Integer)OADConfig.amethyst_armor_toughness.get()).intValue(), (float)((Integer)OADConfig.amethyst_armor_knockback_resistance.get()).intValue() / 10.0f),
    BLACK_OPAL("black_opal", (Integer)OADConfig.black_opal_armor_durability.get(), new int[]{(Integer)OADConfig.black_opal_boots_armor.get(), (Integer)OADConfig.black_opal_leggings_armor.get(), (Integer)OADConfig.black_opal_chestplate_armor.get(), (Integer)OADConfig.black_opal_helmet_armor.get()}, (Integer)OADConfig.black_opal_enchantability.get(), (Item)ModItems.BLACK_OPAL.get(), SoundEvents.f_11893_, ((Integer)OADConfig.black_opal_armor_toughness.get()).intValue(), (float)((Integer)OADConfig.black_opal_armor_knockback_resistance.get()).intValue() / 10.0f),
    NETHERITE_OPAL("netherite_opal", (Integer)OADConfig.netherite_opal_armor_durability.get(), new int[]{(Integer)OADConfig.netherite_opal_boots_armor.get(), (Integer)OADConfig.netherite_opal_leggings_armor.get(), (Integer)OADConfig.netherite_opal_chestplate_armor.get(), (Integer)OADConfig.netherite_opal_helmet_armor.get()}, (Integer)OADConfig.netherite_opal_enchantability.get(), (Item)ModItems.BLACK_OPAL.get(), SoundEvents.f_11893_, ((Integer)OADConfig.netherite_opal_armor_toughness.get()).intValue(), (float)((Integer)OADConfig.netherite_opal_armor_knockback_resistance.get()).intValue() / 10.0f);

    private static final int[] MAX_DAMAGE_ARRAY;
    private String name;
    private SoundEvent equipSound;
    private int durability;
    private int enchantability;
    private Item repairItem;
    private int[] damageReductionAmounts;
    private float toughness;
    private float knockback_resistance;
    private boolean infinite_durability;

    private ArmorMaterialList(String name, int durability, int[] damageReductionAmounts, int enchantability, Item item, SoundEvent equipSound, float toughness, float knockback_resistance) {
        this.name = name;
        this.equipSound = equipSound;
        if (durability <= 0) {
            this.durability = Integer.MAX_VALUE;
            this.infinite_durability = true;
        } else {
            this.durability = durability;
            this.infinite_durability = false;
        }
        this.repairItem = item;
        this.enchantability = enchantability;
        this.damageReductionAmounts = damageReductionAmounts;
        this.toughness = toughness;
        this.knockback_resistance = knockback_resistance;
    }

    public int m_7366_(EquipmentSlot slot) {
        return MAX_DAMAGE_ARRAY[slot.m_20749_()] * this.durability;
    }

    public int m_7365_(EquipmentSlot slot) {
        return this.damageReductionAmounts[slot.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.repairItem});
    }

    public String m_6082_() {
        return "oresabovediamonds:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockback_resistance;
    }

    public boolean isInfinite() {
        return this.infinite_durability;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

