/*
 * Decompiled with CFR 0.152.
 */
package oresAboveDiamonds.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import oresAboveDiamonds.config.OADConfig;
import oresAboveDiamonds.util.KeyboardUtil;

public class TooltipBlockItem
extends BlockItem {
    public TooltipBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void addDescription(List<Component> tooltip, double chance, double vein, int height, String world, String color, double disappearChance) {
        tooltip.add((Component)Component.m_237113_((String)("\u00a7aGenerating in the " + world)));
        if (world.equalsIgnoreCase("Nether")) {
            tooltip.add((Component)Component.m_237113_((String)(color + 2.0 * chance + "x\u00a7r rarer than nether gold ore")));
        } else if (world.equalsIgnoreCase("End")) {
            tooltip.add((Component)Component.m_237113_((String)(color + chance + "x\u00a7r less dense than overworld diamonds")));
        } else {
            tooltip.add((Component)Component.m_237113_((String)(color + chance + "x\u00a7r rarer than diamonds")));
        }
        tooltip.add((Component)Component.m_237113_((String)("Max vein size of " + color + vein)));
        tooltip.add((Component)Component.m_237113_((String)("Spawns below " + color + "y:" + height)));
        tooltip.add((Component)Component.m_237113_((String)(color + Math.round(disappearChance * 100.0) + "%\u00a7r chance of disappearing if exposed to air")));
    }

    public void addDisabled(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
        tooltip.add((Component)Component.m_237113_((String)"Can be enabled in the config file."));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String blockName = this.m_5524_().toUpperCase();
        blockName = blockName.substring(blockName.lastIndexOf(".") + 1);
        if (KeyboardUtil.isHoldingShift()) {
            switch (blockName) {
                case "DEEPSLATE_AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_overworld.get()).booleanValue()) {
                        tooltip.add((Component)Component.m_237113_((String)"Spawns when a normal amethyst ore tries to generate in a deepslate block."));
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_overworld.get()).booleanValue()) {
                        this.addDescription(tooltip, (Double)OADConfig.amethyst_times_rarer.get(), ((Integer)OADConfig.amethyst_vein_size.get()).intValue(), (Integer)OADConfig.amethyst_max_spawn_height_overworld.get(), "Overworld", "\u00a7d", (Double)OADConfig.overworld_discard_chance_on_air_exposure.get());
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "NETHER_AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_nether.get()).booleanValue()) {
                        int spawnchance = Math.max(1, (int)((Double)OADConfig.amethyst_times_rarer.get() / (Double)OADConfig.nether_chance_multiplier.get()));
                        int veinsize = (int)((double)((Integer)OADConfig.amethyst_vein_size.get()).intValue() * (Double)OADConfig.nether_vein_multiplier.get());
                        this.addDescription(tooltip, spawnchance, veinsize, (Integer)OADConfig.amethyst_max_spawn_height_nether.get(), "Nether", "\u00a7d", (Double)OADConfig.nether_discard_chance_on_air_exposure.get());
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "END_AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_end.get()).booleanValue()) {
                        int spawnchance = Math.max(1, (int)((Double)OADConfig.amethyst_times_rarer.get() / (Double)OADConfig.end_chance_multiplier.get()));
                        int veinsize = (int)((double)((Integer)OADConfig.amethyst_vein_size.get()).intValue() * (Double)OADConfig.end_vein_multiplier.get());
                        this.addDescription(tooltip, spawnchance, veinsize, (Integer)OADConfig.amethyst_max_spawn_height_end.get(), "End", "\u00a7d", (Double)OADConfig.end_discard_chance_on_air_exposure.get());
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "DEEPSLATE_BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_overworld.get()).booleanValue()) {
                        tooltip.add((Component)Component.m_237113_((String)"Spawns when a normal black opal ore tries to generate in a deepslate block."));
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_overworld.get()).booleanValue()) {
                        this.addDescription(tooltip, (Double)OADConfig.black_opal_times_rarer.get(), ((Integer)OADConfig.black_opal_vein_size.get()).intValue(), (Integer)OADConfig.black_opal_max_spawn_height_overworld.get(), "Overworld", "\u00a75", (Double)OADConfig.overworld_discard_chance_on_air_exposure.get());
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "NETHER_BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_nether.get()).booleanValue()) {
                        int spawnchance = Math.max(1, (int)((Double)OADConfig.black_opal_times_rarer.get() / (Double)OADConfig.nether_chance_multiplier.get()));
                        int veinsize = (int)((double)((Integer)OADConfig.black_opal_vein_size.get()).intValue() * (Double)OADConfig.nether_vein_multiplier.get());
                        this.addDescription(tooltip, spawnchance, veinsize, (Integer)OADConfig.black_opal_max_spawn_height_nether.get(), "Nether", "\u00a75", (Double)OADConfig.nether_discard_chance_on_air_exposure.get());
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
                case "END_BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_end.get()).booleanValue()) {
                        int spawnchance = Math.max(1, (int)((Double)OADConfig.black_opal_times_rarer.get() / (Double)OADConfig.end_chance_multiplier.get()));
                        int veinsize = (int)((double)((Integer)OADConfig.black_opal_vein_size.get()).intValue() * (Double)OADConfig.end_vein_multiplier.get());
                        this.addDescription(tooltip, spawnchance, veinsize, (Integer)OADConfig.black_opal_max_spawn_height_end.get(), "End", "\u00a75", (Double)OADConfig.end_discard_chance_on_air_exposure.get());
                        break;
                    }
                    this.addDisabled(tooltip);
                    break;
                }
            }
        } else {
            switch (blockName) {
                case "DEEPSLATE_AMETHYST_ORE": 
                case "AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_overworld.get()).booleanValue()) break;
                    tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
                    break;
                }
                case "NETHER_AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_nether.get()).booleanValue()) break;
                    tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
                    break;
                }
                case "END_AMETHYST_ORE": {
                    if (((Boolean)OADConfig.spawn_amethyst_end.get()).booleanValue()) break;
                    tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
                    break;
                }
                case "DEEPSLATE_BLACK_OPAL_ORE": 
                case "BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_overworld.get()).booleanValue()) break;
                    tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
                    break;
                }
                case "NETHER_BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_nether.get()).booleanValue()) break;
                    tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
                    break;
                }
                case "END_BLACK_OPAL_ORE": {
                    if (((Boolean)OADConfig.spawn_black_opal_end.get()).booleanValue()) break;
                    tooltip.add((Component)Component.m_237113_((String)"\u00a7cDISABLED"));
                    break;
                }
            }
            tooltip.add((Component)Component.m_237113_((String)"\u00a77\u00a7oHold \u00a76\u00a7oSHIFT\u00a77\u00a7o for more information"));
        }
    }
}

