/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks.helpers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import mod.alexndr.netherrocks.config.NetherrocksConfig;
import mod.alexndr.netherrocks.init.ModItems;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class NetherrocksLootModifiers {

    public static class GhastOreLootModifier
    extends LootModifier {
        public static final Supplier<Codec<GhastOreLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> GhastOreLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GhastOreLootModifier::new)));

        public GhastOreLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            if (!NetherrocksConfig.enableAshstoneGhastOre) {
                return generatedLoot;
            }
            ObjectArrayList ret = new ObjectArrayList();
            generatedLoot.forEach(x -> ret.add((Object)GhastOreLootModifier.substitute(x)));
            return ret;
        }

        protected static ItemStack substitute(ItemStack stack) {
            if (stack.m_41720_() == ModItems.ashstone_gem.get()) {
                return new ItemStack((ItemLike)Items.f_42586_);
            }
            return stack;
        }
    }

    public static class AutoSmeltLootModifier
    extends LootModifier {
        public static final Supplier<Codec<AutoSmeltLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AutoSmeltLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, AutoSmeltLootModifier::new)));

        public AutoSmeltLootModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @NotNull
        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            ObjectArrayList ret = new ObjectArrayList();
            generatedLoot.forEach(stack -> ret.add((Object)AutoSmeltLootModifier.smelt(stack, context)));
            return ret;
        }

        protected static ItemStack smelt(ItemStack stack, LootContext context) {
            return context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(AbstractCookingRecipe::m_8043_).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse(stack);
        }

        public Codec<? extends IGlobalLootModifier> codec() {
            return CODEC.get();
        }
    }
}

