/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks.helpers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.alexndr.netherrocks.config.ConfigHolder;
import mod.alexndr.netherrocks.init.ModBlocks;
import mod.alexndr.netherrocks.init.ModItems;
import mod.alexndr.netherrocks.init.ModTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.tags.ITag;

public final class NetherFurnaceFuelHandler {
    protected static int netherrackBurnTime = 0;
    protected static int fyriteBurnTime = 0;
    protected static int blazeRodBurnTime = 0;
    protected static int baseToolBurnTime = 0;
    protected static List<Item> validFuels = new ArrayList<Item>();
    protected static Map<Item, Integer> burnTimes = Maps.newLinkedHashMap();

    public static Map<Item, Integer> getBurnTimes() {
        if (burnTimes.isEmpty()) {
            burnTimes = NetherFurnaceFuelHandler.loadBurnTimes();
        }
        return burnTimes;
    }

    public static List<Item> getValidfuels() {
        if (validFuels.isEmpty()) {
            validFuels.addAll(NetherFurnaceFuelHandler.getBurnTimes().keySet());
        }
        return validFuels;
    }

    public static Map<Item, Integer> loadBurnTimes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        netherrackBurnTime = (Integer)ConfigHolder.SERVER.serverNetherrackBurnTime.get();
        fyriteBurnTime = (Integer)ConfigHolder.SERVER.serverFyriteBurnTime.get();
        blazeRodBurnTime = (Integer)ConfigHolder.SERVER.serverBlazeRodBurnTime.get();
        baseToolBurnTime = (Integer)ConfigHolder.SERVER.serverBaseToolBurnTime.get();
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)Blocks.f_50134_, netherrackBurnTime);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)ModItems.fyrite_ingot.get(), fyriteBurnTime);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)ModBlocks.fyrite_block.get(), fyriteBurnTime * 10);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)ModBlocks.fyrite_brick_slab.get(), fyriteBurnTime * 5);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)ModBlocks.fyrite_door.get(), fyriteBurnTime * 2);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)ModItems.fyrite_nugget.get(), fyriteBurnTime / 9);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)ModBlocks.fyrite_bars.get(), fyriteBurnTime / 2);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)Items.f_42585_, blazeRodBurnTime);
        NetherFurnaceFuelHandler.addItemBurnTime(map, (ItemLike)Items.f_42593_, blazeRodBurnTime / 3);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_tool"), baseToolBurnTime);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_ingot"), fyriteBurnTime);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_block"), fyriteBurnTime * 10);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_slab"), fyriteBurnTime * 5);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_door"), fyriteBurnTime * 2);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_bars"), fyriteBurnTime / 2);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_blaze_rod"), blazeRodBurnTime);
        NetherFurnaceFuelHandler.addItemTagBurnTime(map, ModTags.getnetherFurnaceFuels("as_blaze_powder"), blazeRodBurnTime / 3);
        return map;
    }

    protected static void addItemBurnTime(Map<Item, Integer> map, ItemLike itemProvider, int burnTimeIn) {
        map.put(itemProvider.m_5456_(), burnTimeIn);
    }

    protected static void addItemTagBurnTime(Map<Item, Integer> map, ITag<Item> iTag, int burnTimeIn) {
        iTag.stream().forEach(item -> map.put((Item)item, burnTimeIn));
    }
}

