/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks.datagen;

import mod.alexndr.netherrocks.init.ModBlocks;
import mod.alexndr.simplecorelib.api.content.MultifunctionPressurePlateBlock;
import mod.alexndr.simplecorelib.api.datagen.SimpleBlockStateProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class NetherrocksBlockStateProvider
extends SimpleBlockStateProvider {
    public NetherrocksBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "netherrocks", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.generateBrickStatesAndModels();
        this.generatePressurePlateStatesAndModels();
        this.generateBarStatesAndModels();
        this.generateDoorStatesAndModels();
    }

    private void generateBrickStatesAndModels() {
        this.simpleBlock((Block)ModBlocks.argonite_bricks.get(), (ModelFile)this.models().cubeAll("argonite_bricks", new ResourceLocation("netherrocks", "block/cut_argonite")));
        this.simpleBlock((Block)ModBlocks.fyrite_bricks.get(), (ModelFile)this.models().cubeAll("fyrite_bricks", new ResourceLocation("netherrocks", "block/cut_fyrite")));
        this.simpleBlock((Block)ModBlocks.illumenite_bricks.get(), (ModelFile)this.models().cubeAll("illumenite_bricks", new ResourceLocation("netherrocks", "block/cut_illumenite")));
        this.simpleBlock((Block)ModBlocks.malachite_bricks.get(), (ModelFile)this.models().cubeAll("malachite_bricks", new ResourceLocation("netherrocks", "block/cut_malachite")));
        this.simpleBlock((Block)ModBlocks.ashstone_bricks.get(), (ModelFile)this.models().cubeAll("ashstone_bricks", new ResourceLocation("netherrocks", "block/ashstone_small_bricks")));
        this.simpleBlock((Block)ModBlocks.dragonstone_bricks.get(), (ModelFile)this.models().cubeAll("dragonstone_bricks", new ResourceLocation("netherrocks", "block/dragonstone_bricks")));
        this.slabBlock((SlabBlock)ModBlocks.argonite_brick_slab.get(), new ResourceLocation("netherrocks", "block/argonite_bricks"), new ResourceLocation("netherrocks", "block/cut_argonite"));
        this.slabBlock((SlabBlock)ModBlocks.fyrite_brick_slab.get(), new ResourceLocation("netherrocks", "block/fyrite_bricks"), new ResourceLocation("netherrocks", "block/cut_fyrite"));
        this.slabBlock((SlabBlock)ModBlocks.illumenite_brick_slab.get(), new ResourceLocation("netherrocks", "block/illumenite_bricks"), new ResourceLocation("netherrocks", "block/cut_illumenite"));
        this.slabBlock((SlabBlock)ModBlocks.malachite_brick_slab.get(), new ResourceLocation("netherrocks", "block/malachite_bricks"), new ResourceLocation("netherrocks", "block/cut_malachite"));
        this.slabBlock((SlabBlock)ModBlocks.ashstone_brick_slab.get(), new ResourceLocation("netherrocks", "block/ashstone_bricks"), new ResourceLocation("netherrocks", "block/ashstone_small_bricks"));
        this.slabBlock((SlabBlock)ModBlocks.dragonstone_brick_slab.get(), new ResourceLocation("netherrocks", "block/dragonstone_bricks"), new ResourceLocation("netherrocks", "block/dragonstone_bricks"));
        this.stairsBlock((StairBlock)ModBlocks.argonite_brick_stairs.get(), new ResourceLocation("netherrocks", "block/cut_argonite"));
        this.stairsBlock((StairBlock)ModBlocks.fyrite_brick_stairs.get(), new ResourceLocation("netherrocks", "block/cut_fyrite"));
        this.stairsBlock((StairBlock)ModBlocks.illumenite_brick_stairs.get(), new ResourceLocation("netherrocks", "block/cut_illumenite"));
        this.stairsBlock((StairBlock)ModBlocks.malachite_brick_stairs.get(), new ResourceLocation("netherrocks", "block/cut_malachite"));
        this.stairsBlock((StairBlock)ModBlocks.ashstone_brick_stairs.get(), new ResourceLocation("netherrocks", "block/ashstone_small_bricks"));
        this.stairsBlock((StairBlock)ModBlocks.dragonstone_brick_stairs.get(), new ResourceLocation("netherrocks", "block/dragonstone_bricks"));
        this.itemModels().withExistingParent("argonite_bricks", new ResourceLocation("netherrocks", "block/argonite_bricks"));
        this.itemModels().withExistingParent("argonite_brick_slab", new ResourceLocation("netherrocks", "block/argonite_brick_slab"));
        this.itemModels().withExistingParent("argonite_brick_stairs", new ResourceLocation("netherrocks", "block/argonite_brick_stairs"));
        this.itemModels().withExistingParent("fyrite_bricks", new ResourceLocation("netherrocks", "block/fyrite_bricks"));
        this.itemModels().withExistingParent("fyrite_brick_slab", new ResourceLocation("netherrocks", "block/fyrite_brick_slab"));
        this.itemModels().withExistingParent("fyrite_brick_stairs", new ResourceLocation("netherrocks", "block/fyrite_brick_stairs"));
        this.itemModels().withExistingParent("illumenite_bricks", new ResourceLocation("netherrocks", "block/illumenite_bricks"));
        this.itemModels().withExistingParent("illumenite_brick_slab", new ResourceLocation("netherrocks", "block/illumenite_brick_slab"));
        this.itemModels().withExistingParent("illumenite_brick_stairs", new ResourceLocation("netherrocks", "block/illumenite_brick_stairs"));
        this.itemModels().withExistingParent("malachite_bricks", new ResourceLocation("netherrocks", "block/malachite_bricks"));
        this.itemModels().withExistingParent("malachite_brick_slab", new ResourceLocation("netherrocks", "block/malachite_brick_slab"));
        this.itemModels().withExistingParent("malachite_brick_stairs", new ResourceLocation("netherrocks", "block/malachite_brick_stairs"));
        this.itemModels().withExistingParent("ashstone_bricks", new ResourceLocation("netherrocks", "block/ashstone_bricks"));
        this.itemModels().withExistingParent("ashstone_brick_slab", new ResourceLocation("netherrocks", "block/ashstone_brick_slab"));
        this.itemModels().withExistingParent("ashstone_brick_stairs", new ResourceLocation("netherrocks", "block/ashstone_brick_stairs"));
        this.itemModels().withExistingParent("dragonstone_bricks", new ResourceLocation("netherrocks", "block/dragonstone_bricks"));
        this.itemModels().withExistingParent("dragonstone_brick_slab", new ResourceLocation("netherrocks", "block/dragonstone_brick_slab"));
        this.itemModels().withExistingParent("dragonstone_brick_stairs", new ResourceLocation("netherrocks", "block/dragonstone_brick_stairs"));
    }

    private void generatePressurePlateStatesAndModels() {
        ModelBuilder argonitePlateModel = this.models().pressurePlate("argonite_plate", new ResourceLocation("netherrocks", "block/argonite_block"));
        ModelBuilder argonitePlateModel_down = this.models().pressurePlateDown("argonite_plate_down", new ResourceLocation("netherrocks", "block/argonite_block"));
        ModelBuilder ashstonePlateModel = this.models().pressurePlate("ashstone_plate", new ResourceLocation("netherrocks", "block/ashstone_block"));
        ModelBuilder ashstonePlateModel_down = this.models().pressurePlateDown("ashstone_plate_down", new ResourceLocation("netherrocks", "block/ashstone_block"));
        ModelBuilder dragonstonePlateModel = this.models().pressurePlate("dragonstone_plate", new ResourceLocation("netherrocks", "block/dragonstone_block"));
        ModelBuilder dragonstonePlateModel_down = this.models().pressurePlateDown("dragonstone_plate_down", new ResourceLocation("netherrocks", "block/dragonstone_block"));
        ModelBuilder fyritePlateModel = this.models().pressurePlate("fyrite_plate", new ResourceLocation("netherrocks", "block/fyrite_block"));
        ModelBuilder fyritePlateModel_down = this.models().pressurePlateDown("fyrite_plate_down", new ResourceLocation("netherrocks", "block/fyrite_block"));
        ModelBuilder illumenitePlateModel = this.models().pressurePlate("illumenite_plate", new ResourceLocation("netherrocks", "block/illumenite_block"));
        ModelBuilder illumenitePlateModel_down = this.models().pressurePlateDown("illumenite_plate_down", new ResourceLocation("netherrocks", "block/illumenite_block"));
        ModelBuilder malachitePlateModel = this.models().pressurePlate("malachite_plate", new ResourceLocation("netherrocks", "block/malachite_block"));
        ModelBuilder malachitePlateModel_down = this.models().pressurePlateDown("malachite_plate_down", new ResourceLocation("netherrocks", "block/malachite_block"));
        this.itemModels().withExistingParent("argonite_pressure_plate", new ResourceLocation("netherrocks", "block/argonite_plate"));
        this.itemModels().withExistingParent("ashstone_pressure_plate", new ResourceLocation("netherrocks", "block/ashstone_plate"));
        this.itemModels().withExistingParent("dragonstone_pressure_plate", new ResourceLocation("netherrocks", "block/dragonstone_plate"));
        this.itemModels().withExistingParent("fyrite_pressure_plate", new ResourceLocation("netherrocks", "block/fyrite_plate"));
        this.itemModels().withExistingParent("illumenite_pressure_plate", new ResourceLocation("netherrocks", "block/illumenite_plate"));
        this.itemModels().withExistingParent("malachite_pressure_plate", new ResourceLocation("netherrocks", "block/malachite_plate"));
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.argonite_pressure_plate.get(), (ModelFile)argonitePlateModel, (ModelFile)argonitePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.ashstone_pressure_plate.get(), (ModelFile)ashstonePlateModel, (ModelFile)ashstonePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.dragonstone_pressure_plate.get(), (ModelFile)dragonstonePlateModel, (ModelFile)dragonstonePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.fyrite_pressure_plate.get(), (ModelFile)fyritePlateModel, (ModelFile)fyritePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.illumenite_pressure_plate.get(), (ModelFile)illumenitePlateModel, (ModelFile)illumenitePlateModel_down);
        this.buildWeightedPressurePlateBlockState((MultifunctionPressurePlateBlock)ModBlocks.malachite_pressure_plate.get(), (ModelFile)malachitePlateModel, (ModelFile)malachitePlateModel_down);
    }

    private void generateBarStatesAndModels() {
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.argonite_bars.get(), this.modLoc("block/argonite_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.fyrite_bars.get(), this.modLoc("block/fyrite_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.ashstone_bars.get(), this.modLoc("block/ashstone_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.dragonstone_bars.get(), this.modLoc("block/dragonstone_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.illumenite_bars.get(), this.modLoc("block/illumenite_bars"));
        this.buildBarsBlockState((IronBarsBlock)ModBlocks.malachite_bars.get(), this.modLoc("block/malachite_bars"));
        this.basicBlockItem((Block)ModBlocks.argonite_bars.get());
        this.basicBlockItem((Block)ModBlocks.fyrite_bars.get());
        this.basicBlockItem((Block)ModBlocks.ashstone_bars.get());
        this.basicBlockItem((Block)ModBlocks.dragonstone_bars.get());
        this.basicBlockItem((Block)ModBlocks.illumenite_bars.get());
        this.basicBlockItem((Block)ModBlocks.malachite_bars.get());
    }

    private void generateDoorStatesAndModels() {
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.argonite_door.get(), this.modLoc("block/argonite_door_lower"), this.modLoc("block/argonite_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.ashstone_door.get(), this.modLoc("block/ashstone_door_lower"), this.modLoc("block/ashstone_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.dragonstone_door.get(), this.modLoc("block/dragonstone_door_lower"), this.modLoc("block/dragonstone_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.fyrite_door.get(), this.modLoc("block/fyrite_door_lower"), this.modLoc("block/fyrite_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.illumenite_door.get(), this.modLoc("block/illumenite_door_lower"), this.modLoc("block/illumenite_door_upper"), "cutout");
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.malachite_door.get(), this.modLoc("block/malachite_door_lower"), this.modLoc("block/malachite_door_upper"), "cutout");
        this.itemModels().basicItem(((DoorBlock)ModBlocks.argonite_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.ashstone_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.dragonstone_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.fyrite_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.illumenite_door.get()).m_5456_());
        this.itemModels().basicItem(((DoorBlock)ModBlocks.malachite_door.get()).m_5456_());
    }
}

