/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class ServerConfig {
    final ForgeConfigSpec.BooleanValue serverAddModLootToChests;
    final ForgeConfigSpec.BooleanValue serverEnableAesthetics;
    final ForgeConfigSpec.BooleanValue serverEnableAshstoneGhastOre;
    public final ForgeConfigSpec.IntValue serverNetherrackBurnTime;
    public final ForgeConfigSpec.IntValue serverFyriteBurnTime;
    public final ForgeConfigSpec.IntValue serverBlazeRodBurnTime;
    public final ForgeConfigSpec.IntValue serverBaseToolBurnTime;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.serverAddModLootToChests = builder.comment("Add Netherrocks items to chest loot?").translation("netherrocks.config.serverAddModLootToChests").define("AddModLootToChests", true);
        this.serverEnableAesthetics = builder.comment("Enable Netherrocks aesthetic blocks?").translation("netherrocksconfig.EnableAesthetics").define("EnableAestheticsBlocks", true);
        this.serverEnableAshstoneGhastOre = builder.comment("Enable Ashstone to double as ghast tear ore?").translation("netherrocksconfig.EnableAshstoneGhastOre").define("EnableAshstoneGhastOre", false);
        builder.pop();
        builder.push("Nether Furnace Fuels");
        this.serverNetherrackBurnTime = builder.comment("Ticks to consume 1 block of netherrack").defineInRange("NetherrackBurnTime", 200, 1, 10000);
        this.serverFyriteBurnTime = builder.comment("Ticks to consume 1 ingot of fyrite: base for several other burn times").defineInRange("FyriteBurnTime", 8000, 1, 32000);
        this.serverBlazeRodBurnTime = builder.comment("Ticks to consume 1 blaze rod; base for certain other burn times").defineInRange("BlazeRodBurnTime", 2400, 1, 20000);
        this.serverBaseToolBurnTime = builder.comment("Ticks to consume 1 fyrite tool").defineInRange("BaseToolBurntime", 3200, 1, 32000);
        builder.pop();
    }
}

