/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks.client.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mod.alexndr.netherrocks.api.content.AbstractNetherFurnaceTileEntity;
import mod.alexndr.netherrocks.client.jei.NetherFurnaceFuelRecipe;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NetherFuelRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();

    private NetherFuelRecipeMaker() {
    }

    public static List<NetherFurnaceFuelRecipe> getFuelRecipes(IIngredientManager ingredientManager, IJeiHelpers helpers) {
        Collection allItemStacks = ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK);
        ArrayList<NetherFurnaceFuelRecipe> fuelRecipes = new ArrayList<NetherFurnaceFuelRecipe>();
        for (ItemStack stack : allItemStacks) {
            int burnTime = NetherFuelRecipeMaker.getBurnTime(stack);
            if (burnTime <= 0) continue;
            fuelRecipes.add(new NetherFurnaceFuelRecipe(Collections.singleton(stack), burnTime));
        }
        return fuelRecipes;
    }

    private static int getBurnTime(ItemStack itemStack) {
        try {
            return AbstractNetherFurnaceTileEntity.getBurnTime(itemStack, null);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = itemStack.toString();
            LOGGER.error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
            return 0;
        }
    }
}

