/*
 * Decompiled with CFR 0.152.
 */
package mod.alexndr.netherrocks.client.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mod.alexndr.netherrocks.client.gui.NetherBlastFurnaceScreen;
import mod.alexndr.netherrocks.client.gui.NetherFurnaceScreen;
import mod.alexndr.netherrocks.client.gui.NetherSmokerScreen;
import mod.alexndr.netherrocks.client.jei.NetherFuelCategory;
import mod.alexndr.netherrocks.client.jei.NetherFuelRecipeMaker;
import mod.alexndr.netherrocks.client.jei.NetherFurnaceFuelRecipe;
import mod.alexndr.netherrocks.content.NetherBlastFurnaceContainer;
import mod.alexndr.netherrocks.content.NetherFurnaceContainer;
import mod.alexndr.netherrocks.content.NetherSmokerContainer;
import mod.alexndr.netherrocks.init.ModBlocks;
import mod.alexndr.netherrocks.init.ModContainers;
import mod.alexndr.simplecorelib.api.content.VeryAbstractFurnaceBlock;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIMachinePlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("netherrocks", "nether_furnace_plugin");
    public static final RecipeType<NetherFurnaceFuelRecipe> NETHER_FUEL = RecipeType.create((String)"netherrocks", (String)"nether_fuel", NetherFurnaceFuelRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.nether_furnace.get()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.nether_blast_furnace.get()), new RecipeType[]{RecipeTypes.BLASTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.nether_smoker.get()), new RecipeType[]{RecipeTypes.SMOKING});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new NetherFuelCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IIngredientManager ingredientManager = registration.getIngredientManager();
        registration.addRecipes(NETHER_FUEL, NetherFuelRecipeMaker.getFuelRecipes(ingredientManager, jeiHelpers));
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)((VeryAbstractFurnaceBlock)ModBlocks.nether_furnace.get()).m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"netherrocks.nether_furnace.info")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)((VeryAbstractFurnaceBlock)ModBlocks.nether_blast_furnace.get()).m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"netherrocks.nether_blast_furnace.info")});
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)((VeryAbstractFurnaceBlock)ModBlocks.nether_smoker.get()).m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"netherrocks.nether_smoker.info")});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(NetherFurnaceContainer.class, (MenuType)ModContainers.NETHER_FURNACE.get(), RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(NetherFurnaceContainer.class, (MenuType)ModContainers.NETHER_FURNACE.get(), NETHER_FUEL, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(NetherSmokerContainer.class, (MenuType)ModContainers.NETHER_SMOKER.get(), RecipeTypes.SMOKING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(NetherSmokerContainer.class, (MenuType)ModContainers.NETHER_SMOKER.get(), NETHER_FUEL, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(NetherBlastFurnaceContainer.class, (MenuType)ModContainers.NETHER_BLAST_FURNACE.get(), RecipeTypes.BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(NetherBlastFurnaceContainer.class, (MenuType)ModContainers.NETHER_BLAST_FURNACE.get(), NETHER_FUEL, 1, 1, 3, 36);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(NetherFurnaceScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.SMELTING, NETHER_FUEL});
        registration.addRecipeClickArea(NetherSmokerScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.SMOKING, NETHER_FUEL});
        registration.addRecipeClickArea(NetherBlastFurnaceScreen.class, 78, 32, 28, 23, new RecipeType[]{RecipeTypes.BLASTING, NETHER_FUEL});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

